/*
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 1.4.1 on 2013-04-23 23:53:50,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.doxia.document;

/**
 * Contains meta-data information for the document cover page.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class DocumentCover
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The title to appear on the cover.
     *           
     */
    private String coverTitle;

    /**
     * 
     *             a sub-title to appear on the cover.
     *           
     */
    private String coverSubTitle;

    /**
     * 
     *             The version of the project that appears on the
     * cover page.
     *           
     */
    private String coverVersion;

    /**
     * 
     *             The type of the document. This might be used on
     * the cover page to
     *             specify the type of information contained in the
     * document
     *             (eg 'User Guide', 'Manual', etc.).
     *           
     */
    private String coverType;

    /**
     * 
     *             The date to appear on the cover.
     *             Use the ISO 8601 format
     * "yyyy-MM-dd'T'HH:mm:ss.SSS" in xml.
     *           
     */
    private java.util.Date coverDate;

    /**
     * 
     *             The date as String (recommended format is ISO
     * 8601) to appear on the cover.
     *             Only used if <code>coverDate</code> is not set.
     *             @since 1.1.1
     *           .
     */
    private String coverdate;

    /**
     * Field authors.
     */
    private java.util.List<DocumentAuthor> authors;

    /**
     * 
     *             A shortcut for the unique author that appears on
     * the cover page.
     *             For more authors, you could use the
     * &lt;authors/&gt; tag.
     *             @since 1.1.1
     *           .
     */
    private String author;

    /**
     * 
     *             The name of the project.
     *           
     */
    private String projectName;

    /**
     * 
     *             The location of an image file that represents
     * the project logo.
     *           
     */
    private String projectLogo;

    /**
     * 
     *             The name of the entity that is responsible for
     * the content of the
     *             document, or a copyright holder.
     *           
     */
    private String companyName;

    /**
     * 
     *             The location of an image file that represents
     * the company logo.
     *           
     */
    private String companyLogo;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addAuthor.
     * 
     * @param documentAuthor
     */
    public void addAuthor( DocumentAuthor documentAuthor )
    {
        getAuthors().add( documentAuthor );
    } //-- void addAuthor( DocumentAuthor )

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof DocumentCover ) )
        {
            return false;
        }

        DocumentCover that = (DocumentCover) other;
        boolean result = true;

        result = result && ( getCoverTitle() == null ? that.getCoverTitle() == null : getCoverTitle().equals( that.getCoverTitle() ) );
        result = result && ( getCoverSubTitle() == null ? that.getCoverSubTitle() == null : getCoverSubTitle().equals( that.getCoverSubTitle() ) );
        result = result && ( getCoverVersion() == null ? that.getCoverVersion() == null : getCoverVersion().equals( that.getCoverVersion() ) );
        result = result && ( getCoverType() == null ? that.getCoverType() == null : getCoverType().equals( that.getCoverType() ) );
        result = result && ( getCoverDate() == null ? that.getCoverDate() == null : getCoverDate().equals( that.getCoverDate() ) );
        result = result && ( getCoverdate() == null ? that.getCoverdate() == null : getCoverdate().equals( that.getCoverdate() ) );
        result = result && ( getAuthors() == null ? that.getAuthors() == null : getAuthors().equals( that.getAuthors() ) );
        result = result && ( getAuthor() == null ? that.getAuthor() == null : getAuthor().equals( that.getAuthor() ) );
        result = result && ( getProjectName() == null ? that.getProjectName() == null : getProjectName().equals( that.getProjectName() ) );
        result = result && ( getProjectLogo() == null ? that.getProjectLogo() == null : getProjectLogo().equals( that.getProjectLogo() ) );
        result = result && ( getCompanyName() == null ? that.getCompanyName() == null : getCompanyName().equals( that.getCompanyName() ) );
        result = result && ( getCompanyLogo() == null ? that.getCompanyLogo() == null : getCompanyLogo().equals( that.getCompanyLogo() ) );

        return result;
    } //-- boolean equals( Object )

    /**
     * Get a shortcut for the unique author that appears on the
     * cover page.
     *             For more authors, you could use the
     * &lt;authors/&gt; tag.
     *             @since 1.1.1.
     * 
     * @return String
     */
    public String getAuthor()
    {
        return this.author;
    } //-- String getAuthor()

    /**
     * Method getAuthors.
     * 
     * @return List
     */
    public java.util.List<DocumentAuthor> getAuthors()
    {
        if ( this.authors == null )
        {
            this.authors = new java.util.ArrayList<DocumentAuthor>();
        }

        return this.authors;
    } //-- java.util.List<DocumentAuthor> getAuthors()

    /**
     * Get the location of an image file that represents the
     * company logo.
     * 
     * @return String
     */
    public String getCompanyLogo()
    {
        return this.companyLogo;
    } //-- String getCompanyLogo()

    /**
     * Get the name of the entity that is responsible for the
     * content of the
     *             document, or a copyright holder.
     * 
     * @return String
     */
    public String getCompanyName()
    {
        return this.companyName;
    } //-- String getCompanyName()

    /**
     * Get the date to appear on the cover.
     *             Use the ISO 8601 format
     * "yyyy-MM-dd'T'HH:mm:ss.SSS" in xml.
     * 
     * @return Date
     */
    public java.util.Date getCoverDate()
    {
        return this.coverDate;
    } //-- java.util.Date getCoverDate()

    /**
     * Get a sub-title to appear on the cover.
     * 
     * @return String
     */
    public String getCoverSubTitle()
    {
        return this.coverSubTitle;
    } //-- String getCoverSubTitle()

    /**
     * Get the title to appear on the cover.
     * 
     * @return String
     */
    public String getCoverTitle()
    {
        return this.coverTitle;
    } //-- String getCoverTitle()

    /**
     * Get the type of the document. This might be used on the
     * cover page to
     *             specify the type of information contained in the
     * document
     *             (eg 'User Guide', 'Manual', etc.).
     * 
     * @return String
     */
    public String getCoverType()
    {
        return this.coverType;
    } //-- String getCoverType()

    /**
     * Get the version of the project that appears on the cover
     * page.
     * 
     * @return String
     */
    public String getCoverVersion()
    {
        return this.coverVersion;
    } //-- String getCoverVersion()

    /**
     * Get the location of an image file that represents the
     * project logo.
     * 
     * @return String
     */
    public String getProjectLogo()
    {
        return this.projectLogo;
    } //-- String getProjectLogo()

    /**
     * Get the name of the project.
     * 
     * @return String
     */
    public String getProjectName()
    {
        return this.projectName;
    } //-- String getProjectName()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( coverTitle != null ? coverTitle.hashCode() : 0 );
        result = 37 * result + ( coverSubTitle != null ? coverSubTitle.hashCode() : 0 );
        result = 37 * result + ( coverVersion != null ? coverVersion.hashCode() : 0 );
        result = 37 * result + ( coverType != null ? coverType.hashCode() : 0 );
        result = 37 * result + ( coverDate != null ? coverDate.hashCode() : 0 );
        result = 37 * result + ( coverdate != null ? coverdate.hashCode() : 0 );
        result = 37 * result + ( authors != null ? authors.hashCode() : 0 );
        result = 37 * result + ( author != null ? author.hashCode() : 0 );
        result = 37 * result + ( projectName != null ? projectName.hashCode() : 0 );
        result = 37 * result + ( projectLogo != null ? projectLogo.hashCode() : 0 );
        result = 37 * result + ( companyName != null ? companyName.hashCode() : 0 );
        result = 37 * result + ( companyLogo != null ? companyLogo.hashCode() : 0 );

        return result;
    } //-- int hashCode()

    /**
     * Method removeAuthor.
     * 
     * @param documentAuthor
     */
    public void removeAuthor( DocumentAuthor documentAuthor )
    {
        getAuthors().remove( documentAuthor );
    } //-- void removeAuthor( DocumentAuthor )

    /**
     * Set a shortcut for the unique author that appears on the
     * cover page.
     *             For more authors, you could use the
     * &lt;authors/&gt; tag.
     *             @since 1.1.1.
     * 
     * @param author
     */
    public void setAuthor( String author )
    {
        this.author = author;
    } //-- void setAuthor( String )

    /**
     * Set the authors that appear on the cover page.
     *             Only used if author is not given.
     * 
     * @param authors
     */
    public void setAuthors( java.util.List<DocumentAuthor> authors )
    {
        this.authors = authors;
    } //-- void setAuthors( java.util.List )

    /**
     * Set the location of an image file that represents the
     * company logo.
     * 
     * @param companyLogo
     */
    public void setCompanyLogo( String companyLogo )
    {
        this.companyLogo = companyLogo;
    } //-- void setCompanyLogo( String )

    /**
     * Set the name of the entity that is responsible for the
     * content of the
     *             document, or a copyright holder.
     * 
     * @param companyName
     */
    public void setCompanyName( String companyName )
    {
        this.companyName = companyName;
    } //-- void setCompanyName( String )

    /**
     * Set the date to appear on the cover.
     *             Use the ISO 8601 format
     * "yyyy-MM-dd'T'HH:mm:ss.SSS" in xml.
     * 
     * @param coverDate
     */
    public void setCoverDate( java.util.Date coverDate )
    {
        this.coverDate = coverDate;
    } //-- void setCoverDate( java.util.Date )

    /**
     * Set a sub-title to appear on the cover.
     * 
     * @param coverSubTitle
     */
    public void setCoverSubTitle( String coverSubTitle )
    {
        this.coverSubTitle = coverSubTitle;
    } //-- void setCoverSubTitle( String )

    /**
     * Set the title to appear on the cover.
     * 
     * @param coverTitle
     */
    public void setCoverTitle( String coverTitle )
    {
        this.coverTitle = coverTitle;
    } //-- void setCoverTitle( String )

    /**
     * Set the type of the document. This might be used on the
     * cover page to
     *             specify the type of information contained in the
     * document
     *             (eg 'User Guide', 'Manual', etc.).
     * 
     * @param coverType
     */
    public void setCoverType( String coverType )
    {
        this.coverType = coverType;
    } //-- void setCoverType( String )

    /**
     * Set the version of the project that appears on the cover
     * page.
     * 
     * @param coverVersion
     */
    public void setCoverVersion( String coverVersion )
    {
        this.coverVersion = coverVersion;
    } //-- void setCoverVersion( String )

    /**
     * Set the date as String (recommended format is ISO 8601) to
     * appear on the cover.
     *             Only used if <code>coverDate</code> is not set.
     *             @since 1.1.1.
     * 
     * @param coverdate
     */
    public void setCoverdate( String coverdate )
    {
        this.coverdate = coverdate;
    } //-- void setCoverdate( String )

    /**
     * Set the location of an image file that represents the
     * project logo.
     * 
     * @param projectLogo
     */
    public void setProjectLogo( String projectLogo )
    {
        this.projectLogo = projectLogo;
    } //-- void setProjectLogo( String )

    /**
     * Set the name of the project.
     * 
     * @param projectName
     */
    public void setProjectName( String projectName )
    {
        this.projectName = projectName;
    } //-- void setProjectName( String )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuilder buf = new StringBuilder( 128 );

        buf.append( "coverTitle = '" );
        buf.append( getCoverTitle() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "coverSubTitle = '" );
        buf.append( getCoverSubTitle() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "coverVersion = '" );
        buf.append( getCoverVersion() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "coverType = '" );
        buf.append( getCoverType() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "coverDate = '" );
        buf.append( getCoverDate() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "coverdate = '" );
        buf.append( getCoverdate() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "authors = '" );
        buf.append( getAuthors() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "author = '" );
        buf.append( getAuthor() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "projectName = '" );
        buf.append( getProjectName() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "projectLogo = '" );
        buf.append( getProjectLogo() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "companyName = '" );
        buf.append( getCompanyName() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "companyLogo = '" );
        buf.append( getCompanyLogo() );
        buf.append( "'" );

        return buf.toString();
    } //-- java.lang.String toString()

    
            
    /**
     * @return {@link #getAuthor()} if the unique author name is defined. Otherwise, return all authors full names
     * comma separated.
     * @see #getAuthor()
     * @see #getAuthors()
     * @since 1.1.1
     */
    public String getAllAuthorNames()
    {
        StringBuffer sb = new StringBuffer();
        if ( getAuthor() != null && getAuthor().trim().length() > 0 )
        {
            return getAuthor().trim();
        }

        if ( getAuthors() != null )
        {
            for ( java.util.Iterator it = getAuthors().iterator(); it.hasNext(); )
            {
                DocumentAuthor author = (DocumentAuthor) it.next();

                sb.append( author.getFullName().trim() );

                if ( it.hasNext() )
                {
                    sb.append( ", " );
                }
            }
        }

        return sb.toString();
    }

    /** ISO 8601 date format, i.e. <code>yyyy-MM-dd</code> **/
    private static final java.text.DateFormat ISO_8601_FORMAT = new java.text.SimpleDateFormat( "yyyy-MM-dd", java.util.Locale.ENGLISH );

    /**
     * Get the date to appear on the cover.
     *
     * @return the <code>getCoverDate()</code> if setted, formatted using ISO-8601 English format, otherwise return
     * the <code>coverdate</code>.
     * @since 1.1.1
     * @see #getCoverDate()
     */
    public String getCoverdate()
    {
        if ( getCoverDate() != null )
        {
            return ISO_8601_FORMAT.format( getCoverDate() );
        }

        return this.coverdate;
    }
            
          
}
