package org.apache.maven.doxia.module.site.manager;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.doxia.module.site.SiteModule;
import org.apache.maven.doxia.parser.module.ParserModuleManager;

import java.util.Collection;

/**
 * Handles SiteModule lookups.
 *
 * @author <a href="mailto:jason@maven.org">Jason van Zyl</a>
 * @version $Id: SiteModuleManager.java 1546011 2013-11-27 12:18:20Z hboutemy $
 * @since 1.0
 * @deprecated use ParserModuleManager
 * @see ParserModuleManager
 */
public interface SiteModuleManager
{
    /** The Plexus lookup role. */
    String ROLE = SiteModuleManager.class.getName();

    /**
     * Returns a collection of SiteModules.
     *
     * @return The SiteModules.
     */
    Collection<SiteModule> getSiteModules();

    /**
     * Returns the SiteModule that corresponds to the given id.
     *
     * @param id The identifier.
     * @return The corresponding SiteModule.
     * @throws org.apache.maven.doxia.module.site.manager.SiteModuleNotFoundException if no SiteModule could be found
     * for the given id.
     */
    SiteModule getSiteModule( String id )
        throws SiteModuleNotFoundException;
}
