/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.text.AttributeSet;
import org.apache.maven.doxia.sink.SinkEventAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinkEventAttributeSet
implements SinkEventAttributes,
Cloneable {
    public static final SinkEventAttributes UNDERLINE = new SinkEventAttributeSet("decoration", "underline").unmodifiable();
    public static final SinkEventAttributes OVERLINE = new SinkEventAttributeSet("decoration", "overline").unmodifiable();
    public static final SinkEventAttributes LINETHROUGH = new SinkEventAttributeSet("decoration", "line-through").unmodifiable();
    public static final SinkEventAttributes BOXED = new SinkEventAttributeSet("decoration", "boxed").unmodifiable();
    public static final SinkEventAttributes BOLD = new SinkEventAttributeSet("style", "bold").unmodifiable();
    public static final SinkEventAttributes ITALIC = new SinkEventAttributeSet("style", "italic").unmodifiable();
    public static final SinkEventAttributes MONOSPACED = new SinkEventAttributeSet("style", "monospaced").unmodifiable();
    public static final SinkEventAttributes LEFT = new SinkEventAttributeSet("align", "left").unmodifiable();
    public static final SinkEventAttributes RIGHT = new SinkEventAttributeSet("align", "right").unmodifiable();
    public static final SinkEventAttributes CENTER = new SinkEventAttributeSet("align", "center").unmodifiable();
    public static final SinkEventAttributes JUSTIFY = new SinkEventAttributeSet("align", "justify").unmodifiable();
    private Map<String, Object> attribs;
    private AttributeSet resolveParent;

    public SinkEventAttributeSet() {
        this(5);
    }

    public SinkEventAttributeSet(int size) {
        this.attribs = new LinkedHashMap<String, Object>(size);
    }

    public SinkEventAttributeSet(String ... attributes) {
        int n = attributes.length;
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Missing attribute!");
        }
        this.attribs = new LinkedHashMap<String, Object>(n / 2);
        for (int i = 0; i < n; i += 2) {
            this.attribs.put(attributes[i], attributes[i + 1]);
        }
    }

    public SinkEventAttributeSet(AttributeSet attributes) {
        this.attribs = new LinkedHashMap<String, Object>(attributes.getAttributeCount());
        Enumeration<?> names = attributes.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            this.attribs.put(name.toString(), attributes.getAttribute(name));
        }
    }

    public SinkEventAttributeSet unmodifiable() {
        this.attribs = Collections.unmodifiableMap(this.attribs);
        return this;
    }

    public boolean isEmpty() {
        return this.attribs.isEmpty();
    }

    public int getAttributeCount() {
        return this.attribs.size();
    }

    public boolean isDefined(Object attrName) {
        return this.attribs.containsKey(attrName);
    }

    public boolean isEqual(AttributeSet attr) {
        return this.getAttributeCount() == attr.getAttributeCount() && this.containsAttributes(attr);
    }

    public AttributeSet copyAttributes() {
        return (AttributeSet)this.clone();
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attribs.keySet());
    }

    public Object getAttribute(Object key) {
        AttributeSet parent;
        Object value = this.attribs.get(key);
        if (value == null && (parent = this.getResolveParent()) != null) {
            value = parent.getAttribute(key);
        }
        return value;
    }

    public boolean containsAttribute(Object name, Object value) {
        return value.equals(this.getAttribute(name));
    }

    public boolean containsAttributes(AttributeSet attributes) {
        boolean result = true;
        Enumeration<?> names = attributes.getAttributeNames();
        while (result && names.hasMoreElements()) {
            Object name = names.nextElement();
            result = attributes.getAttribute(name).equals(this.getAttribute(name));
        }
        return result;
    }

    public void addAttribute(Object name, Object value) {
        this.attribs.put(name.toString(), value);
    }

    public void addAttributes(AttributeSet attributes) {
        if (attributes == null || attributes.getAttributeCount() == 0) {
            return;
        }
        Enumeration<?> names = attributes.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            this.addAttribute(name, attributes.getAttribute(name));
        }
    }

    public void removeAttribute(Object name) {
        this.attribs.remove(name);
    }

    public void removeAttributes(Enumeration<?> names) {
        while (names.hasMoreElements()) {
            this.removeAttribute(names.nextElement());
        }
    }

    public void removeAttributes(AttributeSet attributes) {
        if (attributes == null) {
            return;
        }
        if (attributes == this) {
            this.attribs.clear();
        } else {
            Enumeration<?> names = attributes.getAttributeNames();
            while (names.hasMoreElements()) {
                Object name = names.nextElement();
                Object value = attributes.getAttribute(name);
                if (!value.equals(this.getAttribute(name))) continue;
                this.removeAttribute(name);
            }
        }
    }

    public AttributeSet getResolveParent() {
        return this.resolveParent;
    }

    public void setResolveParent(AttributeSet parent) {
        this.resolveParent = parent;
    }

    public Object clone() {
        SinkEventAttributeSet attr = new SinkEventAttributeSet(this.attribs.size());
        attr.attribs = new LinkedHashMap<String, Object>(this.attribs);
        if (this.resolveParent != null) {
            attr.resolveParent = this.resolveParent.copyAttributes();
        }
        return attr;
    }

    public int hashCode() {
        int parentHash = this.resolveParent == null ? 0 : this.resolveParent.hashCode();
        return this.attribs.hashCode() + parentHash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SinkEventAttributeSet) {
            return this.isEqual((AttributeSet)((Object)((SinkEventAttributeSet)obj)));
        }
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        Enumeration<String> names = this.getAttributeNames();
        while (names.hasMoreElements()) {
            String key = names.nextElement();
            String value = this.getAttribute(key).toString();
            s.append(' ').append(key).append('=').append(value);
        }
        return s.toString();
    }
}

