/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink.impl;

import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;

public class SinkUtils {
    public static final String[] SINK_BASE_ATTRIBUTES = new String[]{"class", "id", "lang", "style", "title"};
    public static final String[] SINK_BR_ATTRIBUTES = new String[]{"class", "id", "style", "title"};
    public static final String[] SINK_IMG_ATTRIBUTES;
    public static final String[] SINK_SECTION_ATTRIBUTES;
    public static final String[] SINK_VERBATIM_ATTRIBUTES;
    public static final String[] SINK_HR_ATTRIBUTES;
    public static final String[] SINK_LINK_ATTRIBUTES;
    public static final String[] SINK_TABLE_ATTRIBUTES;
    public static final String[] SINK_TD_ATTRIBUTES;
    public static final String[] SINK_TR_ATTRIBUTES;
    private static final String[] IMG_ATTRIBUTES;
    private static final String[] HR_ATTRIBUTES;
    private static final String[] LINK_ATTRIBUTES;
    private static final String[] TABLE_ATTRIBUTES;
    private static final String[] TABLE_CELL_ATTRIBUTES;

    private SinkUtils() {
    }

    private static String[] join(String[] a, String[] b) {
        Object[] temp = new String[a.length + b.length];
        System.arraycopy(a, 0, temp, 0, a.length);
        System.arraycopy(b, 0, temp, a.length, b.length);
        Arrays.sort(temp);
        return temp;
    }

    public static String getAttributeString(AttributeSet att) {
        if (att == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Enumeration<?> names = att.getAttributeNames();
        while (names.hasMoreElements()) {
            Object key = names.nextElement();
            Object value = att.getAttribute(key);
            if (value instanceof AttributeSet) {
                if (!"style".equals(key.toString())) continue;
                sb.append(' ').append(key.toString()).append('=').append('\"').append(SinkUtils.asCssString((AttributeSet)value)).append('\"');
                continue;
            }
            sb.append(' ').append(key.toString()).append('=').append('\"').append(value.toString()).append('\"');
        }
        return sb.toString();
    }

    private static String asCssString(AttributeSet att) {
        StringBuilder sb = new StringBuilder();
        Enumeration<?> names = att.getAttributeNames();
        while (names.hasMoreElements()) {
            Object key = names.nextElement();
            Object value = att.getAttribute(key);
            if (value instanceof AttributeSet) continue;
            sb.append(key.toString()).append(':').append(' ').append(value.toString());
            if (!names.hasMoreElements()) continue;
            sb.append(';').append(' ');
        }
        return sb.toString();
    }

    public static MutableAttributeSet filterAttributes(AttributeSet attributes, String[] valids) {
        if (attributes == null) {
            return null;
        }
        if (valids == null || valids.length == 0) {
            return new SinkEventAttributeSet(0);
        }
        SinkEventAttributeSet atts = new SinkEventAttributeSet(attributes.getAttributeCount());
        Enumeration<?> names = attributes.getAttributeNames();
        while (names.hasMoreElements()) {
            String key = names.nextElement().toString();
            if (Arrays.binarySearch(valids, key) < 0) continue;
            atts.addAttribute(key, attributes.getAttribute(key));
        }
        return atts;
    }

    static {
        IMG_ATTRIBUTES = new String[]{"align", "alt", "border", "height", "hspace", "ismap", "src", "usemap", "vspace", "width"};
        HR_ATTRIBUTES = new String[]{"align", "noshade", "size", "width"};
        LINK_ATTRIBUTES = new String[]{"charset", "coords", "href", "hreflang", "rel", "rev", "shape", "target", "type"};
        TABLE_ATTRIBUTES = new String[]{"align", "bgcolor", "border", "cellpadding", "cellspacing", "frame", "rules", "summary", "width"};
        TABLE_CELL_ATTRIBUTES = new String[]{"abbrv", "align", "axis", "bgcolor", "colspan", "headers", "height", "nowrap", "rowspan", "scope", "valign", "width"};
        SINK_IMG_ATTRIBUTES = SinkUtils.join(SINK_BASE_ATTRIBUTES, IMG_ATTRIBUTES);
        SINK_SECTION_ATTRIBUTES = SinkUtils.join(SINK_BASE_ATTRIBUTES, new String[]{"align"});
        SINK_VERBATIM_ATTRIBUTES = SinkUtils.join(SINK_BASE_ATTRIBUTES, new String[]{"align", "decoration", "width"});
        SINK_HR_ATTRIBUTES = SinkUtils.join(SINK_BASE_ATTRIBUTES, HR_ATTRIBUTES);
        SINK_LINK_ATTRIBUTES = SinkUtils.join(SINK_BASE_ATTRIBUTES, LINK_ATTRIBUTES);
        SINK_TABLE_ATTRIBUTES = SinkUtils.join(SINK_BASE_ATTRIBUTES, TABLE_ATTRIBUTES);
        SINK_TR_ATTRIBUTES = SinkUtils.join(SINK_BASE_ATTRIBUTES, new String[]{"align", "bgcolor", "valign"});
        SINK_TD_ATTRIBUTES = SinkUtils.join(SINK_BASE_ATTRIBUTES, TABLE_CELL_ATTRIBUTES);
    }
}

