/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.macro.toc;

import java.io.StringReader;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.doxia.index.IndexEntry;
import org.apache.maven.doxia.index.IndexingSink;
import org.apache.maven.doxia.macro.AbstractMacro;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.impl.SinkAdapter;
import org.apache.maven.doxia.util.DoxiaUtils;

@Singleton
@Named(value="toc")
public class TocMacro
extends AbstractMacro {
    private int section;
    private int fromDepth;
    private int toDepth;
    private static final int DEFAULT_DEPTH = 5;

    @Override
    public void execute(Sink sink, MacroRequest request) throws MacroExecutionException {
        String source = request.getSourceContent();
        Parser parser = request.getParser();
        this.section = TocMacro.getInt(request, "section", 0);
        this.fromDepth = TocMacro.getInt(request, "fromDepth", 0);
        this.toDepth = TocMacro.getInt(request, "toDepth", 5);
        if (this.fromDepth > this.toDepth) {
            return;
        }
        try (IndexingSink tocSink = new IndexingSink(new SinkAdapter());){
            parser.parse(new StringReader(source), tocSink);
        }
        IndexEntry index = tocSink.getRootEntry();
        if (index.getChildEntries().size() > 0) {
            sink.list(TocMacro.getAttributesFromMap(request.getParameters()));
            int i = 1;
            for (IndexEntry sectionIndex : index.getChildEntries()) {
                if (i == this.section || this.section == 0) {
                    this.writeSubSectionN(sink, sectionIndex, 1);
                }
                ++i;
            }
            sink.list_();
        }
    }

    private void writeSubSectionN(Sink sink, IndexEntry sectionIndex, int n) {
        if (this.fromDepth <= n) {
            sink.listItem();
            sink.link("#" + DoxiaUtils.encodeId(sectionIndex.getId()));
            sink.text(sectionIndex.getTitle());
            sink.link_();
        }
        if (this.toDepth > n && sectionIndex.getChildEntries().size() > 0) {
            if (this.fromDepth <= n) {
                sink.list();
            }
            for (IndexEntry subsectionIndex : sectionIndex.getChildEntries()) {
                if (n == this.toDepth - 1) {
                    sink.listItem();
                    sink.link("#" + DoxiaUtils.encodeId(subsectionIndex.getId()));
                    sink.text(subsectionIndex.getTitle());
                    sink.link_();
                    sink.listItem_();
                    continue;
                }
                this.writeSubSectionN(sink, subsectionIndex, n + 1);
            }
            if (this.fromDepth <= n) {
                sink.list_();
            }
        }
        if (this.fromDepth <= n) {
            sink.listItem_();
        }
    }

    private static int getInt(MacroRequest request, String parameter, int defaultValue) throws MacroExecutionException {
        int i;
        String value = (String)request.getParameter(parameter);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
        if (i < 0) {
            throw new MacroExecutionException("The " + parameter + "=" + i + " should be positive.");
        }
        return i;
    }
}

