/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.parser.module;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.doxia.parser.module.ParserModule;
import org.apache.maven.doxia.parser.module.ParserModuleManager;
import org.apache.maven.doxia.parser.module.ParserModuleNotFoundException;

@Singleton
@Named
public class DefaultParserModuleManager
implements ParserModuleManager {
    @Inject
    private Map<String, ParserModule> parserModules;
    private Collection<ParserModule> parserModulesValues;

    @Override
    public Collection<ParserModule> getParserModules() {
        if (this.parserModulesValues == null) {
            LinkedHashMap parserModulesTmp = new LinkedHashMap();
            for (ParserModule module : this.parserModules.values()) {
                parserModulesTmp.put(module.getClass(), module);
            }
            this.parserModulesValues = parserModulesTmp.values();
        }
        return this.parserModulesValues;
    }

    @Override
    public ParserModule getParserModule(String id) throws ParserModuleNotFoundException {
        ParserModule parserModule = this.parserModules.get(id);
        if (parserModule == null) {
            throw new ParserModuleNotFoundException("Cannot find parser module id = " + id);
        }
        return parserModule;
    }
}

