/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.markup.HtmlMarkup;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.AbstractXmlSink;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.impl.SinkUtils;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Xhtml5BaseSink
extends AbstractXmlSink
implements HtmlMarkup {
    private static final Logger LOGGER = LoggerFactory.getLogger(Xhtml5BaseSink.class);
    private final PrintWriter writer;
    private static final Pattern HIDDEN_CLASS_PATTERN = Pattern.compile("(?:.*\\s|^)hidden(?:\\s.*|$)");
    private StringBuffer textBuffer = new StringBuffer();
    private boolean headFlag;
    protected Stack<HTML.Tag> contentStack = new Stack();
    protected Stack<List<HTML.Tag>> inlineStack = new Stack();
    private boolean paragraphFlag;
    private boolean verbatimFlag;
    private final LinkedList<int[]> cellJustifStack;
    private final LinkedList<Boolean> isCellJustifStack;
    private final LinkedList<Integer> cellCountStack;
    private boolean evenTableRow = true;
    private final LinkedList<StringWriter> tableContentWriterStack;
    private final LinkedList<StringWriter> tableCaptionWriterStack;
    private final LinkedList<PrettyPrintXMLWriter> tableCaptionXMLWriterStack;
    private final LinkedList<String> tableCaptionStack;
    protected MutableAttributeSet tableAttributes;
    protected boolean tableRows = false;

    public Xhtml5BaseSink(Writer out) {
        this.writer = new PrintWriter(out);
        this.cellJustifStack = new LinkedList();
        this.isCellJustifStack = new LinkedList();
        this.cellCountStack = new LinkedList();
        this.tableContentWriterStack = new LinkedList();
        this.tableCaptionWriterStack = new LinkedList();
        this.tableCaptionXMLWriterStack = new LinkedList();
        this.tableCaptionStack = new LinkedList();
        this.init();
    }

    protected StringBuffer getTextBuffer() {
        return this.textBuffer;
    }

    protected void setHeadFlag(boolean headFlag) {
        this.headFlag = headFlag;
    }

    protected boolean isHeadFlag() {
        return this.headFlag;
    }

    protected void setVerbatimFlag(boolean verb) {
        this.verbatimFlag = verb;
    }

    protected boolean isVerbatimFlag() {
        return this.verbatimFlag;
    }

    protected void setCellJustif(int[] justif) {
        this.cellJustifStack.addLast(justif);
        this.isCellJustifStack.addLast(Boolean.TRUE);
    }

    protected int[] getCellJustif() {
        return this.cellJustifStack.getLast();
    }

    protected void setCellCount(int count) {
        this.cellCountStack.addLast(count);
    }

    protected int getCellCount() {
        return Integer.parseInt(this.cellCountStack.getLast().toString());
    }

    @Override
    protected void init() {
        super.init();
        this.resetTextBuffer();
        this.cellJustifStack.clear();
        this.isCellJustifStack.clear();
        this.cellCountStack.clear();
        this.tableContentWriterStack.clear();
        this.tableCaptionWriterStack.clear();
        this.tableCaptionXMLWriterStack.clear();
        this.tableCaptionStack.clear();
        this.inlineStack.clear();
        this.headFlag = false;
        this.paragraphFlag = false;
        this.verbatimFlag = false;
        this.evenTableRow = true;
        this.tableAttributes = null;
        this.tableRows = false;
    }

    protected void resetTextBuffer() {
        this.textBuffer = new StringBuffer();
    }

    @Override
    public void article() {
        this.article(null);
    }

    @Override
    public void article(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.ARTICLE, atts);
    }

    @Override
    public void article_() {
        this.writeEndTag(HtmlMarkup.ARTICLE);
    }

    @Override
    public void navigation() {
        this.navigation(null);
    }

    @Override
    public void navigation(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.NAV, atts);
    }

    @Override
    public void navigation_() {
        this.writeEndTag(HtmlMarkup.NAV);
    }

    @Override
    public void sidebar() {
        this.sidebar(null);
    }

    @Override
    public void sidebar(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.ASIDE, atts);
    }

    @Override
    public void sidebar_() {
        this.writeEndTag(HtmlMarkup.ASIDE);
    }

    @Override
    public void section(int level, SinkEventAttributes attributes) {
        this.onSection(level, attributes);
    }

    @Override
    public void sectionTitle(int level, SinkEventAttributes attributes) {
        this.onSectionTitle(level, attributes);
    }

    @Override
    public void sectionTitle_(int level) {
        this.onSectionTitle_(level);
    }

    @Override
    public void section_(int level) {
        this.onSection_(level);
    }

    @Override
    public void section1() {
        this.onSection(1, null);
    }

    @Override
    public void sectionTitle1() {
        this.onSectionTitle(1, null);
    }

    @Override
    public void sectionTitle1_() {
        this.onSectionTitle_(1);
    }

    @Override
    public void section1_() {
        this.onSection_(1);
    }

    @Override
    public void section2() {
        this.onSection(2, null);
    }

    @Override
    public void sectionTitle2() {
        this.onSectionTitle(2, null);
    }

    @Override
    public void sectionTitle2_() {
        this.onSectionTitle_(2);
    }

    @Override
    public void section2_() {
        this.onSection_(2);
    }

    @Override
    public void section3() {
        this.onSection(3, null);
    }

    @Override
    public void sectionTitle3() {
        this.onSectionTitle(3, null);
    }

    @Override
    public void sectionTitle3_() {
        this.onSectionTitle_(3);
    }

    @Override
    public void section3_() {
        this.onSection_(3);
    }

    @Override
    public void section4() {
        this.onSection(4, null);
    }

    @Override
    public void sectionTitle4() {
        this.onSectionTitle(4, null);
    }

    @Override
    public void sectionTitle4_() {
        this.onSectionTitle_(4);
    }

    @Override
    public void section4_() {
        this.onSection_(4);
    }

    @Override
    public void section5() {
        this.onSection(5, null);
    }

    @Override
    public void sectionTitle5() {
        this.onSectionTitle(5, null);
    }

    @Override
    public void sectionTitle5_() {
        this.onSectionTitle_(5);
    }

    @Override
    public void section5_() {
        this.onSection_(5);
    }

    protected void onSection(int depth, SinkEventAttributes attributes) {
        if (depth >= 1 && depth <= 5) {
            SinkEventAttributeSet att = new SinkEventAttributeSet();
            att.addAttributes(SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BASE_ATTRIBUTES));
            this.writeStartTag(HtmlMarkup.SECTION, (MutableAttributeSet)((Object)att));
        }
    }

    protected void onSection_(int depth) {
        if (depth >= 1 && depth <= 5) {
            this.writeEndTag(HtmlMarkup.SECTION);
        }
    }

    protected void onSectionTitle(int depth, SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        if (depth == 1) {
            this.writeStartTag(HtmlMarkup.H1, atts);
        } else if (depth == 2) {
            this.writeStartTag(HtmlMarkup.H2, atts);
        } else if (depth == 3) {
            this.writeStartTag(HtmlMarkup.H3, atts);
        } else if (depth == 4) {
            this.writeStartTag(HtmlMarkup.H4, atts);
        } else if (depth == 5) {
            this.writeStartTag(HtmlMarkup.H5, atts);
        }
    }

    protected void onSectionTitle_(int depth) {
        if (depth == 1) {
            this.writeEndTag(HtmlMarkup.H1);
        } else if (depth == 2) {
            this.writeEndTag(HtmlMarkup.H2);
        } else if (depth == 3) {
            this.writeEndTag(HtmlMarkup.H3);
        } else if (depth == 4) {
            this.writeEndTag(HtmlMarkup.H4);
        } else if (depth == 5) {
            this.writeEndTag(HtmlMarkup.H5);
        }
    }

    @Override
    public void header() {
        this.header(null);
    }

    @Override
    public void header(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.HEADER, atts);
    }

    @Override
    public void header_() {
        this.writeEndTag(HtmlMarkup.HEADER);
    }

    @Override
    public void content() {
        this.content((SinkEventAttributes)null);
    }

    @Override
    public void content(SinkEventAttributes attributes) {
        Object atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        if (this.contentStack.empty()) {
            this.writeStartTag(this.contentStack.push(HtmlMarkup.MAIN), (MutableAttributeSet)atts);
        } else {
            if (atts == null) {
                atts = new SinkEventAttributeSet(1);
            }
            if (!atts.isDefined("class")) {
                atts.addAttribute("class", "content");
            }
            this.writeStartTag(this.contentStack.push(HtmlMarkup.DIV), (MutableAttributeSet)atts);
        }
    }

    @Override
    public void content_() {
        try {
            this.writeEndTag(this.contentStack.pop());
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    @Override
    public void footer() {
        this.footer(null);
    }

    @Override
    public void footer(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.FOOTER, atts);
    }

    @Override
    public void footer_() {
        this.writeEndTag(HtmlMarkup.FOOTER);
    }

    @Override
    public void list() {
        this.list(null);
    }

    @Override
    public void list(SinkEventAttributes attributes) {
        if (this.paragraphFlag) {
            this.paragraph_();
        }
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.UL, atts);
    }

    @Override
    public void list_() {
        this.writeEndTag(HtmlMarkup.UL);
    }

    @Override
    public void listItem() {
        this.listItem(null);
    }

    @Override
    public void listItem(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.LI, atts);
    }

    @Override
    public void listItem_() {
        this.writeEndTag(HtmlMarkup.LI);
    }

    @Override
    public void numberedList(int numbering) {
        this.numberedList(numbering, null);
    }

    @Override
    public void numberedList(int numbering, SinkEventAttributes attributes) {
        String style;
        if (this.paragraphFlag) {
            this.paragraph_();
        }
        switch (numbering) {
            case 2: {
                style = "upper-alpha";
                break;
            }
            case 1: {
                style = "lower-alpha";
                break;
            }
            case 4: {
                style = "upper-roman";
                break;
            }
            case 3: {
                style = "lower-roman";
                break;
            }
            default: {
                style = "decimal";
            }
        }
        Object atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        if (atts == null) {
            atts = new SinkEventAttributeSet(1);
        }
        atts.addAttribute(HTML.Attribute.STYLE, "list-style-type: " + style);
        this.writeStartTag(HtmlMarkup.OL, (MutableAttributeSet)atts);
    }

    @Override
    public void numberedList_() {
        this.writeEndTag(HtmlMarkup.OL);
    }

    @Override
    public void numberedListItem() {
        this.numberedListItem(null);
    }

    @Override
    public void numberedListItem(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.LI, atts);
    }

    @Override
    public void numberedListItem_() {
        this.writeEndTag(HtmlMarkup.LI);
    }

    @Override
    public void definitionList() {
        this.definitionList(null);
    }

    @Override
    public void definitionList(SinkEventAttributes attributes) {
        if (this.paragraphFlag) {
            this.paragraph_();
        }
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.DL, atts);
    }

    @Override
    public void definitionList_() {
        this.writeEndTag(HtmlMarkup.DL);
    }

    @Override
    public void definedTerm(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.DT, atts);
    }

    @Override
    public void definedTerm() {
        this.definedTerm(null);
    }

    @Override
    public void definedTerm_() {
        this.writeEndTag(HtmlMarkup.DT);
    }

    @Override
    public void definition() {
        this.definition(null);
    }

    @Override
    public void definition(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.DD, atts);
    }

    @Override
    public void definition_() {
        this.writeEndTag(HtmlMarkup.DD);
    }

    @Override
    public void figure() {
        this.figure(null);
    }

    @Override
    public void figure(SinkEventAttributes attributes) {
        this.writeStartTag(HtmlMarkup.FIGURE, (MutableAttributeSet)attributes);
    }

    @Override
    public void figure_() {
        this.writeEndTag(HtmlMarkup.FIGURE);
    }

    @Override
    public void figureGraphics(String name) {
        this.figureGraphics(name, null);
    }

    @Override
    public void figureGraphics(String src, SinkEventAttributes attributes) {
        MutableAttributeSet filtered = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_IMG_ATTRIBUTES);
        if (filtered != null) {
            filtered.removeAttribute(HTML.Attribute.SRC.toString());
        }
        int count = attributes == null ? 1 : attributes.getAttributeCount() + 1;
        SinkEventAttributeSet atts = new SinkEventAttributeSet(count);
        atts.addAttribute(HTML.Attribute.SRC, HtmlTools.escapeHTML(src, true));
        atts.addAttributes(filtered);
        if (atts.getAttribute(HTML.Attribute.ALT.toString()) == null) {
            atts.addAttribute(HTML.Attribute.ALT.toString(), "");
        }
        this.writeStartTag(HtmlMarkup.IMG, (MutableAttributeSet)((Object)atts), true);
    }

    @Override
    public void figureCaption() {
        this.figureCaption(null);
    }

    @Override
    public void figureCaption(SinkEventAttributes attributes) {
        this.writeStartTag(HtmlMarkup.FIGCAPTION, (MutableAttributeSet)attributes);
    }

    @Override
    public void figureCaption_() {
        this.writeEndTag(HtmlMarkup.FIGCAPTION);
    }

    @Override
    public void paragraph() {
        this.paragraph(null);
    }

    @Override
    public void paragraph(SinkEventAttributes attributes) {
        this.paragraphFlag = true;
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.P, atts);
    }

    @Override
    public void paragraph_() {
        if (this.paragraphFlag) {
            this.writeEndTag(HtmlMarkup.P);
            this.paragraphFlag = false;
        }
    }

    @Override
    public void data(String value) {
        this.data(value, null);
    }

    @Override
    public void data(String value, SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        if (value != null) {
            att.addAttribute(HTML.Attribute.VALUE, value);
        }
        att.addAttributes(atts);
        this.writeStartTag(HtmlMarkup.DATA, (MutableAttributeSet)((Object)att));
    }

    @Override
    public void data_() {
        this.writeEndTag(HtmlMarkup.DATA);
    }

    @Override
    public void time(String datetime) {
        this.time(datetime, null);
    }

    @Override
    public void time(String datetime, SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        if (datetime != null) {
            att.addAttribute("datetime", datetime);
        }
        att.addAttributes(atts);
        this.writeStartTag(HtmlMarkup.TIME, (MutableAttributeSet)((Object)att));
    }

    @Override
    public void time_() {
        this.writeEndTag(HtmlMarkup.TIME);
    }

    @Override
    public void address() {
        this.address(null);
    }

    @Override
    public void address(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.ADDRESS, atts);
    }

    @Override
    public void address_() {
        this.writeEndTag(HtmlMarkup.ADDRESS);
    }

    @Override
    public void blockquote() {
        this.blockquote(null);
    }

    @Override
    public void blockquote(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.BLOCKQUOTE, atts);
    }

    @Override
    public void blockquote_() {
        this.writeEndTag(HtmlMarkup.BLOCKQUOTE);
    }

    @Override
    public void division() {
        this.division(null);
    }

    @Override
    public void division(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.DIV, atts);
    }

    @Override
    public void division_() {
        this.writeEndTag(HtmlMarkup.DIV);
    }

    @Override
    public void verbatim(SinkEventAttributes attributes) {
        if (this.paragraphFlag) {
            this.paragraph_();
        }
        this.verbatimFlag = true;
        Object atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_VERBATIM_ATTRIBUTES);
        if (atts == null) {
            atts = new SinkEventAttributeSet();
        }
        boolean boxed = false;
        if (atts.isDefined("decoration")) {
            boxed = "boxed".equals(atts.getAttribute("decoration").toString());
        }
        SinkEventAttributeSet divAtts = null;
        if (boxed) {
            divAtts = new SinkEventAttributeSet(HTML.Attribute.CLASS.toString(), "source");
        }
        atts.removeAttribute("decoration");
        this.writeStartTag(HtmlMarkup.DIV, (MutableAttributeSet)((Object)divAtts));
        this.writeStartTag(HtmlMarkup.PRE, (MutableAttributeSet)atts);
    }

    @Override
    public void verbatim_() {
        this.writeEndTag(HtmlMarkup.PRE);
        this.writeEndTag(HtmlMarkup.DIV);
        this.verbatimFlag = false;
    }

    @Override
    public void horizontalRule() {
        this.horizontalRule(null);
    }

    @Override
    public void horizontalRule(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_HR_ATTRIBUTES);
        this.writeSimpleTag(HtmlMarkup.HR, atts);
    }

    @Override
    public void table() {
        this.table(null);
    }

    @Override
    public void table(SinkEventAttributes attributes) {
        this.tableContentWriterStack.addLast(new StringWriter());
        this.tableRows = false;
        if (this.paragraphFlag) {
            this.paragraph_();
        }
        this.tableAttributes = attributes == null ? new SinkEventAttributeSet(0) : SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_TABLE_ATTRIBUTES);
    }

    @Override
    public void table_() {
        this.tableRows = false;
        this.writeEndTag(HtmlMarkup.TABLE);
        if (!this.cellCountStack.isEmpty()) {
            this.cellCountStack.removeLast().toString();
        }
        if (this.tableContentWriterStack.isEmpty()) {
            LOGGER.warn("No table content");
            return;
        }
        String tableContent = this.tableContentWriterStack.removeLast().toString();
        String tableCaption = null;
        if (!this.tableCaptionStack.isEmpty() && this.tableCaptionStack.getLast() != null) {
            tableCaption = this.tableCaptionStack.removeLast();
        }
        if (tableCaption != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(tableContent, 0, tableContent.indexOf(62) + 1);
            sb.append(tableCaption);
            sb.append(tableContent.substring(tableContent.indexOf(62) + 1));
            this.write(sb.toString());
        } else {
            this.write(tableContent);
        }
    }

    @Override
    public void tableRows(int[] justification, boolean grid) {
        this.tableRows = true;
        this.setCellJustif(justification);
        if (this.tableAttributes == null) {
            this.tableAttributes = new SinkEventAttributeSet(0);
        }
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        if (!this.tableAttributes.isDefined(HTML.Attribute.BORDER.toString())) {
            att.addAttribute(HTML.Attribute.BORDER, grid ? "1" : "0");
        }
        if (!this.tableAttributes.isDefined(HTML.Attribute.CLASS.toString())) {
            att.addAttribute(HTML.Attribute.CLASS, "bodyTable");
        }
        att.addAttributes(this.tableAttributes);
        this.tableAttributes.removeAttributes(this.tableAttributes);
        this.writeStartTag(HtmlMarkup.TABLE, (MutableAttributeSet)((Object)att));
        this.cellCountStack.addLast(0);
    }

    @Override
    public void tableRows_() {
        this.tableRows = false;
        if (!this.cellJustifStack.isEmpty()) {
            this.cellJustifStack.removeLast();
        }
        if (!this.isCellJustifStack.isEmpty()) {
            this.isCellJustifStack.removeLast();
        }
        this.evenTableRow = true;
    }

    @Override
    public void tableRow() {
        if (!this.tableRows) {
            this.tableRows(null, false);
        }
        this.tableRow(null);
    }

    @Override
    public void tableRow(SinkEventAttributes attributes) {
        Object attrs = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_TR_ATTRIBUTES);
        if (attrs == null) {
            attrs = new SinkEventAttributeSet();
        }
        String rowClass = this.evenTableRow ? "a" : "b";
        boolean hidden = false;
        if (attrs.isDefined(HTML.Attribute.CLASS.toString())) {
            String givenRowClass = (String)attrs.getAttribute(HTML.Attribute.CLASS.toString());
            if (HIDDEN_CLASS_PATTERN.matcher(givenRowClass).matches()) {
                hidden = true;
            }
            rowClass = givenRowClass + " " + rowClass;
        }
        attrs.addAttribute(HTML.Attribute.CLASS, rowClass);
        this.writeStartTag(HtmlMarkup.TR, (MutableAttributeSet)attrs);
        if (!hidden) {
            boolean bl = this.evenTableRow = !this.evenTableRow;
        }
        if (!this.cellCountStack.isEmpty()) {
            this.cellCountStack.removeLast();
            this.cellCountStack.addLast(0);
        }
    }

    @Override
    public void tableRow_() {
        this.writeEndTag(HtmlMarkup.TR);
    }

    @Override
    public void tableCell() {
        this.tableCell(null);
    }

    @Override
    public void tableHeaderCell() {
        this.tableHeaderCell(null);
    }

    @Override
    public void tableCell(SinkEventAttributes attributes) {
        this.tableCell(false, (MutableAttributeSet)attributes);
    }

    @Override
    public void tableHeaderCell(SinkEventAttributes attributes) {
        this.tableCell(true, (MutableAttributeSet)attributes);
    }

    private void tableCell(boolean headerRow, MutableAttributeSet attributes) {
        int cellCount;
        HTML.Tag t;
        HTML.Tag tag = t = headerRow ? HtmlMarkup.TH : HtmlMarkup.TD;
        if (!(headerRow || this.cellCountStack == null || this.cellCountStack.isEmpty() || this.cellJustifStack == null || this.cellJustifStack.isEmpty() || this.getCellJustif() == null || (cellCount = this.getCellCount()) >= this.getCellJustif().length)) {
            HashMap<Integer, SinkEventAttributes> hash = new HashMap<Integer, SinkEventAttributes>();
            hash.put(0, SinkEventAttributeSet.CENTER);
            hash.put(1, SinkEventAttributeSet.LEFT);
            hash.put(2, SinkEventAttributeSet.RIGHT);
            MutableAttributeSet atts = (MutableAttributeSet)hash.get(this.getCellJustif()[cellCount]);
            if (attributes == null) {
                attributes = new SinkEventAttributeSet();
            }
            if (atts != null) {
                attributes.addAttributes(atts);
            }
        }
        if (attributes == null) {
            this.writeStartTag(t, null);
        } else {
            this.writeStartTag(t, SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_TD_ATTRIBUTES));
        }
    }

    @Override
    public void tableCell_() {
        this.tableCell_(false);
    }

    @Override
    public void tableHeaderCell_() {
        this.tableCell_(true);
    }

    private void tableCell_(boolean headerRow) {
        HTML.Tag t = headerRow ? HtmlMarkup.TH : HtmlMarkup.TD;
        this.writeEndTag(t);
        if (!this.isCellJustifStack.isEmpty() && this.isCellJustifStack.getLast().equals(Boolean.TRUE) && !this.cellCountStack.isEmpty()) {
            int cellCount = Integer.parseInt(this.cellCountStack.removeLast().toString());
            this.cellCountStack.addLast(++cellCount);
        }
    }

    @Override
    public void tableCaption() {
        this.tableCaption(null);
    }

    @Override
    public void tableCaption(SinkEventAttributes attributes) {
        StringWriter sw = new StringWriter();
        this.tableCaptionWriterStack.addLast(sw);
        this.tableCaptionXMLWriterStack.addLast(new PrettyPrintXMLWriter((Writer)sw));
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.CAPTION, atts);
    }

    @Override
    public void tableCaption_() {
        this.writeEndTag(HtmlMarkup.CAPTION);
        if (!this.tableCaptionXMLWriterStack.isEmpty() && this.tableCaptionXMLWriterStack.getLast() != null) {
            this.tableCaptionStack.addLast(this.tableCaptionWriterStack.removeLast().toString());
            this.tableCaptionXMLWriterStack.removeLast();
        }
    }

    @Override
    public void anchor(String name) {
        this.anchor(name, null);
    }

    @Override
    public void anchor(String name, SinkEventAttributes attributes) {
        Objects.requireNonNull(name, "name cannot be null");
        if (this.headFlag) {
            return;
        }
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        String id = name;
        if (!DoxiaUtils.isValidId(id)) {
            id = DoxiaUtils.encodeId(name, true);
            LOGGER.debug("Modified invalid anchor name '{}' to '{}'", (Object)name, (Object)id);
        }
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        att.addAttribute(HTML.Attribute.NAME, id);
        att.addAttributes(atts);
        this.writeStartTag(HtmlMarkup.A, (MutableAttributeSet)((Object)att));
    }

    @Override
    public void anchor_() {
        if (!this.headFlag) {
            this.writeEndTag(HtmlMarkup.A);
        }
    }

    @Override
    public void link(String name) {
        this.link(name, null);
    }

    @Override
    public void link(String name, SinkEventAttributes attributes) {
        Objects.requireNonNull(name, "name cannot be null");
        if (this.headFlag) {
            return;
        }
        Object atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_LINK_ATTRIBUTES);
        if (atts == null) {
            atts = new SinkEventAttributeSet();
        }
        if (DoxiaUtils.isExternalLink(name)) {
            String linkClass = "externalLink";
            if (atts.isDefined(HTML.Attribute.CLASS.toString())) {
                String givenLinkClass = (String)atts.getAttribute(HTML.Attribute.CLASS.toString());
                linkClass = givenLinkClass + " " + linkClass;
            }
            atts.addAttribute(HTML.Attribute.CLASS, linkClass);
        }
        atts.addAttribute(HTML.Attribute.HREF, HtmlTools.escapeHTML(name));
        this.writeStartTag(HtmlMarkup.A, (MutableAttributeSet)atts);
    }

    @Override
    public void link_() {
        if (!this.headFlag) {
            this.writeEndTag(HtmlMarkup.A);
        }
    }

    @Override
    public void inline() {
        this.inline(null);
    }

    private void inlineSemantics(SinkEventAttributes attributes, String semantic, List<HTML.Tag> tags, HTML.Tag tag) {
        if (attributes.containsAttribute((Object)"semantics", (Object)semantic)) {
            SinkEventAttributes attributesNoSemantics = (SinkEventAttributes)attributes.copyAttributes();
            attributesNoSemantics.removeAttribute((Object)"semantics");
            this.writeStartTag(tag, (MutableAttributeSet)attributesNoSemantics);
            tags.add(0, tag);
        }
    }

    @Override
    public void inline(SinkEventAttributes attributes) {
        if (!this.headFlag) {
            ArrayList<HTML.Tag> tags = new ArrayList<HTML.Tag>();
            if (attributes != null) {
                this.inlineSemantics(attributes, "emphasis", tags, HtmlMarkup.EM);
                this.inlineSemantics(attributes, "strong", tags, HtmlMarkup.STRONG);
                this.inlineSemantics(attributes, "small", tags, HtmlMarkup.SMALL);
                this.inlineSemantics(attributes, "line-through", tags, HtmlMarkup.S);
                this.inlineSemantics(attributes, "citation", tags, HtmlMarkup.CITE);
                this.inlineSemantics(attributes, "quote", tags, HtmlMarkup.Q);
                this.inlineSemantics(attributes, "definition", tags, HtmlMarkup.DFN);
                this.inlineSemantics(attributes, "abbreviation", tags, HtmlMarkup.ABBR);
                this.inlineSemantics(attributes, "italic", tags, HtmlMarkup.I);
                this.inlineSemantics(attributes, "bold", tags, HtmlMarkup.B);
                this.inlineSemantics(attributes, "code", tags, HtmlMarkup.CODE);
                this.inlineSemantics(attributes, "variable", tags, HtmlMarkup.VAR);
                this.inlineSemantics(attributes, "sample", tags, HtmlMarkup.SAMP);
                this.inlineSemantics(attributes, "keyboard", tags, HtmlMarkup.KBD);
                this.inlineSemantics(attributes, "superscript", tags, HtmlMarkup.SUP);
                this.inlineSemantics(attributes, "subscript", tags, HtmlMarkup.SUB);
                this.inlineSemantics(attributes, "annotation", tags, HtmlMarkup.U);
                this.inlineSemantics(attributes, "highlight", tags, HtmlMarkup.MARK);
                this.inlineSemantics(attributes, "ruby", tags, HtmlMarkup.RUBY);
                this.inlineSemantics(attributes, "rubyBase", tags, HtmlMarkup.RB);
                this.inlineSemantics(attributes, "rubyText", tags, HtmlMarkup.RT);
                this.inlineSemantics(attributes, "rubyTextContainer", tags, HtmlMarkup.RTC);
                this.inlineSemantics(attributes, "rubyParentheses", tags, HtmlMarkup.RP);
                this.inlineSemantics(attributes, "bidirectionalIsolation", tags, HtmlMarkup.BDI);
                this.inlineSemantics(attributes, "bidirectionalOverride", tags, HtmlMarkup.BDO);
                this.inlineSemantics(attributes, "phrase", tags, HtmlMarkup.SPAN);
                this.inlineSemantics(attributes, "insert", tags, HtmlMarkup.INS);
                this.inlineSemantics(attributes, "delete", tags, HtmlMarkup.DEL);
            }
            this.inlineStack.push(tags);
        }
    }

    @Override
    public void inline_() {
        if (!this.headFlag) {
            for (HTML.Tag tag : this.inlineStack.pop()) {
                this.writeEndTag(tag);
            }
        }
    }

    @Override
    public void italic() {
        this.inline(SinkEventAttributeSet.Semantics.ITALIC);
    }

    @Override
    public void italic_() {
        this.inline_();
    }

    @Override
    public void bold() {
        this.inline(SinkEventAttributeSet.Semantics.BOLD);
    }

    @Override
    public void bold_() {
        this.inline_();
    }

    @Override
    public void monospaced() {
        this.inline(SinkEventAttributeSet.Semantics.CODE);
    }

    @Override
    public void monospaced_() {
        this.inline_();
    }

    @Override
    public void lineBreak() {
        this.lineBreak(null);
    }

    @Override
    public void lineBreak(SinkEventAttributes attributes) {
        if (this.headFlag || this.isVerbatimFlag()) {
            this.getTextBuffer().append(EOL);
        } else {
            MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BR_ATTRIBUTES);
            this.writeSimpleTag(HtmlMarkup.BR, atts);
        }
    }

    @Override
    public void lineBreakOpportunity() {
        this.lineBreakOpportunity(null);
    }

    @Override
    public void lineBreakOpportunity(SinkEventAttributes attributes) {
        if (!this.headFlag && !this.isVerbatimFlag()) {
            MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BR_ATTRIBUTES);
            this.writeSimpleTag(HtmlMarkup.WBR, atts);
        }
    }

    @Override
    public void pageBreak() {
        this.comment(" PB ");
    }

    @Override
    public void nonBreakingSpace() {
        if (this.headFlag) {
            this.getTextBuffer().append(' ');
        } else {
            this.write("&#160;");
        }
    }

    @Override
    public void text(String text) {
        if (this.headFlag) {
            this.getTextBuffer().append(text);
        } else if (this.verbatimFlag) {
            this.verbatimContent(text);
        } else {
            this.content(text);
        }
    }

    @Override
    public void text(String text, SinkEventAttributes attributes) {
        this.text(text);
    }

    @Override
    public void rawText(String text) {
        if (this.headFlag) {
            this.getTextBuffer().append(text);
        } else {
            this.write(text);
        }
    }

    @Override
    public void comment(String comment) {
        if (comment != null) {
            String originalComment = comment;
            while (comment.contains("--")) {
                comment = comment.replace("--", "- -");
            }
            if (comment.endsWith("-")) {
                comment = comment + " ";
            }
            if (!originalComment.equals(comment)) {
                LOGGER.warn("Modified invalid comment '{}' to '{}'", (Object)originalComment, (Object)comment);
            }
            StringBuilder buffer = new StringBuilder(comment.length() + 7);
            buffer.append('<').append('!').append('-').append('-');
            buffer.append(comment);
            buffer.append('-').append('-').append('>');
            this.write(buffer.toString());
        }
    }

    @Override
    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
        if (requiredParams == null || !(requiredParams[0] instanceof Integer)) {
            LOGGER.warn("No type information for unknown event '{}', ignoring!", (Object)name);
            return;
        }
        int tagType = (Integer)requiredParams[0];
        if (tagType == 4) {
            this.rawText(name);
            return;
        }
        if (tagType == 5) {
            this.rawText(EOL + "//<![CDATA[" + requiredParams[1] + "]]>" + EOL);
            return;
        }
        HTML.Tag tag = HtmlTools.getHtmlTag(name);
        if (tag == null) {
            LOGGER.warn("No HTML tag found for unknown event '{}', ignoring!", (Object)name);
        } else if (tagType == 1) {
            this.writeSimpleTag(tag, (MutableAttributeSet)this.escapeAttributeValues(attributes));
        } else if (tagType == 2) {
            this.writeStartTag(tag, (MutableAttributeSet)this.escapeAttributeValues(attributes));
        } else if (tagType == 3) {
            this.writeEndTag(tag);
        } else {
            LOGGER.warn("No type information for unknown event '{}', ignoring!", (Object)name);
        }
    }

    private SinkEventAttributes escapeAttributeValues(SinkEventAttributes attributes) {
        SinkEventAttributeSet set = new SinkEventAttributeSet(attributes.getAttributeCount());
        Enumeration names = attributes.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            set.addAttribute(name, Xhtml5BaseSink.escapeHTML(attributes.getAttribute(name).toString()));
        }
        return set;
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public void close() {
        this.writer.close();
        this.init();
    }

    protected void content(String text) {
        String txt = Xhtml5BaseSink.escapeHTML(text);
        txt = StringUtils.replace((String)txt, (String)"&amp;#", (String)"&#");
        this.write(txt);
    }

    protected void verbatimContent(String text) {
        this.write(Xhtml5BaseSink.escapeHTML(text));
    }

    protected static String escapeHTML(String text) {
        return HtmlTools.escapeHTML(text, false);
    }

    protected static String encodeURL(String text) {
        return HtmlTools.encodeURL(text);
    }

    @Override
    protected void write(String text) {
        if (!this.tableCaptionXMLWriterStack.isEmpty() && this.tableCaptionXMLWriterStack.getLast() != null) {
            this.tableCaptionXMLWriterStack.getLast().writeMarkup(Xhtml5BaseSink.unifyEOLs(text));
        } else if (!this.tableContentWriterStack.isEmpty() && this.tableContentWriterStack.getLast() != null) {
            this.tableContentWriterStack.getLast().write(Xhtml5BaseSink.unifyEOLs(text));
        } else {
            this.writer.write(Xhtml5BaseSink.unifyEOLs(text));
        }
    }

    @Override
    protected void writeStartTag(HTML.Tag t, MutableAttributeSet att, boolean isSimpleTag) {
        if (this.tableCaptionXMLWriterStack.isEmpty()) {
            super.writeStartTag(t, att, isSimpleTag);
        } else {
            String tag = (this.getNameSpace() != null ? this.getNameSpace() + ":" : "") + t.toString();
            this.tableCaptionXMLWriterStack.getLast().startElement(tag);
            if (att != null) {
                Enumeration<?> names = att.getAttributeNames();
                while (names.hasMoreElements()) {
                    Object key = names.nextElement();
                    Object value = att.getAttribute(key);
                    this.tableCaptionXMLWriterStack.getLast().addAttribute(key.toString(), value.toString());
                }
            }
            if (isSimpleTag) {
                this.tableCaptionXMLWriterStack.getLast().endElement();
            }
        }
    }

    @Override
    protected void writeEndTag(HTML.Tag t) {
        if (this.tableCaptionXMLWriterStack.isEmpty()) {
            super.writeEndTag(t);
        } else {
            this.tableCaptionXMLWriterStack.getLast().endElement();
        }
    }
}

