/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.doxia.markup.XmlMarkup;
import org.apache.maven.doxia.parser.AbstractXmlParser;
import org.apache.maven.doxia.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlValidator.class);
    private static final Pattern PATTERN_DOCTYPE = Pattern.compile(".*<!DOCTYPE([^>]*)>.*");
    private static final Pattern PATTERN_TAG = Pattern.compile(".*<([A-Za-z][A-Za-z0-9:_.-]*)([^>]*)>.*");
    private XMLReader xmlReader;

    public void validate(String content) throws ParseException {
        try {
            String value;
            boolean hasDoctype = false;
            Matcher matcher = PATTERN_DOCTYPE.matcher(content);
            if (matcher.find()) {
                hasDoctype = true;
            }
            boolean hasXsd = false;
            matcher = PATTERN_TAG.matcher(content);
            if (matcher.find() && (value = matcher.group(2)).contains("http://www.w3.org/2001/XMLSchema-instance")) {
                hasXsd = true;
            }
            this.getXmlReader(hasXsd && hasDoctype).parse(new InputSource(new StringReader(content)));
        }
        catch (IOException | SAXException e) {
            throw new ParseException("Error validating the model", e);
        }
    }

    private XMLReader getXmlReader(boolean hasDtdAndXsd) throws SAXException {
        if (this.xmlReader == null) {
            MessagesErrorHandler errorHandler = new MessagesErrorHandler();
            this.xmlReader = XMLReaderFactory.createXMLReader();
            this.xmlReader.setFeature("http://xml.org/sax/features/validation", true);
            this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.xmlReader.setErrorHandler(errorHandler);
            this.xmlReader.setEntityResolver(new AbstractXmlParser.CachedFileEntityResolver());
        }
        ((MessagesErrorHandler)this.xmlReader.getErrorHandler()).setHasDtdAndXsd(hasDtdAndXsd);
        return this.xmlReader;
    }

    private static class MessagesErrorHandler
    extends DefaultHandler {
        private static final int TYPE_UNKNOWN = 0;
        private static final int TYPE_WARNING = 1;
        private static final int TYPE_ERROR = 2;
        private static final int TYPE_FATAL = 3;
        private static final String EOL = XmlMarkup.EOL;
        private static final Pattern ELEMENT_TYPE_PATTERN = Pattern.compile("Element type \".*\" must be declared.", 32);
        private boolean hasDtdAndXsd;

        private MessagesErrorHandler() {
        }

        protected void setHasDtdAndXsd(boolean hasDtdAndXsd) {
            this.hasDtdAndXsd = hasDtdAndXsd;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            this.processException(1, e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            if (!this.hasDtdAndXsd) {
                this.processException(2, e);
                return;
            }
            Matcher m = ELEMENT_TYPE_PATTERN.matcher(e.getMessage());
            if (!m.find()) {
                this.processException(2, e);
            }
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.processException(3, e);
        }

        private void processException(int type, SAXParseException e) throws SAXException {
            StringBuilder message = new StringBuilder();
            switch (type) {
                case 1: {
                    message.append("Warning:");
                    break;
                }
                case 2: {
                    message.append("Error:");
                    break;
                }
                case 3: {
                    message.append("Fatal error:");
                    break;
                }
                default: {
                    message.append("Unknown:");
                }
            }
            message.append(EOL);
            message.append("  Public ID: ").append(e.getPublicId()).append(EOL);
            message.append("  System ID: ").append(e.getSystemId()).append(EOL);
            message.append("  Line number: ").append(e.getLineNumber()).append(EOL);
            message.append("  Column number: ").append(e.getColumnNumber()).append(EOL);
            message.append("  Message: ").append(e.getMessage()).append(EOL);
            String logMessage = message.toString();
            switch (type) {
                case 1: {
                    LOGGER.warn(logMessage);
                    break;
                }
                default: {
                    throw new SAXException(logMessage);
                }
            }
        }
    }
}

