/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IndexEntry {
    private final IndexEntry parent;
    private String id;
    private String title;
    private List<IndexEntry> childEntries = new ArrayList<IndexEntry>();
    private static final String EOL = System.getProperty("line.separator");

    public IndexEntry(String newId) {
        this(null, newId);
    }

    public IndexEntry(IndexEntry newParent, String newId) {
        this.parent = newParent;
        this.id = newId;
        if (this.parent != null) {
            this.parent.childEntries.add(this);
        }
    }

    public IndexEntry getParent() {
        return this.parent;
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
    }

    public List<IndexEntry> getChildEntries() {
        return Collections.unmodifiableList(this.childEntries);
    }

    public void setChildEntries(List<IndexEntry> entries) {
        if (entries == null) {
            this.childEntries = new ArrayList<IndexEntry>();
        }
        this.childEntries = entries;
    }

    public IndexEntry getNextEntry() {
        if (this.parent == null) {
            return null;
        }
        List<IndexEntry> entries = this.parent.getChildEntries();
        int index = entries.indexOf(this);
        if (index + 1 >= entries.size()) {
            return null;
        }
        return entries.get(index + 1);
    }

    public IndexEntry getPrevEntry() {
        if (this.parent == null) {
            return null;
        }
        List<IndexEntry> entries = this.parent.getChildEntries();
        int index = entries.indexOf(this);
        if (index == 0) {
            return null;
        }
        return entries.get(index - 1);
    }

    public IndexEntry getFirstEntry() {
        List<IndexEntry> entries = this.getChildEntries();
        if (entries.size() == 0) {
            return null;
        }
        return entries.get(0);
    }

    public IndexEntry getLastEntry() {
        List<IndexEntry> entries = this.getChildEntries();
        if (entries.size() == 0) {
            return null;
        }
        return entries.get(entries.size() - 1);
    }

    public IndexEntry getRootEntry() {
        List<IndexEntry> entries = this.getChildEntries();
        if (entries.size() == 0) {
            return null;
        }
        if (entries.size() > 1) {
            throw new IllegalStateException("This index has more than one root entry");
        }
        return entries.get(0);
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int depth) {
        StringBuilder message = new StringBuilder();
        message.append("Id: ").append(this.id);
        if (this.title != null && !this.title.isEmpty()) {
            message.append(", title: ").append(this.title);
        }
        message.append(EOL);
        StringBuilder indent = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            indent.append(" ");
        }
        for (IndexEntry entry : this.getChildEntries()) {
            message.append((CharSequence)indent).append(entry.toString(depth + 1));
        }
        return message.toString();
    }
}

