/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.site.decoration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.doxia.site.decoration.LinkItem;

public class MenuItem
extends LinkItem
implements Serializable {
    private String description;
    private boolean collapse = false;
    private String ref;
    private List items;
    private String modelEncoding = "UTF-8";

    public void addItem(MenuItem menuItem) {
        this.getItems().add(menuItem);
        menuItem.createMenuItemAssociation(this);
    }

    public void breakMenuItemAssociation(MenuItem menuItem) {
        if (!this.getItems().contains(menuItem)) {
            throw new IllegalStateException("menuItem isn't associated.");
        }
        this.getItems().remove(menuItem);
    }

    public void createMenuItemAssociation(MenuItem menuItem) {
        List items = this.getItems();
        if (this.getItems().contains(menuItem)) {
            throw new IllegalStateException("menuItem is already assigned.");
        }
        items.add(menuItem);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MenuItem)) {
            return false;
        }
        MenuItem that = (MenuItem)other;
        boolean result = true;
        result = result && (this.getDescription() == null ? that.getDescription() == null : this.getDescription().equals(that.getDescription()));
        boolean bl = result = result && this.collapse == that.collapse;
        boolean bl2 = result && (this.getRef() == null ? that.getRef() == null : this.getRef().equals(that.getRef())) ? true : (result = false);
        result = result && (this.getItems() == null ? that.getItems() == null : ((Object)this.getItems()).equals(that.getItems()));
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    public List getItems() {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        return this.items;
    }

    public String getRef() {
        return this.ref;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 37 * result + (this.collapse ? 0 : 1);
        result = 37 * result + (this.ref != null ? this.ref.hashCode() : 0);
        result = 37 * result + (this.items != null ? ((Object)this.items).hashCode() : 0);
        return result;
    }

    public boolean isCollapse() {
        return this.collapse;
    }

    public void removeItem(MenuItem menuItem) {
        menuItem.breakMenuItemAssociation(this);
        this.getItems().remove(menuItem);
    }

    public void setCollapse(boolean collapse) {
        this.collapse = collapse;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setItems(List items) {
        this.items = items;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("description = '");
        buf.append(this.getDescription() + "'");
        buf.append("\n");
        buf.append("collapse = '");
        buf.append(this.isCollapse() + "'");
        buf.append("\n");
        buf.append("ref = '");
        buf.append(this.getRef() + "'");
        buf.append("\n");
        buf.append("items = '");
        buf.append(this.getItems() + "'");
        return buf.toString();
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }
}

