/*
 * $Id$
 */

package org.apache.maven.doxia.site.decoration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         A link in the navigation.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class LinkItem
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The name to display for the link.
     *           
     */
    private String name;

    /**
     * 
     *             The href to use for the link.
     *           
     */
    private String href;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof LinkItem ) )
        {
            return false;
        }

        LinkItem that = (LinkItem) other;
        boolean result = true;

        result = result && ( getName() == null ? that.getName() == null : getName().equals( that.getName() ) );
        result = result && ( getHref() == null ? that.getHref() == null : getHref().equals( that.getHref() ) );

        return result;
    } //-- boolean equals( Object )

    /**
     * Get 
     *             The href to use for the link.
     *           
     * 
     * @return String
     */
    public String getHref()
    {
        return this.href;
    } //-- String getHref()

    /**
     * Get 
     *             The name to display for the link.
     *           
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( name != null ? name.hashCode() : 0 );
        result = 37 * result + ( href != null ? href.hashCode() : 0 );

        return result;
    } //-- int hashCode()

    /**
     * Set 
     *             The href to use for the link.
     *           
     * 
     * @param href
     */
    public void setHref( String href )
    {
        this.href = href;
    } //-- void setHref( String )

    /**
     * Set 
     *             The name to display for the link.
     *           
     * 
     * @param name
     */
    public void setName( String name )
    {
        this.name = name;
    } //-- void setName( String )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();

        buf.append( "name = '" );
        buf.append( getName() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "href = '" );
        buf.append( getHref() );
        buf.append( "'" );

        return buf.toString();
    } //-- java.lang.String toString()


}
