/*
 * $Id$
 */

package org.apache.maven.doxia.site.decoration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         Power by logo on the navigation.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Logo
    extends LinkItem
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The href of a link to be used for the power by
     * image.
     *           
     */
    private String img;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof Logo ) )
        {
            return false;
        }

        Logo that = (Logo) other;
        boolean result = true;

        result = result && ( getImg() == null ? that.getImg() == null : getImg().equals( that.getImg() ) );
        result = result && ( super.equals( other ) );

        return result;
    } //-- boolean equals( Object )

    /**
     * Get 
     *             The href of a link to be used for the power by
     * image.
     *           
     * 
     * @return String
     */
    public String getImg()
    {
        return this.img;
    } //-- String getImg()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( img != null ? img.hashCode() : 0 );
        result = 37 * result + super.hashCode();

        return result;
    } //-- int hashCode()

    /**
     * Set 
     *             The href of a link to be used for the power by
     * image.
     *           
     * 
     * @param img
     */
    public void setImg( String img )
    {
        this.img = img;
    } //-- void setImg( String )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();

        buf.append( "img = '" );
        buf.append( getImg() );
        buf.append( "'" );
        buf.append( "\n" );
        buf.append( super.toString() );

        return buf.toString();
    } //-- java.lang.String toString()


}
