/*
 * $Id$
 */

package org.apache.maven.doxia.site.decoration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         A menu in the navigation.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Menu
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The name to display for the menu.
     *           
     */
    private String name;

    /**
     * 
     *             The way in which the menu is inherited. Can be
     * one of : <code>top</code>, <code>bottom</code>.
     *           
     */
    private String inherit;

    /**
     * 
     *             If this is a reference, setting
     * <inheritAsRef>true</inheritAsRef> means that it will be
     * populated
     *             in the project, whereas if it is false, it is
     * populated in the parent and then inherited.
     *           
     */
    private boolean inheritAsRef = false;

    /**
     * 
     *             A reference to a pre-defined menu, such as a
     * <code>reports</code>, <code>modules</code>
     *             or <code>parentProject</code>.
     *           
     */
    private String ref;

    /**
     * 
     *             The location of an image.
     *           
     */
    private String img;

    /**
     * Field items.
     */
    private java.util.List/*<MenuItem>*/ items;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addItem.
     * 
     * @param menuItem
     */
    public void addItem( MenuItem menuItem )
    {
        if ( !(menuItem instanceof MenuItem) )
        {
            throw new ClassCastException( "Menu.addItems(menuItem) parameter must be instanceof " + MenuItem.class.getName() );
        }
        getItems().add( menuItem );
    } //-- void addItem( MenuItem )

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof Menu ) )
        {
            return false;
        }

        Menu that = (Menu) other;
        boolean result = true;

        result = result && ( getName() == null ? that.getName() == null : getName().equals( that.getName() ) );
        result = result && ( getInherit() == null ? that.getInherit() == null : getInherit().equals( that.getInherit() ) );
        result = result && ( getRef() == null ? that.getRef() == null : getRef().equals( that.getRef() ) );
        result = result && ( getImg() == null ? that.getImg() == null : getImg().equals( that.getImg() ) );
        result = result && ( getItems() == null ? that.getItems() == null : getItems().equals( that.getItems() ) );

        return result;
    } //-- boolean equals( Object )

    /**
     * Get 
     *             The location of an image.
     *           
     * 
     * @return String
     */
    public String getImg()
    {
        return this.img;
    } //-- String getImg()

    /**
     * Get 
     *             The way in which the menu is inherited. Can be
     * one of : <code>top</code>, <code>bottom</code>.
     *           
     * 
     * @return String
     */
    public String getInherit()
    {
        return this.inherit;
    } //-- String getInherit()

    /**
     * Method getItems.
     * 
     * @return List
     */
    public java.util.List/*<MenuItem>*/ getItems()
    {
        if ( this.items == null )
        {
            this.items = new java.util.ArrayList/*<MenuItem>*/();
        }

        return this.items;
    } //-- java.util.List/*<MenuItem>*/ getItems()

    /**
     * Get 
     *             The name to display for the menu.
     *           
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName()

    /**
     * Get 
     *             A reference to a pre-defined menu, such as a
     * <code>reports</code>, <code>modules</code>
     *             or <code>parentProject</code>.
     *           
     * 
     * @return String
     */
    public String getRef()
    {
        return this.ref;
    } //-- String getRef()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( name != null ? name.hashCode() : 0 );
        result = 37 * result + ( inherit != null ? inherit.hashCode() : 0 );
        result = 37 * result + ( ref != null ? ref.hashCode() : 0 );
        result = 37 * result + ( img != null ? img.hashCode() : 0 );
        result = 37 * result + ( items != null ? items.hashCode() : 0 );

        return result;
    } //-- int hashCode()

    /**
     * Get 
     *             If this is a reference, setting
     * <inheritAsRef>true</inheritAsRef> means that it will be
     * populated
     *             in the project, whereas if it is false, it is
     * populated in the parent and then inherited.
     *           
     * 
     * @return boolean
     */
    public boolean isInheritAsRef()
    {
        return this.inheritAsRef;
    } //-- boolean isInheritAsRef()

    /**
     * Method removeItem.
     * 
     * @param menuItem
     */
    public void removeItem( MenuItem menuItem )
    {
        if ( !(menuItem instanceof MenuItem) )
        {
            throw new ClassCastException( "Menu.removeItems(menuItem) parameter must be instanceof " + MenuItem.class.getName() );
        }
        getItems().remove( menuItem );
    } //-- void removeItem( MenuItem )

    /**
     * Set 
     *             The location of an image.
     *           
     * 
     * @param img
     */
    public void setImg( String img )
    {
        this.img = img;
    } //-- void setImg( String )

    /**
     * Set 
     *             The way in which the menu is inherited. Can be
     * one of : <code>top</code>, <code>bottom</code>.
     *           
     * 
     * @param inherit
     */
    public void setInherit( String inherit )
    {
        this.inherit = inherit;
    } //-- void setInherit( String )

    /**
     * Set 
     *             If this is a reference, setting
     * <inheritAsRef>true</inheritAsRef> means that it will be
     * populated
     *             in the project, whereas if it is false, it is
     * populated in the parent and then inherited.
     *           
     * 
     * @param inheritAsRef
     */
    public void setInheritAsRef( boolean inheritAsRef )
    {
        this.inheritAsRef = inheritAsRef;
    } //-- void setInheritAsRef( boolean )

    /**
     * Set 
     *             A list of menu item.
     *           
     * 
     * @param items
     */
    public void setItems( java.util.List/*<MenuItem>*/ items )
    {
        this.items = items;
    } //-- void setItems( java.util.List )

    /**
     * Set 
     *             The name to display for the menu.
     *           
     * 
     * @param name
     */
    public void setName( String name )
    {
        this.name = name;
    } //-- void setName( String )

    /**
     * Set 
     *             A reference to a pre-defined menu, such as a
     * <code>reports</code>, <code>modules</code>
     *             or <code>parentProject</code>.
     *           
     * 
     * @param ref
     */
    public void setRef( String ref )
    {
        this.ref = ref;
    } //-- void setRef( String )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();

        buf.append( "name = '" );
        buf.append( getName() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "inherit = '" );
        buf.append( getInherit() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "ref = '" );
        buf.append( getRef() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "img = '" );
        buf.append( getImg() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "items = '" );
        buf.append( getItems() );
        buf.append( "'" );

        return buf.toString();
    } //-- java.lang.String toString()


}
