// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 1.9.1,
// any modifications will be overwritten.
// ==============================================================

package org.apache.maven.doxia.site.decoration;

/**
 * 
 *          The <code>&lt;project&gt;</code> element is the root of
 * the site decoration descriptor.
 *       
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class DecorationModel
    implements java.io.Serializable, java.lang.Cloneable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The full name of the project.
     */
    private String name;

    /**
     * 
     *              Whether to inherit configuration from a parent
     * project site descriptor (<code>merge</code>)
     *            or not (<code>override</code>).
     *            
     */
    private String combineSelf = "merge";

    /**
     * Banner logo on the masthead of the site to the left.
     */
    private Banner bannerLeft;

    /**
     * Banner logo on the masthead of the site to the right.
     */
    private Banner bannerRight;

    /**
     * Your Google AdSense client id.
     */
    private String googleAdSenseClient;

    /**
     * Your Google AdSense slot id.
     */
    private String googleAdSenseSlot;

    /**
     * The id for your Google Analytics account.
     */
    private String googleAnalyticsAccountId;

    /**
     * Modify the date published display properties.
     */
    private PublishDate publishDate;

    /**
     * Modify the version published display properties.
     */
    private Version version;

    /**
     * 
     *             The base url to edit Doxia document sources.
     *             In general, <code>${project.scm.url}</code>
     * value should do the job. 
     *           
     */
    private String edit;

    /**
     * Field poweredBy.
     */
    private java.util.List<Logo> poweredBy;

    /**
     * The artifact containing the skin for the site.
     */
    private Skin skin;

    /**
     * The main site content decoration.
     */
    private Body body;

    /**
     * 
     *             Custom configuration for use with customized
     * Velocity templates. Data from this field are
     *             accessible in Velocity template from
     * <code>$decoration.custom</code> variable as DOM content.
     *             Example: <code>$decoration.custom.getChild(
     * 'customElement' ).getValue()</code>
     *           
     */
    private Object custom;

    /**
     * Timestamp of the last modification of this decoration model.
     */
    private long lastModified = 0L;

    /**
     * Field modelEncoding.
     */
    private String modelEncoding = "UTF-8";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addPoweredBy.
     * 
     * @param logo
     */
    public void addPoweredBy( Logo logo )
    {
        getPoweredBy().add( logo );
    } //-- void addPoweredBy( Logo )

    /**
     * Method clone.
     * 
     * @return DecorationModel
     */
    public DecorationModel clone()
    {
        try
        {
            DecorationModel copy = (DecorationModel) super.clone();

            if ( this.bannerLeft != null )
            {
                copy.bannerLeft = (Banner) this.bannerLeft.clone();
            }

            if ( this.bannerRight != null )
            {
                copy.bannerRight = (Banner) this.bannerRight.clone();
            }

            if ( this.publishDate != null )
            {
                copy.publishDate = (PublishDate) this.publishDate.clone();
            }

            if ( this.version != null )
            {
                copy.version = (Version) this.version.clone();
            }

            if ( this.poweredBy != null )
            {
                copy.poweredBy = new java.util.ArrayList<Logo>();
                for ( Logo item : this.poweredBy )
                {
                    copy.poweredBy.add( ( (Logo) item).clone() );
                }
            }

            if ( this.skin != null )
            {
                copy.skin = (Skin) this.skin.clone();
            }

            if ( this.body != null )
            {
                copy.body = (Body) this.body.clone();
            }

            if ( this.custom != null )
            {
                copy.custom = new org.codehaus.plexus.util.xml.Xpp3Dom( (org.codehaus.plexus.util.xml.Xpp3Dom) this.custom );
            }

            return copy;
        }
        catch ( java.lang.Exception ex )
        {
            throw (java.lang.RuntimeException) new java.lang.UnsupportedOperationException( getClass().getName()
                + " does not support clone()" ).initCause( ex );
        }
    } //-- DecorationModel clone()

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof DecorationModel ) )
        {
            return false;
        }

        DecorationModel that = (DecorationModel) other;
        boolean result = true;

        result = result && ( getName() == null ? that.getName() == null : getName().equals( that.getName() ) );
        result = result && ( getBannerLeft() == null ? that.getBannerLeft() == null : getBannerLeft().equals( that.getBannerLeft() ) );
        result = result && ( getBannerRight() == null ? that.getBannerRight() == null : getBannerRight().equals( that.getBannerRight() ) );
        result = result && ( getGoogleAdSenseClient() == null ? that.getGoogleAdSenseClient() == null : getGoogleAdSenseClient().equals( that.getGoogleAdSenseClient() ) );
        result = result && ( getGoogleAdSenseSlot() == null ? that.getGoogleAdSenseSlot() == null : getGoogleAdSenseSlot().equals( that.getGoogleAdSenseSlot() ) );
        result = result && ( getGoogleAnalyticsAccountId() == null ? that.getGoogleAnalyticsAccountId() == null : getGoogleAnalyticsAccountId().equals( that.getGoogleAnalyticsAccountId() ) );
        result = result && ( getPublishDate() == null ? that.getPublishDate() == null : getPublishDate().equals( that.getPublishDate() ) );
        result = result && ( getVersion() == null ? that.getVersion() == null : getVersion().equals( that.getVersion() ) );
        result = result && ( getEdit() == null ? that.getEdit() == null : getEdit().equals( that.getEdit() ) );
        result = result && ( getPoweredBy() == null ? that.getPoweredBy() == null : getPoweredBy().equals( that.getPoweredBy() ) );
        result = result && ( getSkin() == null ? that.getSkin() == null : getSkin().equals( that.getSkin() ) );
        result = result && ( getBody() == null ? that.getBody() == null : getBody().equals( that.getBody() ) );
        result = result && ( getCustom() == null ? that.getCustom() == null : getCustom().equals( that.getCustom() ) );

        return result;
    } //-- boolean equals( Object )

    /**
     * Get banner logo on the masthead of the site to the left.
     * 
     * @return Banner
     */
    public Banner getBannerLeft()
    {
        return this.bannerLeft;
    } //-- Banner getBannerLeft()

    /**
     * Get banner logo on the masthead of the site to the right.
     * 
     * @return Banner
     */
    public Banner getBannerRight()
    {
        return this.bannerRight;
    } //-- Banner getBannerRight()

    /**
     * Get the main site content decoration.
     * 
     * @return Body
     */
    public Body getBody()
    {
        return this.body;
    } //-- Body getBody()

    /**
     * Get whether to inherit configuration from a parent project
     * site descriptor (<code>merge</code>)
     *            or not (<code>override</code>).
     * 
     * @return String
     */
    public String getCombineSelf()
    {
        return this.combineSelf;
    } //-- String getCombineSelf()

    /**
     * Get custom configuration for use with customized Velocity
     * templates. Data from this field are
     *             accessible in Velocity template from
     * <code>$decoration.custom</code> variable as DOM content.
     *             Example: <code>$decoration.custom.getChild(
     * 'customElement' ).getValue()</code>
     * 
     * @return Object
     */
    public Object getCustom()
    {
        return this.custom;
    } //-- Object getCustom()

    /**
     * Get the base url to edit Doxia document sources.
     *             In general, <code>${project.scm.url}</code>
     * value should do the job.
     * 
     * @return String
     */
    public String getEdit()
    {
        return this.edit;
    } //-- String getEdit()

    /**
     * Get your Google AdSense client id.
     * 
     * @return String
     */
    public String getGoogleAdSenseClient()
    {
        return this.googleAdSenseClient;
    } //-- String getGoogleAdSenseClient()

    /**
     * Get your Google AdSense slot id.
     * 
     * @return String
     */
    public String getGoogleAdSenseSlot()
    {
        return this.googleAdSenseSlot;
    } //-- String getGoogleAdSenseSlot()

    /**
     * Get the id for your Google Analytics account.
     * 
     * @return String
     */
    public String getGoogleAnalyticsAccountId()
    {
        return this.googleAnalyticsAccountId;
    } //-- String getGoogleAnalyticsAccountId()

    /**
     * Get timestamp of the last modification of this decoration
     * model.
     * 
     * @return long
     */
    public long getLastModified()
    {
        return this.lastModified;
    } //-- long getLastModified()

    /**
     * Get the modelEncoding field.
     * 
     * @return String
     */
    public String getModelEncoding()
    {
        return this.modelEncoding;
    } //-- String getModelEncoding()

    /**
     * Get the full name of the project.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName()

    /**
     * Method getPoweredBy.
     * 
     * @return List
     */
    public java.util.List<Logo> getPoweredBy()
    {
        if ( this.poweredBy == null )
        {
            this.poweredBy = new java.util.ArrayList<Logo>();
        }

        return this.poweredBy;
    } //-- java.util.List<Logo> getPoweredBy()

    /**
     * Get the artifact containing the skin for the site.
     * 
     * @return Skin
     */
    public Skin getSkin()
    {
        return this.skin;
    } //-- Skin getSkin()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( name != null ? name.hashCode() : 0 );
        result = 37 * result + ( bannerLeft != null ? bannerLeft.hashCode() : 0 );
        result = 37 * result + ( bannerRight != null ? bannerRight.hashCode() : 0 );
        result = 37 * result + ( googleAdSenseClient != null ? googleAdSenseClient.hashCode() : 0 );
        result = 37 * result + ( googleAdSenseSlot != null ? googleAdSenseSlot.hashCode() : 0 );
        result = 37 * result + ( googleAnalyticsAccountId != null ? googleAnalyticsAccountId.hashCode() : 0 );
        result = 37 * result + ( publishDate != null ? publishDate.hashCode() : 0 );
        result = 37 * result + ( version != null ? version.hashCode() : 0 );
        result = 37 * result + ( edit != null ? edit.hashCode() : 0 );
        result = 37 * result + ( poweredBy != null ? poweredBy.hashCode() : 0 );
        result = 37 * result + ( skin != null ? skin.hashCode() : 0 );
        result = 37 * result + ( body != null ? body.hashCode() : 0 );
        result = 37 * result + ( custom != null ? custom.hashCode() : 0 );

        return result;
    } //-- int hashCode()

    /**
     * Method removePoweredBy.
     * 
     * @param logo
     */
    public void removePoweredBy( Logo logo )
    {
        getPoweredBy().remove( logo );
    } //-- void removePoweredBy( Logo )

    /**
     * Set banner logo on the masthead of the site to the left.
     * 
     * @param bannerLeft
     */
    public void setBannerLeft( Banner bannerLeft )
    {
        this.bannerLeft = bannerLeft;
    } //-- void setBannerLeft( Banner )

    /**
     * Set banner logo on the masthead of the site to the right.
     * 
     * @param bannerRight
     */
    public void setBannerRight( Banner bannerRight )
    {
        this.bannerRight = bannerRight;
    } //-- void setBannerRight( Banner )

    /**
     * Set the main site content decoration.
     * 
     * @param body
     */
    public void setBody( Body body )
    {
        this.body = body;
    } //-- void setBody( Body )

    /**
     * Set whether to inherit configuration from a parent project
     * site descriptor (<code>merge</code>)
     *            or not (<code>override</code>).
     * 
     * @param combineSelf
     */
    public void setCombineSelf( String combineSelf )
    {
        this.combineSelf = combineSelf;
    } //-- void setCombineSelf( String )

    /**
     * Set custom configuration for use with customized Velocity
     * templates. Data from this field are
     *             accessible in Velocity template from
     * <code>$decoration.custom</code> variable as DOM content.
     *             Example: <code>$decoration.custom.getChild(
     * 'customElement' ).getValue()</code>
     * 
     * @param custom
     */
    public void setCustom( Object custom )
    {
        this.custom = custom;
    } //-- void setCustom( Object )

    /**
     * Set the base url to edit Doxia document sources.
     *             In general, <code>${project.scm.url}</code>
     * value should do the job.
     * 
     * @param edit
     */
    public void setEdit( String edit )
    {
        this.edit = edit;
    } //-- void setEdit( String )

    /**
     * Set your Google AdSense client id.
     * 
     * @param googleAdSenseClient
     */
    public void setGoogleAdSenseClient( String googleAdSenseClient )
    {
        this.googleAdSenseClient = googleAdSenseClient;
    } //-- void setGoogleAdSenseClient( String )

    /**
     * Set your Google AdSense slot id.
     * 
     * @param googleAdSenseSlot
     */
    public void setGoogleAdSenseSlot( String googleAdSenseSlot )
    {
        this.googleAdSenseSlot = googleAdSenseSlot;
    } //-- void setGoogleAdSenseSlot( String )

    /**
     * Set the id for your Google Analytics account.
     * 
     * @param googleAnalyticsAccountId
     */
    public void setGoogleAnalyticsAccountId( String googleAnalyticsAccountId )
    {
        this.googleAnalyticsAccountId = googleAnalyticsAccountId;
    } //-- void setGoogleAnalyticsAccountId( String )

    /**
     * Set timestamp of the last modification of this decoration
     * model.
     * 
     * @param lastModified
     */
    public void setLastModified( long lastModified )
    {
        this.lastModified = lastModified;
    } //-- void setLastModified( long )

    /**
     * Set the modelEncoding field.
     * 
     * @param modelEncoding
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    } //-- void setModelEncoding( String )

    /**
     * Set the full name of the project.
     * 
     * @param name
     */
    public void setName( String name )
    {
        this.name = name;
    } //-- void setName( String )

    /**
     * Set powered by logos list.
     * 
     * @param poweredBy
     */
    public void setPoweredBy( java.util.List<Logo> poweredBy )
    {
        this.poweredBy = poweredBy;
    } //-- void setPoweredBy( java.util.List )

    /**
     * Set modify the date published display properties.
     * 
     * @param publishDate
     */
    public void setPublishDate( PublishDate publishDate )
    {
        this.publishDate = publishDate;
    } //-- void setPublishDate( PublishDate )

    /**
     * Set the artifact containing the skin for the site.
     * 
     * @param skin
     */
    public void setSkin( Skin skin )
    {
        this.skin = skin;
    } //-- void setSkin( Skin )

    /**
     * Set modify the version published display properties.
     * 
     * @param version
     */
    public void setVersion( Version version )
    {
        this.version = version;
    } //-- void setVersion( Version )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuilder buf = new StringBuilder( 128 );

        buf.append( "name = '" );
        buf.append( getName() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "bannerLeft = '" );
        buf.append( getBannerLeft() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "bannerRight = '" );
        buf.append( getBannerRight() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "googleAdSenseClient = '" );
        buf.append( getGoogleAdSenseClient() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "googleAdSenseSlot = '" );
        buf.append( getGoogleAdSenseSlot() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "googleAnalyticsAccountId = '" );
        buf.append( getGoogleAnalyticsAccountId() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "publishDate = '" );
        buf.append( getPublishDate() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "version = '" );
        buf.append( getVersion() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "edit = '" );
        buf.append( getEdit() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "poweredBy = '" );
        buf.append( getPoweredBy() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "skin = '" );
        buf.append( getSkin() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "body = '" );
        buf.append( getBody() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "custom = '" );
        buf.append( getCustom() );
        buf.append( "'" );

        return buf.toString();
    } //-- java.lang.String toString()

    
            
    public static final String MERGE = "merge";

    public static final String OVERRIDE = "override";

    public boolean isMergeParent()
    {
        return !OVERRIDE.equals( combineSelf );
    }

    public PublishDate getPublishDate()
    {
        if ( publishDate == null )
            return new PublishDate();
        else
            return publishDate;
    }

    public boolean isDefaultPublishDate()
    {
        return publishDate == null;
    }

    public Version getVersion()
    {
        if ( version == null )
            return new Version();
        else
            return version;
    }

    public boolean isDefaultVersion()
    {
        return version == null;
    }

    private java.util.Map<String, Menu> menusByRef;

    /**
     * @param key not null
     * @return the menu ref defined by the given key.
     */
    public Menu getMenuRef( String key )
    {
        if ( menusByRef == null )
        {
            menusByRef = new java.util.HashMap<String, Menu>();

            if ( body != null )
            {
                for ( Menu menu : body.getMenus() )
                {
                    if ( menu.getRef() != null )
                    {
                        menusByRef.put( menu.getRef(), menu );
                    }
                }
            }
        }
        return menusByRef.get( key );
    }

    /**
     * @param key not null
     */
    public void removeMenuRef( String key )
    {
        if ( body != null )
        {
            for ( java.util.Iterator<Menu> i = body.getMenus().iterator(); i.hasNext(); )
            {
                Menu menu = i.next();
                if ( key.equals( menu.getRef() ) )
                {
                    i.remove();
                }
            }
        }
    }

    /**
     * @return the menus list or EMPTY_LIST.
     */
    public java.util.List<Menu> getMenus()
    {
        java.util.List menus;
        if ( body != null && body.getMenus() != null )
        {
            menus = body.getMenus();
        }
        else
        {
            menus = java.util.Collections.emptyList();
        }
        return menus;
    }
            
          
    
    /**
     * @since 1.7
     * @see DecorationUtils#isLink
     */
    public boolean isLink( String href )
    {
        return DecorationUtils.isLink( href );
    }
          
    
    /**
     * @since 1.8
     * @see DecorationUtils#getCustomChild
     */
    public Object getCustomChild( String path )
    {
        return DecorationUtils.getCustomChild( (org.codehaus.plexus.util.xml.Xpp3Dom) custom, path );
    }

    /**
     * @since 1.8
     * @see DecorationUtils#getCustomValue
     */
    public String getCustomValue( String path )
    {
        return DecorationUtils.getCustomValue( (org.codehaus.plexus.util.xml.Xpp3Dom) custom, path );
    }

    /**
     * @since 1.8
     * @see DecorationUtils#getCustomValue
     */
    public String getCustomValue( String path, String defaultValue )
    {
        return DecorationUtils.getCustomValue( (org.codehaus.plexus.util.xml.Xpp3Dom) custom, path, defaultValue );
    }
          
}
