// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 1.8.1,
// any modifications will be overwritten.
// ==============================================================

package org.apache.maven.doxia.site.decoration;

/**
 * A menu in the navigation.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class Menu
    implements java.io.Serializable, java.lang.Cloneable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The name to display for the menu.
     */
    private String name;

    /**
     * 
     *             The way in which the menu is inherited. Can be
     * one of : <code>top</code>, <code>bottom</code>.
     *           
     */
    private String inherit;

    /**
     * 
     *             If this is a reference, setting
     * <inheritAsRef>true</inheritAsRef> means that it will be
     * populated
     *             in the project, whereas if it is false, it is
     * populated in the parent and then inherited.
     *           
     */
    private boolean inheritAsRef = false;

    /**
     * 
     *             Mark this menu as reference to a pre-defined
     * menu: <code>reports</code>, <code>modules</code>
     *             or <code>parent</code>. It will be populated at
     * runtime with corresponding pre-defined content.
     *           
     */
    private String ref;

    /**
     * The source location of an menu image.
     */
    private String img;

    /**
     * The alt description for the image.
     */
    private String alt;

    /**
     * Where to place the image regarding the displayed name (left
     * or right).
     */
    private String position = "left";

    /**
     * The border to use for the menu image.
     */
    private String border;

    /**
     * The width to use for the menu image.
     */
    private String width;

    /**
     * The height to use for the menu image.
     */
    private String height;

    /**
     * The title for the image.
     */
    private String title;

    /**
     * Field items.
     */
    private java.util.List<MenuItem> items;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addItem.
     * 
     * @param menuItem
     */
    public void addItem( MenuItem menuItem )
    {
        getItems().add( menuItem );
    } //-- void addItem( MenuItem )

    /**
     * Method clone.
     * 
     * @return Menu
     */
    public Menu clone()
    {
        try
        {
            Menu copy = (Menu) super.clone();

            if ( this.items != null )
            {
                copy.items = new java.util.ArrayList<MenuItem>();
                for ( MenuItem item : this.items )
                {
                    copy.items.add( ( (MenuItem) item).clone() );
                }
            }

            return copy;
        }
        catch ( java.lang.Exception ex )
        {
            throw (java.lang.RuntimeException) new java.lang.UnsupportedOperationException( getClass().getName()
                + " does not support clone()" ).initCause( ex );
        }
    } //-- Menu clone()

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof Menu ) )
        {
            return false;
        }

        Menu that = (Menu) other;
        boolean result = true;

        result = result && ( getName() == null ? that.getName() == null : getName().equals( that.getName() ) );
        result = result && ( getInherit() == null ? that.getInherit() == null : getInherit().equals( that.getInherit() ) );
        result = result && ( getRef() == null ? that.getRef() == null : getRef().equals( that.getRef() ) );
        result = result && ( getImg() == null ? that.getImg() == null : getImg().equals( that.getImg() ) );
        result = result && ( getAlt() == null ? that.getAlt() == null : getAlt().equals( that.getAlt() ) );
        result = result && ( getPosition() == null ? that.getPosition() == null : getPosition().equals( that.getPosition() ) );
        result = result && ( getBorder() == null ? that.getBorder() == null : getBorder().equals( that.getBorder() ) );
        result = result && ( getWidth() == null ? that.getWidth() == null : getWidth().equals( that.getWidth() ) );
        result = result && ( getHeight() == null ? that.getHeight() == null : getHeight().equals( that.getHeight() ) );
        result = result && ( getTitle() == null ? that.getTitle() == null : getTitle().equals( that.getTitle() ) );
        result = result && ( getItems() == null ? that.getItems() == null : getItems().equals( that.getItems() ) );

        return result;
    } //-- boolean equals( Object )

    /**
     * Get the alt description for the image.
     * 
     * @return String
     */
    public String getAlt()
    {
        return this.alt;
    } //-- String getAlt()

    /**
     * Get the border to use for the menu image.
     * 
     * @return String
     */
    public String getBorder()
    {
        return this.border;
    } //-- String getBorder()

    /**
     * Get the height to use for the menu image.
     * 
     * @return String
     */
    public String getHeight()
    {
        return this.height;
    } //-- String getHeight()

    /**
     * Get the source location of an menu image.
     * 
     * @return String
     */
    public String getImg()
    {
        return this.img;
    } //-- String getImg()

    /**
     * Get the way in which the menu is inherited. Can be one of :
     * <code>top</code>, <code>bottom</code>.
     * 
     * @return String
     */
    public String getInherit()
    {
        return this.inherit;
    } //-- String getInherit()

    /**
     * Method getItems.
     * 
     * @return List
     */
    public java.util.List<MenuItem> getItems()
    {
        if ( this.items == null )
        {
            this.items = new java.util.ArrayList<MenuItem>();
        }

        return this.items;
    } //-- java.util.List<MenuItem> getItems()

    /**
     * Get the name to display for the menu.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName()

    /**
     * Get where to place the image regarding the displayed name
     * (left or right).
     * 
     * @return String
     */
    public String getPosition()
    {
        return this.position;
    } //-- String getPosition()

    /**
     * Get mark this menu as reference to a pre-defined menu:
     * <code>reports</code>, <code>modules</code>
     *             or <code>parent</code>. It will be populated at
     * runtime with corresponding pre-defined content.
     * 
     * @return String
     */
    public String getRef()
    {
        return this.ref;
    } //-- String getRef()

    /**
     * Get the title for the image.
     * 
     * @return String
     */
    public String getTitle()
    {
        return this.title;
    } //-- String getTitle()

    /**
     * Get the width to use for the menu image.
     * 
     * @return String
     */
    public String getWidth()
    {
        return this.width;
    } //-- String getWidth()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( name != null ? name.hashCode() : 0 );
        result = 37 * result + ( inherit != null ? inherit.hashCode() : 0 );
        result = 37 * result + ( ref != null ? ref.hashCode() : 0 );
        result = 37 * result + ( img != null ? img.hashCode() : 0 );
        result = 37 * result + ( alt != null ? alt.hashCode() : 0 );
        result = 37 * result + ( position != null ? position.hashCode() : 0 );
        result = 37 * result + ( border != null ? border.hashCode() : 0 );
        result = 37 * result + ( width != null ? width.hashCode() : 0 );
        result = 37 * result + ( height != null ? height.hashCode() : 0 );
        result = 37 * result + ( title != null ? title.hashCode() : 0 );
        result = 37 * result + ( items != null ? items.hashCode() : 0 );

        return result;
    } //-- int hashCode()

    /**
     * Get if this is a reference, setting
     * <inheritAsRef>true</inheritAsRef> means that it will be
     * populated
     *             in the project, whereas if it is false, it is
     * populated in the parent and then inherited.
     * 
     * @return boolean
     */
    public boolean isInheritAsRef()
    {
        return this.inheritAsRef;
    } //-- boolean isInheritAsRef()

    /**
     * Method removeItem.
     * 
     * @param menuItem
     */
    public void removeItem( MenuItem menuItem )
    {
        getItems().remove( menuItem );
    } //-- void removeItem( MenuItem )

    /**
     * Set the alt description for the image.
     * 
     * @param alt
     */
    public void setAlt( String alt )
    {
        this.alt = alt;
    } //-- void setAlt( String )

    /**
     * Set the border to use for the menu image.
     * 
     * @param border
     */
    public void setBorder( String border )
    {
        this.border = border;
    } //-- void setBorder( String )

    /**
     * Set the height to use for the menu image.
     * 
     * @param height
     */
    public void setHeight( String height )
    {
        this.height = height;
    } //-- void setHeight( String )

    /**
     * Set the source location of an menu image.
     * 
     * @param img
     */
    public void setImg( String img )
    {
        this.img = img;
    } //-- void setImg( String )

    /**
     * Set the way in which the menu is inherited. Can be one of :
     * <code>top</code>, <code>bottom</code>.
     * 
     * @param inherit
     */
    public void setInherit( String inherit )
    {
        this.inherit = inherit;
    } //-- void setInherit( String )

    /**
     * Set if this is a reference, setting
     * <inheritAsRef>true</inheritAsRef> means that it will be
     * populated
     *             in the project, whereas if it is false, it is
     * populated in the parent and then inherited.
     * 
     * @param inheritAsRef
     */
    public void setInheritAsRef( boolean inheritAsRef )
    {
        this.inheritAsRef = inheritAsRef;
    } //-- void setInheritAsRef( boolean )

    /**
     * Set a list of menu item.
     * 
     * @param items
     */
    public void setItems( java.util.List<MenuItem> items )
    {
        this.items = items;
    } //-- void setItems( java.util.List )

    /**
     * Set the name to display for the menu.
     * 
     * @param name
     */
    public void setName( String name )
    {
        this.name = name;
    } //-- void setName( String )

    /**
     * Set where to place the image regarding the displayed name
     * (left or right).
     * 
     * @param position
     */
    public void setPosition( String position )
    {
        this.position = position;
    } //-- void setPosition( String )

    /**
     * Set mark this menu as reference to a pre-defined menu:
     * <code>reports</code>, <code>modules</code>
     *             or <code>parent</code>. It will be populated at
     * runtime with corresponding pre-defined content.
     * 
     * @param ref
     */
    public void setRef( String ref )
    {
        this.ref = ref;
    } //-- void setRef( String )

    /**
     * Set the title for the image.
     * 
     * @param title
     */
    public void setTitle( String title )
    {
        this.title = title;
    } //-- void setTitle( String )

    /**
     * Set the width to use for the menu image.
     * 
     * @param width
     */
    public void setWidth( String width )
    {
        this.width = width;
    } //-- void setWidth( String )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuilder buf = new StringBuilder( 128 );

        buf.append( "name = '" );
        buf.append( getName() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "inherit = '" );
        buf.append( getInherit() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "ref = '" );
        buf.append( getRef() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "img = '" );
        buf.append( getImg() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "alt = '" );
        buf.append( getAlt() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "position = '" );
        buf.append( getPosition() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "border = '" );
        buf.append( getBorder() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "width = '" );
        buf.append( getWidth() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "height = '" );
        buf.append( getHeight() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "title = '" );
        buf.append( getTitle() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "items = '" );
        buf.append( getItems() );
        buf.append( "'" );

        return buf.toString();
    } //-- java.lang.String toString()

}
