// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 1.8.1,
// any modifications will be overwritten.
// ==============================================================

package org.apache.maven.doxia.site.decoration.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DateFormat;
import org.apache.maven.doxia.site.decoration.Banner;
import org.apache.maven.doxia.site.decoration.Body;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.LinkItem;
import org.apache.maven.doxia.site.decoration.Logo;
import org.apache.maven.doxia.site.decoration.Menu;
import org.apache.maven.doxia.site.decoration.MenuItem;
import org.apache.maven.doxia.site.decoration.PublishDate;
import org.apache.maven.doxia.site.decoration.Skin;
import org.apache.maven.doxia.site.decoration.Version;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/**
 * Class DecorationXpp3Reader.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class DecorationXpp3Reader
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * If set the parser will be loaded with all single characters
     * from the XHTML specification.
     * The entities used:
     * <ul>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-lat1.ent</li>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-special.ent</li>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-symbol.ent</li>
     * </ul>
     */
    private boolean addDefaultEntities = true;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method checkFieldWithDuplicate.
     * 
     * @param parser
     * @param parsed
     * @param alias
     * @param tagName
     * @throws XmlPullParserException
     * @return boolean
     */
    private boolean checkFieldWithDuplicate( XmlPullParser parser, String tagName, String alias, java.util.Set parsed )
        throws XmlPullParserException
    {
        if ( !( parser.getName().equals( tagName ) || parser.getName().equals( alias ) ) )
        {
            return false;
        }
        if ( !parsed.add( tagName ) )
        {
            throw new XmlPullParserException( "Duplicated tag: '" + tagName + "'", parser, null );
        }
        return true;
    } //-- boolean checkFieldWithDuplicate( XmlPullParser, String, String, java.util.Set )

    /**
     * Method checkUnknownAttribute.
     * 
     * @param parser
     * @param strict
     * @param tagName
     * @param attribute
     * @throws XmlPullParserException
     * @throws IOException
     */
    private void checkUnknownAttribute( XmlPullParser parser, String attribute, String tagName, boolean strict )
        throws XmlPullParserException, IOException
    {
        // strictXmlAttributes = true for model: if strict == true, not only elements are checked but attributes too
        if ( strict )
        {
            throw new XmlPullParserException( "Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null );
        }
    } //-- void checkUnknownAttribute( XmlPullParser, String, String, boolean )

    /**
     * Method checkUnknownElement.
     * 
     * @param parser
     * @param strict
     * @throws XmlPullParserException
     * @throws IOException
     */
    private void checkUnknownElement( XmlPullParser parser, boolean strict )
        throws XmlPullParserException, IOException
    {
        if ( strict )
        {
            throw new XmlPullParserException( "Unrecognised tag: '" + parser.getName() + "'", parser, null );
        }

        for ( int unrecognizedTagCount = 1; unrecognizedTagCount > 0; )
        {
            int eventType = parser.next();
            if ( eventType == XmlPullParser.START_TAG )
            {
                unrecognizedTagCount++;
            }
            else if ( eventType == XmlPullParser.END_TAG )
            {
                unrecognizedTagCount--;
            }
        }
    } //-- void checkUnknownElement( XmlPullParser, boolean )

    /**
     * Returns the state of the "add default entities" flag.
     * 
     * @return boolean
     */
    public boolean getAddDefaultEntities()
    {
        return addDefaultEntities;
    } //-- boolean getAddDefaultEntities()

    /**
     * Method getBooleanValue.
     * 
     * @param s
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        return getBooleanValue( s, attribute, parser, null );
    } //-- boolean getBooleanValue( String, String, XmlPullParser )

    /**
     * Method getBooleanValue.
     * 
     * @param s
     * @param defaultValue
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XmlPullParser parser, String defaultValue )
        throws XmlPullParserException
    {
        if ( s != null && s.length() != 0 )
        {
            return Boolean.valueOf( s ).booleanValue();
        }
        if ( defaultValue != null )
        {
            return Boolean.valueOf( defaultValue ).booleanValue();
        }
        return false;
    } //-- boolean getBooleanValue( String, String, XmlPullParser, String )

    /**
     * Method getByteValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return byte
     */
    private byte getByteValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Byte.valueOf( s ).byteValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a byte", parser, nfe );
                }
            }
        }
        return 0;
    } //-- byte getByteValue( String, String, XmlPullParser, boolean )

    /**
     * Method getCharacterValue.
     * 
     * @param s
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return char
     */
    private char getCharacterValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            return s.charAt( 0 );
        }
        return 0;
    } //-- char getCharacterValue( String, String, XmlPullParser )

    /**
     * Method getDateValue.
     * 
     * @param s
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        return getDateValue( s, attribute, null, parser );
    } //-- java.util.Date getDateValue( String, String, XmlPullParser )

    /**
     * Method getDateValue.
     * 
     * @param s
     * @param parser
     * @param dateFormat
     * @param attribute
     * @throws XmlPullParserException
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, String dateFormat, XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            String effectiveDateFormat = dateFormat;
            if ( dateFormat == null )
            {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ( "long".equals( effectiveDateFormat ) )
            {
                try
                {
                    return new java.util.Date( Long.parseLong( s ) );
                }
                catch ( NumberFormatException e )
                {
                    throw new XmlPullParserException( e.getMessage(), parser, e );
                }
            }
            else
            {
                try
                {
                    DateFormat dateParser = new java.text.SimpleDateFormat( effectiveDateFormat, java.util.Locale.US );
                    return dateParser.parse( s );
                }
                catch ( java.text.ParseException e )
                {
                    throw new XmlPullParserException( e.getMessage(), parser, e );
                }
            }
        }
        return null;
    } //-- java.util.Date getDateValue( String, String, String, XmlPullParser )

    /**
     * Method getDoubleValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return double
     */
    private double getDoubleValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Double.valueOf( s ).doubleValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe );
                }
            }
        }
        return 0;
    } //-- double getDoubleValue( String, String, XmlPullParser, boolean )

    /**
     * Method getFloatValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return float
     */
    private float getFloatValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Float.valueOf( s ).floatValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe );
                }
            }
        }
        return 0;
    } //-- float getFloatValue( String, String, XmlPullParser, boolean )

    /**
     * Method getIntegerValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return int
     */
    private int getIntegerValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Integer.valueOf( s ).intValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be an integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- int getIntegerValue( String, String, XmlPullParser, boolean )

    /**
     * Method getLongValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return long
     */
    private long getLongValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Long.valueOf( s ).longValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a long integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- long getLongValue( String, String, XmlPullParser, boolean )

    /**
     * Method getRequiredAttributeValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return String
     */
    private String getRequiredAttributeValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s == null )
        {
            if ( strict )
            {
                throw new XmlPullParserException( "Missing required value for attribute '" + attribute + "'", parser, null );
            }
        }
        return s;
    } //-- String getRequiredAttributeValue( String, String, XmlPullParser, boolean )

    /**
     * Method getShortValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return short
     */
    private short getShortValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Short.valueOf( s ).shortValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a short integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- short getShortValue( String, String, XmlPullParser, boolean )

    /**
     * Method getTrimmedValue.
     * 
     * @param s
     * @return String
     */
    private String getTrimmedValue( String s )
    {
        if ( s != null )
        {
            s = s.trim();
        }
        return s;
    } //-- String getTrimmedValue( String )

    /**
     * Method nextTag.
     * 
     * @param parser
     * @throws IOException
     * @throws XmlPullParserException
     * @return int
     */
    private int nextTag( XmlPullParser parser )
        throws IOException, XmlPullParserException
    {
        int eventType = parser.next();
        if ( eventType == XmlPullParser.TEXT )
        {
            eventType = parser.next();
        }
        if ( eventType != XmlPullParser.START_TAG && eventType != XmlPullParser.END_TAG )
        {
            throw new XmlPullParserException( "expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null );
        }
        return eventType;
    } //-- int nextTag( XmlPullParser )

    /**
     * @see ReaderFactory#newXmlReader
     * 
     * @param reader
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return DecorationModel
     */
    public DecorationModel read( Reader reader, boolean strict )
        throws IOException, XmlPullParserException
    {
        XmlPullParser parser = addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser( );

        parser.setInput( reader );


        return read( parser, strict );
    } //-- DecorationModel read( Reader, boolean )

    /**
     * @see ReaderFactory#newXmlReader
     * 
     * @param reader
     * @throws IOException
     * @throws XmlPullParserException
     * @return DecorationModel
     */
    public DecorationModel read( Reader reader )
        throws IOException, XmlPullParserException
    {
        return read( reader, true );
    } //-- DecorationModel read( Reader )

    /**
     * Method read.
     * 
     * @param in
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return DecorationModel
     */
    public DecorationModel read( InputStream in, boolean strict )
        throws IOException, XmlPullParserException
    {
        return read( ReaderFactory.newXmlReader( in ), strict );
    } //-- DecorationModel read( InputStream, boolean )

    /**
     * Method read.
     * 
     * @param in
     * @throws IOException
     * @throws XmlPullParserException
     * @return DecorationModel
     */
    public DecorationModel read( InputStream in )
        throws IOException, XmlPullParserException
    {
        return read( ReaderFactory.newXmlReader( in ) );
    } //-- DecorationModel read( InputStream )

    /**
     * Method parseBanner.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return Banner
     */
    private Banner parseBanner( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Banner banner = new Banner();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "name", null, parsed ) )
            {
                banner.setName( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "src", null, parsed ) )
            {
                banner.setSrc( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "alt", null, parsed ) )
            {
                banner.setAlt( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "href", null, parsed ) )
            {
                banner.setHref( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "border", null, parsed ) )
            {
                banner.setBorder( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "width", null, parsed ) )
            {
                banner.setWidth( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "height", null, parsed ) )
            {
                banner.setHeight( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "title", null, parsed ) )
            {
                banner.setTitle( getTrimmedValue( parser.nextText() ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return banner;
    } //-- Banner parseBanner( XmlPullParser, boolean )

    /**
     * Method parseBody.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return Body
     */
    private Body parseBody( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Body body = new Body();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "head", null, parsed ) )
            {
                body.setHead( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "links", null, parsed ) )
            {
                java.util.List links = new java.util.ArrayList/*<LinkItem>*/();
                body.setLinks( links );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "item".equals( parser.getName() ) )
                    {
                        links.add( parseLinkItem( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "breadcrumbs", null, parsed ) )
            {
                java.util.List breadcrumbs = new java.util.ArrayList/*<LinkItem>*/();
                body.setBreadcrumbs( breadcrumbs );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "item".equals( parser.getName() ) )
                    {
                        breadcrumbs.add( parseLinkItem( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( "menu".equals( parser.getName() ) )
            {
                java.util.List menus = body.getMenus();
                if ( menus == null )
                {
                    menus = new java.util.ArrayList/*<Menu>*/();
                    body.setMenus( menus );
                }
                menus.add( parseMenu( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "footer", null, parsed ) )
            {
                body.setFooter( getTrimmedValue( parser.nextText() ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return body;
    } //-- Body parseBody( XmlPullParser, boolean )

    /**
     * Method parseDecorationModel.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return DecorationModel
     */
    private DecorationModel parseDecorationModel( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        DecorationModel decorationModel = new DecorationModel();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "xmlns".equals( name ) )
            {
                // ignore xmlns attribute in root class, which is a reserved attribute name
            }
            else if ( "name".equals( name ) )
            {
                decorationModel.setName( getTrimmedValue( value ) );
            }
            else if ( "combine.self".equals( name ) )
            {
                decorationModel.setCombineSelf( getTrimmedValue( value ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "bannerLeft", null, parsed ) )
            {
                decorationModel.setBannerLeft( parseBanner( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "bannerRight", null, parsed ) )
            {
                decorationModel.setBannerRight( parseBanner( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "googleAdSenseClient", null, parsed ) )
            {
                decorationModel.setGoogleAdSenseClient( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "googleAdSenseSlot", null, parsed ) )
            {
                decorationModel.setGoogleAdSenseSlot( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "googleAnalyticsAccountId", null, parsed ) )
            {
                decorationModel.setGoogleAnalyticsAccountId( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "publishDate", null, parsed ) )
            {
                decorationModel.setPublishDate( parsePublishDate( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "version", null, parsed ) )
            {
                decorationModel.setVersion( parseVersion( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "poweredBy", null, parsed ) )
            {
                java.util.List poweredBy = new java.util.ArrayList/*<Logo>*/();
                decorationModel.setPoweredBy( poweredBy );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "logo".equals( parser.getName() ) )
                    {
                        poweredBy.add( parseLogo( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "skin", null, parsed ) )
            {
                decorationModel.setSkin( parseSkin( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "body", null, parsed ) )
            {
                decorationModel.setBody( parseBody( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "custom", null, parsed ) )
            {
                decorationModel.setCustom( org.codehaus.plexus.util.xml.Xpp3DomBuilder.build( parser, true ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return decorationModel;
    } //-- DecorationModel parseDecorationModel( XmlPullParser, boolean )

    /**
     * Method parseLinkItem.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return LinkItem
     */
    private LinkItem parseLinkItem( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        LinkItem linkItem = new LinkItem();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "name".equals( name ) )
            {
                linkItem.setName( getTrimmedValue( value ) );
            }
            else if ( "href".equals( name ) )
            {
                linkItem.setHref( getTrimmedValue( value ) );
            }
            else if ( "img".equals( name ) )
            {
                linkItem.setImg( getTrimmedValue( value ) );
            }
            else if ( "position".equals( name ) )
            {
                linkItem.setPosition( getTrimmedValue( value ) );
            }
            else if ( "alt".equals( name ) )
            {
                linkItem.setAlt( getTrimmedValue( value ) );
            }
            else if ( "border".equals( name ) )
            {
                linkItem.setBorder( getTrimmedValue( value ) );
            }
            else if ( "width".equals( name ) )
            {
                linkItem.setWidth( getTrimmedValue( value ) );
            }
            else if ( "height".equals( name ) )
            {
                linkItem.setHeight( getTrimmedValue( value ) );
            }
            else if ( "target".equals( name ) )
            {
                linkItem.setTarget( getTrimmedValue( value ) );
            }
            else if ( "title".equals( name ) )
            {
                linkItem.setTitle( getTrimmedValue( value ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            checkUnknownElement( parser, strict );
        }
        return linkItem;
    } //-- LinkItem parseLinkItem( XmlPullParser, boolean )

    /**
     * Method parseLogo.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return Logo
     */
    private Logo parseLogo( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Logo logo = new Logo();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "name".equals( name ) )
            {
                logo.setName( getTrimmedValue( value ) );
            }
            else if ( "href".equals( name ) )
            {
                logo.setHref( getTrimmedValue( value ) );
            }
            else if ( "img".equals( name ) )
            {
                logo.setImg( getTrimmedValue( value ) );
            }
            else if ( "position".equals( name ) )
            {
                logo.setPosition( getTrimmedValue( value ) );
            }
            else if ( "alt".equals( name ) )
            {
                logo.setAlt( getTrimmedValue( value ) );
            }
            else if ( "border".equals( name ) )
            {
                logo.setBorder( getTrimmedValue( value ) );
            }
            else if ( "width".equals( name ) )
            {
                logo.setWidth( getTrimmedValue( value ) );
            }
            else if ( "height".equals( name ) )
            {
                logo.setHeight( getTrimmedValue( value ) );
            }
            else if ( "target".equals( name ) )
            {
                logo.setTarget( getTrimmedValue( value ) );
            }
            else if ( "title".equals( name ) )
            {
                logo.setTitle( getTrimmedValue( value ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            checkUnknownElement( parser, strict );
        }
        return logo;
    } //-- Logo parseLogo( XmlPullParser, boolean )

    /**
     * Method parseMenu.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return Menu
     */
    private Menu parseMenu( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Menu menu = new Menu();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "name".equals( name ) )
            {
                menu.setName( getTrimmedValue( value ) );
            }
            else if ( "inherit".equals( name ) )
            {
                menu.setInherit( getTrimmedValue( value ) );
            }
            else if ( "inheritAsRef".equals( name ) )
            {
                menu.setInheritAsRef( getBooleanValue( getTrimmedValue( value ), "inheritAsRef", parser, "false" ) );
            }
            else if ( "ref".equals( name ) )
            {
                menu.setRef( getTrimmedValue( value ) );
            }
            else if ( "img".equals( name ) )
            {
                menu.setImg( getTrimmedValue( value ) );
            }
            else if ( "alt".equals( name ) )
            {
                menu.setAlt( getTrimmedValue( value ) );
            }
            else if ( "position".equals( name ) )
            {
                menu.setPosition( getTrimmedValue( value ) );
            }
            else if ( "border".equals( name ) )
            {
                menu.setBorder( getTrimmedValue( value ) );
            }
            else if ( "width".equals( name ) )
            {
                menu.setWidth( getTrimmedValue( value ) );
            }
            else if ( "height".equals( name ) )
            {
                menu.setHeight( getTrimmedValue( value ) );
            }
            else if ( "title".equals( name ) )
            {
                menu.setTitle( getTrimmedValue( value ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( "item".equals( parser.getName() ) )
            {
                java.util.List items = menu.getItems();
                if ( items == null )
                {
                    items = new java.util.ArrayList/*<MenuItem>*/();
                    menu.setItems( items );
                }
                items.add( parseMenuItem( parser, strict ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return menu;
    } //-- Menu parseMenu( XmlPullParser, boolean )

    /**
     * Method parseMenuItem.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return MenuItem
     */
    private MenuItem parseMenuItem( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        MenuItem menuItem = new MenuItem();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "collapse".equals( name ) )
            {
                menuItem.setCollapse( getBooleanValue( getTrimmedValue( value ), "collapse", parser, "false" ) );
            }
            else if ( "ref".equals( name ) )
            {
                menuItem.setRef( getTrimmedValue( value ) );
            }
            else if ( "name".equals( name ) )
            {
                menuItem.setName( getTrimmedValue( value ) );
            }
            else if ( "href".equals( name ) )
            {
                menuItem.setHref( getTrimmedValue( value ) );
            }
            else if ( "img".equals( name ) )
            {
                menuItem.setImg( getTrimmedValue( value ) );
            }
            else if ( "position".equals( name ) )
            {
                menuItem.setPosition( getTrimmedValue( value ) );
            }
            else if ( "alt".equals( name ) )
            {
                menuItem.setAlt( getTrimmedValue( value ) );
            }
            else if ( "border".equals( name ) )
            {
                menuItem.setBorder( getTrimmedValue( value ) );
            }
            else if ( "width".equals( name ) )
            {
                menuItem.setWidth( getTrimmedValue( value ) );
            }
            else if ( "height".equals( name ) )
            {
                menuItem.setHeight( getTrimmedValue( value ) );
            }
            else if ( "target".equals( name ) )
            {
                menuItem.setTarget( getTrimmedValue( value ) );
            }
            else if ( "title".equals( name ) )
            {
                menuItem.setTitle( getTrimmedValue( value ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "description", null, parsed ) )
            {
                menuItem.setDescription( getTrimmedValue( parser.nextText() ) );
            }
            else if ( "item".equals( parser.getName() ) )
            {
                java.util.List items = menuItem.getItems();
                if ( items == null )
                {
                    items = new java.util.ArrayList/*<MenuItem>*/();
                    menuItem.setItems( items );
                }
                items.add( parseMenuItem( parser, strict ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return menuItem;
    } //-- MenuItem parseMenuItem( XmlPullParser, boolean )

    /**
     * Method parsePublishDate.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return PublishDate
     */
    private PublishDate parsePublishDate( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        PublishDate publishDate = new PublishDate();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "position".equals( name ) )
            {
                publishDate.setPosition( getTrimmedValue( value ) );
            }
            else if ( "format".equals( name ) )
            {
                publishDate.setFormat( getTrimmedValue( value ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            checkUnknownElement( parser, strict );
        }
        return publishDate;
    } //-- PublishDate parsePublishDate( XmlPullParser, boolean )

    /**
     * Method parseSkin.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return Skin
     */
    private Skin parseSkin( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Skin skin = new Skin();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "groupId", null, parsed ) )
            {
                skin.setGroupId( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "artifactId", null, parsed ) )
            {
                skin.setArtifactId( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "version", null, parsed ) )
            {
                skin.setVersion( getTrimmedValue( parser.nextText() ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return skin;
    } //-- Skin parseSkin( XmlPullParser, boolean )

    /**
     * Method parseVersion.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return Version
     */
    private Version parseVersion( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Version version = new Version();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "position".equals( name ) )
            {
                version.setPosition( getTrimmedValue( value ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            checkUnknownElement( parser, strict );
        }
        return version;
    } //-- Version parseVersion( XmlPullParser, boolean )

    /**
     * Method read.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return DecorationModel
     */
    private DecorationModel read( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        int eventType = parser.getEventType();
        while ( eventType != XmlPullParser.END_DOCUMENT )
        {
            if ( eventType == XmlPullParser.START_TAG )
            {
                if ( strict && ! "project".equals( parser.getName() ) )
                {
                    throw new XmlPullParserException( "Expected root element 'project' but found '" + parser.getName() + "'", parser, null );
                }
                DecorationModel decorationModel = parseDecorationModel( parser, strict );
                decorationModel.setModelEncoding( parser.getInputEncoding() );
                return decorationModel;
            }
            eventType = parser.next();
        }
        throw new XmlPullParserException( "Expected root element 'project' but found no element at all: invalid XML document", parser, null );
    } //-- DecorationModel read( XmlPullParser, boolean )

    /**
     * Sets the state of the "add default entities" flag.
     * 
     * @param addDefaultEntities
     */
    public void setAddDefaultEntities( boolean addDefaultEntities )
    {
        this.addDefaultEntities = addDefaultEntities;
    } //-- void setAddDefaultEntities( boolean )

}
