/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.confluence;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.doxia.module.confluence.parser.Block;
import org.apache.maven.doxia.module.confluence.parser.BlockParser;
import org.apache.maven.doxia.module.confluence.parser.HorizontalRuleBlockParser;
import org.apache.maven.doxia.module.confluence.parser.ParagraphBlockParser;
import org.apache.maven.doxia.module.confluence.parser.SectionBlockParser;
import org.apache.maven.doxia.module.confluence.parser.VerbatimBlockParser;
import org.apache.maven.doxia.module.confluence.parser.list.ListBlockParser;
import org.apache.maven.doxia.module.confluence.parser.table.TableBlockParser;
import org.apache.maven.doxia.parser.AbstractTextParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.util.ByLineReaderSource;
import org.apache.maven.doxia.util.ByLineSource;

public class ConfluenceParser
extends AbstractTextParser {
    private BlockParser[] parsers;

    public ConfluenceParser() {
        SectionBlockParser headingParser = new SectionBlockParser();
        VerbatimBlockParser verbatimParser = new VerbatimBlockParser();
        HorizontalRuleBlockParser horizontalRuleParser = new HorizontalRuleBlockParser();
        ParagraphBlockParser paragraphParser = new ParagraphBlockParser();
        ListBlockParser listParser = new ListBlockParser();
        TableBlockParser tableParser = new TableBlockParser();
        this.parsers = new BlockParser[]{headingParser, verbatimParser, horizontalRuleParser, listParser, tableParser, paragraphParser};
    }

    public List parse(ByLineSource source) throws ParseException {
        String line;
        ArrayList<Block> blocks = new ArrayList<Block>();
        block0: while ((line = source.getNextLine()) != null) {
            boolean accepted = false;
            for (int i = 0; i < this.parsers.length; ++i) {
                BlockParser parser = this.parsers[i];
                if (line.trim().length() == 0 || !parser.accept(line, source)) continue;
                accepted = true;
                blocks.add(parser.visit(line, source));
                continue block0;
            }
        }
        return blocks;
    }

    public synchronized void parse(Reader reader, Sink sink) throws ParseException {
        List blocks;
        ByLineReaderSource source = new ByLineReaderSource(reader);
        try {
            blocks = this.parse((ByLineSource)source);
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(e, source.getName(), source.getLineNumber());
        }
        sink.head();
        sink.head_();
        sink.body();
        Iterator i = blocks.iterator();
        while (i.hasNext()) {
            Block block = (Block)i.next();
            block.traverse(sink);
        }
        sink.body_();
    }
}

