/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.confluence.parser.list;

import org.apache.maven.doxia.module.confluence.parser.Block;
import org.apache.maven.doxia.module.confluence.parser.BlockParser;
import org.apache.maven.doxia.module.confluence.parser.list.TreeListBuilder;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.util.ByLineSource;

public class ListBlockParser
implements BlockParser {
    public static int BULLETED_LIST = 0;
    public static int NUMBERED_LIST = 1;

    public boolean accept(String line, ByLineSource source) {
        String nextLine = null;
        try {
            nextLine = source.getNextLine();
            source.ungetLine();
        }
        catch (ParseException e) {
            // empty catch block
        }
        return this.isList(line) && this.isList(nextLine);
    }

    public Block visit(String line, ByLineSource source) throws ParseException {
        TreeListBuilder treeListBuilder = new TreeListBuilder();
        String l = line;
        while (this.isList(l)) {
            int level;
            if (this.isBulletedList(l)) {
                level = this.getLevel(l, '*');
                treeListBuilder.feedEntry(BULLETED_LIST, level, l.substring(level));
            } else {
                level = this.getLevel(l, '#');
                treeListBuilder.feedEntry(NUMBERED_LIST, level, l.substring(level));
            }
            if ((l = source.getNextLine()) != null) continue;
        }
        return treeListBuilder.getBlock();
    }

    private int getLevel(String line, char c) {
        int level = 0;
        while (line.charAt(level) == c) {
            ++level;
        }
        return level;
    }

    private boolean isBulletedList(String line) {
        return line.startsWith("*") || line.startsWith("-");
    }

    private boolean isList(String line) {
        return (line = line.trim()).startsWith("*") || line.startsWith("-") || line.startsWith("#");
    }
}

