/*
 * $Id$
 */

package org.apache.maven.doxia.module.fml.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         FAQ part.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Part implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field title
     */
    private String title;

    /**
     * Field faqs
     */
    private java.util.List faqs;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addFaq
     * 
     * @param faq
     */
    public void addFaq(Faq faq)
    {
        if ( !(faq instanceof Faq) )
        {
            throw new ClassCastException( "Part.addFaqs(faq) parameter must be instanceof " + Faq.class.getName() );
        }
        getFaqs().add( faq );
    } //-- void addFaq(Faq) 

    /**
     * Method equals
     * 
     * @param other
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof Part) )
        {
            return false;
        }
        
        Part that = (Part) other;
        boolean result = true;
        result = result && ( getId() == null ? that.getId() == null : getId().equals( that.getId() ) );
        result = result && ( getTitle() == null ? that.getTitle() == null : getTitle().equals( that.getTitle() ) );
        result = result && ( getFaqs() == null ? that.getFaqs() == null : getFaqs().equals( that.getFaqs() ) );
        return result;
    } //-- boolean equals(Object) 

    /**
     * Method getFaqs
     */
    public java.util.List getFaqs()
    {
        if ( this.faqs == null )
        {
            this.faqs = new java.util.ArrayList();
        }
        
        return this.faqs;
    } //-- java.util.List getFaqs() 

    /**
     * Get 
     *             The identifier of the part.
     *           
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Get 
     *             The title of the FAQ part.
     *           
     */
    public String getTitle()
    {
        return this.title;
    } //-- String getTitle() 

    /**
     * Method hashCode
     */
    public int hashCode()
    {
        int result = 17;
        long tmp;
        result = 37 * result + ( id != null ? id.hashCode() : 0 );
        result = 37 * result + ( title != null ? title.hashCode() : 0 );
        result = 37 * result + ( faqs != null ? faqs.hashCode() : 0 );
        return result;
    } //-- int hashCode() 

    /**
     * Method removeFaq
     * 
     * @param faq
     */
    public void removeFaq(Faq faq)
    {
        if ( !(faq instanceof Faq) )
        {
            throw new ClassCastException( "Part.removeFaqs(faq) parameter must be instanceof " + Faq.class.getName() );
        }
        getFaqs().remove( faq );
    } //-- void removeFaq(Faq) 

    /**
     * Set 
     *             A list of FAQ.
     *           
     * 
     * @param faqs
     */
    public void setFaqs(java.util.List faqs)
    {
        this.faqs = faqs;
    } //-- void setFaqs(java.util.List) 

    /**
     * Set 
     *             The identifier of the part.
     *           
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Set 
     *             The title of the FAQ part.
     *           
     * 
     * @param title
     */
    public void setTitle(String title)
    {
        this.title = title;
    } //-- void setTitle(String) 

    /**
     * Method toString
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append( "id = '" );
        buf.append( getId() + "'" );
        buf.append( "\n" ); 
        buf.append( "title = '" );
        buf.append( getTitle() + "'" );
        buf.append( "\n" ); 
        buf.append( "faqs = '" );
        buf.append( getFaqs() + "'" );
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
