/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.fml;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.module.fml.FmlContentParser;
import org.apache.maven.doxia.module.fml.FmlMarkup;
import org.apache.maven.doxia.module.fml.model.Faq;
import org.apache.maven.doxia.module.fml.model.Faqs;
import org.apache.maven.doxia.module.fml.model.Part;
import org.apache.maven.doxia.parser.AbstractXmlParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class FmlParser
extends AbstractXmlParser
implements FmlMarkup {
    private final Faqs faqs = new Faqs();
    private Part currentPart;
    private Faq currentFaq;
    private boolean inQuestion;
    private boolean inAnswer;
    private StringBuffer buffer;

    public void parse(Reader source, Sink sink) throws ParseException {
        super.parse(source, sink);
        this.writeFaqs(this.faqs, sink);
    }

    protected void handleStartTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (parser.getName().equals(FAQS_TAG.toString())) {
            String toplink;
            String title = parser.getAttributeValue(null, "title");
            if (title != null) {
                this.faqs.setTitle(title);
            }
            if ((toplink = parser.getAttributeValue(null, "toplink")) != null) {
                if (toplink.equalsIgnoreCase("true")) {
                    this.faqs.setToplink(true);
                } else {
                    this.faqs.setToplink(false);
                }
            }
        } else if (parser.getName().equals(PART_TAG.toString())) {
            this.currentPart = new Part();
            this.currentPart.setId(parser.getAttributeValue(null, HTML.Attribute.ID.toString()));
            if (this.currentPart.getId() == null) {
                throw new XmlPullParserException("id attribute required for <part> at: (" + parser.getLineNumber() + ":" + parser.getColumnNumber() + ")");
            }
            if (!DoxiaUtils.isValidId((String)this.currentPart.getId())) {
                this.getLog().warn((CharSequence)("Modified invalid id: " + this.currentPart.getId()));
                this.currentPart.setId(DoxiaUtils.encodeId((String)this.currentPart.getId()));
            }
        } else if (parser.getName().equals(HTML.Tag.TITLE.toString())) {
            if (this.currentPart == null) {
                throw new XmlPullParserException("Missing <part> at: (" + parser.getLineNumber() + ":" + parser.getColumnNumber() + ")");
            }
            try {
                this.currentPart.setTitle(parser.nextText().trim());
            }
            catch (IOException e) {
                throw new XmlPullParserException("Error reading title: " + e.getMessage(), parser, (Throwable)e);
            }
        } else if (parser.getName().equals(FAQ_TAG.toString())) {
            this.currentFaq = new Faq();
            this.currentFaq.setId(parser.getAttributeValue(null, HTML.Attribute.ID.toString()));
            if (this.currentFaq.getId() == null) {
                throw new XmlPullParserException("id attribute required for <faq> at: (" + parser.getLineNumber() + ":" + parser.getColumnNumber() + ")");
            }
            if (!DoxiaUtils.isValidId((String)this.currentFaq.getId())) {
                this.getLog().warn((CharSequence)("Modified invalid id: " + this.currentFaq.getId()));
                this.currentFaq.setId(DoxiaUtils.encodeId((String)this.currentFaq.getId()));
            }
        }
        if (parser.getName().equals(QUESTION_TAG.toString())) {
            this.buffer = new StringBuffer();
            this.buffer.append(String.valueOf('<')).append(parser.getName()).append(String.valueOf('>'));
            this.inQuestion = true;
        } else if (parser.getName().equals(ANSWER_TAG.toString())) {
            this.buffer = new StringBuffer();
            this.buffer.append(String.valueOf('<')).append(parser.getName()).append(String.valueOf('>'));
            this.inAnswer = true;
        } else if (this.inQuestion || this.inAnswer) {
            this.buffer.append(String.valueOf('<')).append(parser.getName());
            int count = parser.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                this.buffer.append(String.valueOf(' ')).append(parser.getAttributeName(i));
                this.buffer.append(String.valueOf('=')).append(String.valueOf('\"'));
                this.buffer.append(HtmlTools.escapeHTML((String)parser.getAttributeValue(i)));
                this.buffer.append(String.valueOf('\"'));
            }
            this.buffer.append(String.valueOf('>'));
        }
    }

    protected void handleEndTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (!parser.getName().equals(FAQS_TAG.toString())) {
            if (parser.getName().equals(PART_TAG.toString())) {
                this.faqs.addPart(this.currentPart);
                this.currentPart = null;
            } else if (parser.getName().equals(FAQ_TAG.toString())) {
                if (this.currentPart == null) {
                    throw new XmlPullParserException("Missing <part>  at: (" + parser.getLineNumber() + ":" + parser.getColumnNumber() + ")");
                }
                this.currentPart.addFaq(this.currentFaq);
                this.currentFaq = null;
            } else if (parser.getName().equals(QUESTION_TAG.toString())) {
                if (this.currentFaq == null) {
                    throw new XmlPullParserException("Missing <faq> at: (" + parser.getLineNumber() + ":" + parser.getColumnNumber() + ")");
                }
                this.buffer.append(String.valueOf('<')).append(String.valueOf('/')).append(parser.getName()).append(String.valueOf('>'));
                this.currentFaq.setQuestion(this.buffer.toString());
                this.inQuestion = false;
            } else if (parser.getName().equals(ANSWER_TAG.toString())) {
                if (this.currentFaq == null) {
                    throw new XmlPullParserException("Missing <faq> at: (" + parser.getLineNumber() + ":" + parser.getColumnNumber() + ")");
                }
                this.buffer.append(String.valueOf('<')).append(String.valueOf('/')).append(parser.getName()).append(String.valueOf('>'));
                this.currentFaq.setAnswer(this.buffer.toString());
                this.inAnswer = false;
            } else if (this.inQuestion || this.inAnswer) {
                if (this.buffer.charAt(this.buffer.length() - 1) == ' ') {
                    this.buffer.deleteCharAt(this.buffer.length() - 1);
                }
                this.buffer.append(String.valueOf('<')).append(String.valueOf('/')).append(parser.getName()).append(String.valueOf('>'));
            }
        }
    }

    protected void handleText(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        if (this.buffer != null && parser.getText() != null) {
            this.buffer.append(parser.getText());
        }
    }

    protected void handleCdsect(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        if (this.buffer != null && parser.getText() != null) {
            this.buffer.append(String.valueOf('<')).append(String.valueOf('!')).append(String.valueOf('[')).append(String.valueOf("CDATA")).append(String.valueOf('[')).append(parser.getText()).append(String.valueOf(']')).append(String.valueOf(']')).append(String.valueOf('>'));
        }
    }

    protected void handleComment(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        sink.comment(parser.getText().trim());
    }

    protected void handleEntity(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        if (this.buffer != null && parser.getText() != null) {
            this.buffer.append(HtmlTools.escapeHTML((String)parser.getText()));
        }
    }

    private void writeFaqs(Faqs faqs, Sink sink) throws ParseException {
        Faq faq;
        Iterator faqIterator;
        Part part;
        FmlContentParser xdocParser = new FmlContentParser();
        xdocParser.enableLogging(this.getLog());
        sink.head();
        sink.title();
        sink.text(faqs.getTitle());
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.anchor("top");
        sink.text(faqs.getTitle());
        sink.anchor_();
        sink.sectionTitle1_();
        Iterator partIterator = faqs.getParts().iterator();
        while (partIterator.hasNext()) {
            part = (Part)partIterator.next();
            if (StringUtils.isNotEmpty((String)part.getTitle())) {
                sink.paragraph();
                sink.bold();
                sink.text(part.getTitle());
                sink.bold_();
                sink.paragraph_();
            }
            sink.numberedList(0);
            faqIterator = part.getFaqs().iterator();
            while (faqIterator.hasNext()) {
                faq = (Faq)faqIterator.next();
                sink.numberedListItem();
                sink.link("#" + faq.getId());
                if (!StringUtils.isNotEmpty((String)faq.getQuestion())) {
                    throw new ParseException("Missing <question> for FAQ '" + faq.getId() + "'");
                }
                xdocParser.parse(faq.getQuestion(), sink);
                sink.link_();
                sink.numberedListItem_();
            }
            sink.numberedList_();
        }
        sink.section1_();
        partIterator = faqs.getParts().iterator();
        while (partIterator.hasNext()) {
            part = (Part)partIterator.next();
            if (StringUtils.isNotEmpty((String)part.getTitle())) {
                sink.section1();
                sink.sectionTitle1();
                sink.text(part.getTitle());
                sink.sectionTitle1_();
            }
            sink.definitionList();
            faqIterator = part.getFaqs().iterator();
            while (faqIterator.hasNext()) {
                faq = (Faq)faqIterator.next();
                sink.definedTerm();
                sink.anchor(faq.getId());
                if (!StringUtils.isNotEmpty((String)faq.getQuestion())) {
                    throw new ParseException("Missing <question> for FAQ '" + faq.getId() + "'");
                }
                xdocParser.parse(faq.getQuestion(), sink);
                sink.anchor_();
                sink.definedTerm_();
                sink.definition();
                if (!StringUtils.isNotEmpty((String)faq.getAnswer())) {
                    throw new ParseException("Missing <answer> for FAQ '" + faq.getId() + "'");
                }
                xdocParser.parse(faq.getAnswer(), sink);
                if (faqs.isToplink()) {
                    this.writeTopLink(sink);
                }
                if (faqIterator.hasNext()) {
                    sink.horizontalRule();
                }
                sink.definition_();
            }
            sink.definitionList_();
            if (!StringUtils.isNotEmpty((String)part.getTitle())) continue;
            sink.section1_();
        }
        sink.body_();
    }

    private void writeTopLink(Sink sink) {
        int[] justify = new int[]{2};
        sink.table();
        sink.tableRows(justify, false);
        sink.tableRow();
        sink.tableCell();
        sink.link("#top");
        sink.text("[top]");
        sink.link_();
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRows_();
        sink.table_();
    }
}

