/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.fo;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Date;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.maven.doxia.document.DocumentModel;
import org.codehaus.plexus.util.StringUtils;

public class FoUtils {
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();

    private static void prepareUserAgent(FOUserAgent foUserAgent, DocumentModel documentModel) {
        if (documentModel != null && documentModel.getMeta() != null) {
            String keywords;
            String authors = documentModel.getMeta().getAllAuthorNames();
            if (StringUtils.isNotEmpty((String)authors)) {
                foUserAgent.setAuthor(authors);
            }
            if (StringUtils.isNotEmpty((String)documentModel.getMeta().getTitle())) {
                foUserAgent.setTitle(documentModel.getMeta().getTitle());
            }
            if (StringUtils.isNotEmpty((String)(keywords = documentModel.getMeta().getAllKeyWords()))) {
                foUserAgent.setKeywords(keywords);
            }
            if (StringUtils.isNotEmpty((String)documentModel.getMeta().getCreator())) {
                foUserAgent.setCreator(documentModel.getMeta().getCreator());
            }
            if (StringUtils.isNotEmpty((String)documentModel.getMeta().getGenerator())) {
                foUserAgent.setProducer(documentModel.getMeta().getGenerator());
            }
            if (documentModel.getMeta().getCreationDate() != null) {
                foUserAgent.setCreationDate(documentModel.getMeta().getCreationDate());
            }
        }
        if (foUserAgent.getCreator() == null) {
            foUserAgent.setCreator(System.getProperty("user.name"));
        }
        if (foUserAgent.getCreationDate() == null) {
            foUserAgent.setCreationDate(new Date());
        }
    }

    public static void convertFO2PDF(File fo, File pdf, String resourceDir, DocumentModel documentModel) throws TransformerException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(pdf));){
            URI baseURI = FoUtils.getBaseURI(fo, resourceDir);
            FopFactory fopFactory = new FopFactoryBuilder(baseURI).build();
            FOUserAgent userAgent = fopFactory.newFOUserAgent();
            FoUtils.prepareUserAgent(userAgent, documentModel);
            Fop fop = fopFactory.newFop("application/pdf", userAgent, (OutputStream)out);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
            transformer.transform(new StreamSource(fo), res);
        }
        catch (IOException | TransformerConfigurationException | FOPException e) {
            throw new TransformerException(e);
        }
    }

    public static void convertFO2PDF(File fo, File pdf, String resourceDir) throws TransformerException {
        FoUtils.convertFO2PDF(fo, pdf, resourceDir, null);
    }

    private static URI getBaseURI(File fo, String resourceDir) {
        if (resourceDir == null) {
            return fo.getParentFile().toURI();
        }
        return new File(resourceDir + "/").toURI();
    }

    private FoUtils() {
    }
}

