/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.doxia.module.twiki.parser.Block;
import org.apache.maven.doxia.module.twiki.parser.BlockParser;
import org.apache.maven.doxia.module.twiki.parser.FormatedTextParser;
import org.apache.maven.doxia.module.twiki.parser.GenericListBlockParser;
import org.apache.maven.doxia.module.twiki.parser.HRuleBlockParser;
import org.apache.maven.doxia.module.twiki.parser.ParagraphBlockParser;
import org.apache.maven.doxia.module.twiki.parser.SectionBlock;
import org.apache.maven.doxia.module.twiki.parser.SectionBlockParser;
import org.apache.maven.doxia.module.twiki.parser.TableBlockParser;
import org.apache.maven.doxia.module.twiki.parser.TextParser;
import org.apache.maven.doxia.module.twiki.parser.VerbatimBlockParser;
import org.apache.maven.doxia.module.twiki.parser.XHTMLWikiWordLinkResolver;
import org.apache.maven.doxia.parser.AbstractTextParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.util.ByLineReaderSource;
import org.apache.maven.doxia.util.ByLineSource;

public class TWikiParser
extends AbstractTextParser {
    private static final int EXTENSION_LENGTH = 6;
    private final ParagraphBlockParser paraParser = new ParagraphBlockParser();
    private final SectionBlockParser sectionParser = new SectionBlockParser();
    private final GenericListBlockParser listParser = new GenericListBlockParser();
    private final FormatedTextParser formatTextParser = new FormatedTextParser();
    private final TextParser textParser = new TextParser(new XHTMLWikiWordLinkResolver());
    private final HRuleBlockParser hrulerParser = new HRuleBlockParser();
    private final TableBlockParser tableParser = new TableBlockParser();
    private final VerbatimBlockParser verbatimParser = new VerbatimBlockParser();
    private final BlockParser[] parsers;

    public TWikiParser() {
        this.paraParser.setSectionParser(this.sectionParser);
        this.paraParser.setListParser(this.listParser);
        this.paraParser.setTextParser(this.formatTextParser);
        this.paraParser.setHrulerParser(this.hrulerParser);
        this.paraParser.setTableBlockParser(this.tableParser);
        this.paraParser.setVerbatimParser(this.verbatimParser);
        this.sectionParser.setParaParser(this.paraParser);
        this.sectionParser.setHrulerParser(this.hrulerParser);
        this.sectionParser.setVerbatimBlockParser(this.verbatimParser);
        this.listParser.setTextParser(this.formatTextParser);
        this.formatTextParser.setTextParser(this.textParser);
        this.tableParser.setTextParser(this.formatTextParser);
        this.parsers = new BlockParser[]{this.sectionParser, this.hrulerParser, this.verbatimParser, this.paraParser};
    }

    public final List parse(ByLineSource source) throws ParseException {
        String line;
        ArrayList<Block> ret = new ArrayList<Block>();
        while ((line = source.getNextLine()) != null) {
            boolean accepted = false;
            for (int i = 0; i < this.parsers.length; ++i) {
                BlockParser parser = this.parsers[i];
                if (!parser.accept(line)) continue;
                accepted = true;
                ret.add(parser.visit(line, source));
                break;
            }
            if (accepted) continue;
            throw new ParseException("Line number not handle : " + source.getLineNumber() + ": " + line);
        }
        return ret;
    }

    public final synchronized void parse(Reader source, Sink sink) throws ParseException {
        List blocks;
        ByLineReaderSource src = new ByLineReaderSource(source);
        try {
            blocks = this.parse((ByLineSource)src);
        }
        catch (Exception e) {
            throw new ParseException(e, src.getName(), src.getLineNumber(), -1);
        }
        sink.head();
        String title = this.getTitle(blocks, (ByLineSource)src);
        if (title != null) {
            sink.title();
            sink.text(title);
            sink.title_();
        }
        sink.head_();
        sink.body();
        Iterator it = blocks.iterator();
        while (it.hasNext()) {
            Block block = (Block)it.next();
            block.traverse(sink);
        }
        sink.body_();
    }

    public final String getTitle(List blocks, ByLineSource source) {
        String name;
        String title = null;
        Iterator it = blocks.iterator();
        while (title == null && it.hasNext()) {
            Block block = (Block)it.next();
            if (!(block instanceof SectionBlock)) continue;
            SectionBlock sectionBlock = (SectionBlock)block;
            title = sectionBlock.getTitle();
        }
        if (title == null && (name = source.getName()) != null && (name = name.trim()).length() != 0) {
            title = name.endsWith(".twiki") ? name.substring(0, name.length() - 6) : name;
        }
        return title;
    }
}

