/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki.parser;

import org.apache.maven.doxia.module.twiki.parser.Block;
import org.apache.maven.doxia.module.twiki.parser.TextBlock;
import org.apache.maven.doxia.sink.Sink;

class LinkBlock
implements Block {
    private final String reference;
    private final Block content;

    LinkBlock(String reference, String text) {
        this(reference, new TextBlock(text));
    }

    LinkBlock(String reference, Block content) {
        if (reference == null || content == null) {
            throw new IllegalArgumentException("arguments can't be null");
        }
        this.reference = reference;
        this.content = content;
    }

    public final void traverse(Sink sink) {
        sink.link(this.reference);
        this.content.traverse(sink);
        sink.link_();
    }

    public final boolean equals(Object obj) {
        boolean ret = false;
        if (obj == this) {
            ret = true;
        } else if (obj instanceof LinkBlock) {
            LinkBlock l = (LinkBlock)obj;
            ret = this.reference.equals(l.reference) && this.content.equals(l.content);
        }
        return ret;
    }

    public final int hashCode() {
        int magic1 = 17;
        int magic2 = 37;
        return 17 + 37 * this.reference.hashCode() + 37 * this.content.hashCode();
    }
}

