/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki.parser;

import java.lang.reflect.Method;
import java.util.Collections;
import org.apache.maven.doxia.module.twiki.parser.AbstractFatherBlock;
import org.apache.maven.doxia.module.twiki.parser.Block;
import org.apache.maven.doxia.sink.Sink;

public class SectionBlock
extends AbstractFatherBlock {
    private final String title;
    private final int level;

    public SectionBlock(String title, int level, Block[] blocks) {
        super(blocks);
        int maxLevel = 5;
        if (title == null) {
            throw new IllegalArgumentException("title cant be null");
        }
        if (level < 1 || level > 5) {
            throw new IllegalArgumentException("invalid level: " + level);
        }
        this.title = title;
        this.level = level;
    }

    final void before(Sink sink) {
        this.sectionStart(sink);
        this.sectionTitle(sink);
        sink.text(this.title);
        this.sectionTitle_(sink);
    }

    final void after(Sink sink) {
        this.sectionEnd(sink);
    }

    private void sectionStart(Sink sink) {
        this.invokeVoidVoid(sink, "section" + this.level);
    }

    private void sectionEnd(Sink sink) {
        this.invokeVoidVoid(sink, "section" + this.level + "_");
    }

    private void invokeVoidVoid(Sink sink, String name) {
        try {
            Method m = sink.getClass().getMethod(name, new Class[0]);
            m.invoke((Object)sink, Collections.EMPTY_LIST.toArray());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invoking sink's " + name + " method: " + e.getMessage());
        }
    }

    public final int getLevel() {
        return this.level;
    }

    public final String getTitle() {
        return this.title;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Section  {title: '");
        sb.append(this.getTitle());
        sb.append("' level: ");
        sb.append(this.getLevel());
        sb.append("}: [");
        for (int i = 0; i < this.getBlocks().length; ++i) {
            Block block = this.getBlocks()[i];
            sb.append(block.toString());
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private void sectionTitle(Sink sink) {
        this.invokeVoidVoid(sink, "sectionTitle" + this.level);
    }

    private void sectionTitle_(Sink sink) {
        this.invokeVoidVoid(sink, "sectionTitle" + this.level + "_");
    }
}

