/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki.parser;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.doxia.module.twiki.parser.Block;
import org.apache.maven.doxia.module.twiki.parser.BlockParser;
import org.apache.maven.doxia.module.twiki.parser.HRuleBlockParser;
import org.apache.maven.doxia.module.twiki.parser.ParagraphBlockParser;
import org.apache.maven.doxia.module.twiki.parser.SectionBlock;
import org.apache.maven.doxia.module.twiki.parser.VerbatimBlockParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.util.ByLineSource;

public class SectionBlockParser
implements BlockParser {
    private static final Pattern HEADER_DA = Pattern.compile("^---([+]+)\\s*(.+)\\s*$");
    private ParagraphBlockParser paraParser;
    private HRuleBlockParser hrulerParser;
    private VerbatimBlockParser verbatimBlockParser;

    public final boolean accept(String line) {
        return HEADER_DA.matcher(line).lookingAt();
    }

    public final Block visit(String line, ByLineSource source) throws ParseException {
        String newLine;
        Matcher m = HEADER_DA.matcher(line);
        if (!m.lookingAt()) {
            throw new IllegalArgumentException("don't know how to handle: " + line);
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        while ((newLine = source.getNextLine()) != null && !this.accept(newLine)) {
            if (this.hrulerParser.accept(newLine)) {
                blocks.add(this.hrulerParser.visit(newLine, source));
                continue;
            }
            if (this.verbatimBlockParser.accept(newLine)) {
                blocks.add(this.verbatimBlockParser.visit(newLine, source));
                continue;
            }
            blocks.add(this.paraParser.visit(newLine, source));
        }
        if (newLine != null) {
            source.ungetLine();
        }
        return new SectionBlock(m.group(2), SectionBlockParser.getLevel(m.group(1)), blocks.toArray(new Block[0]));
    }

    static int getLevel(String s) throws IllegalArgumentException {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            if (s.charAt(i) == '+') continue;
            throw new IllegalArgumentException("the argument must have only '+' characters");
        }
        return s.length();
    }

    public final void setParaParser(ParagraphBlockParser paraParser) {
        if (paraParser == null) {
            throw new IllegalArgumentException("argument can't be null");
        }
        this.paraParser = paraParser;
    }

    public final void setHrulerParser(HRuleBlockParser hrulerParser) {
        if (hrulerParser == null) {
            throw new IllegalArgumentException("argument can't be null");
        }
        this.hrulerParser = hrulerParser;
    }

    public final void setVerbatimBlockParser(VerbatimBlockParser verbatimBlockParser) {
        if (verbatimBlockParser == null) {
            throw new IllegalArgumentException("argument can't be null");
        }
        this.verbatimBlockParser = verbatimBlockParser;
    }
}

