/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki.parser;

import org.apache.maven.doxia.module.twiki.parser.Block;
import org.apache.maven.doxia.sink.Sink;

class TextBlock
implements Block {
    private final String text;

    TextBlock(String text) {
        if (text == null) {
            throw new IllegalArgumentException("argument can't be null");
        }
        this.text = text;
    }

    public final void traverse(Sink sink) {
        sink.text(this.text);
    }

    public final String toString() {
        return this.getClass().getName() + ": [" + this.text.replaceAll("\n", "\\n") + "]";
    }

    final String getText() {
        return this.text;
    }

    public final boolean equals(Object obj) {
        boolean ret = false;
        if (obj == this) {
            ret = true;
        } else if (obj instanceof TextBlock) {
            TextBlock textBlock = (TextBlock)obj;
            ret = this.text.equals(textBlock.text);
        }
        return ret;
    }

    public final int hashCode() {
        return this.text.hashCode();
    }
}

