/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.buildcache.xml.CacheConfig;
import org.apache.maven.buildcache.xml.build.Build;
import org.apache.maven.buildcache.xml.build.CompletedExecution;
import org.apache.maven.buildcache.xml.build.DigestItem;
import org.apache.maven.buildcache.xml.build.ProjectsInputInfo;
import org.apache.maven.buildcache.xml.build.PropertyValue;
import org.apache.maven.buildcache.xml.diff.Diff;
import org.apache.maven.buildcache.xml.diff.Mismatch;

public class CacheDiff {
    private final CacheConfig config;
    private final Build current;
    private final Build baseline;
    private final LinkedList<Mismatch> report;

    public CacheDiff(Build current, Build baseline, CacheConfig config) {
        this.current = current;
        this.baseline = baseline;
        this.config = config;
        this.report = new LinkedList();
    }

    public Diff compare() {
        if (!StringUtils.equals((CharSequence)this.current.getHashFunction(), (CharSequence)this.baseline.getHashFunction())) {
            this.addNewMismatch("hashFunction", this.current.getHashFunction(), this.baseline.getHashFunction(), "Different algorithms render caches not comparable and cached could not be reused", "Ensure the same algorithm as remote");
        }
        this.compareEffectivePoms(this.current.getProjectsInputInfo(), this.baseline.getProjectsInputInfo());
        this.compareExecutions(this.current.getExecutions(), this.baseline.getExecutions());
        this.compareFiles(this.current.getProjectsInputInfo(), this.baseline.getProjectsInputInfo());
        this.compareDependencies(this.current.getProjectsInputInfo(), this.baseline.getProjectsInputInfo());
        Diff buildDiffType = new Diff();
        buildDiffType.getMismatches().addAll(this.report);
        return buildDiffType;
    }

    private void compareEffectivePoms(ProjectsInputInfo current, ProjectsInputInfo baseline) {
        Optional<DigestItem> baseLinePom;
        String baselinePomHash;
        Optional<DigestItem> currentPom = CacheDiff.findPom(current);
        String currentPomHash = currentPom.map(DigestItem::getHash).orElse(null);
        if (!StringUtils.equals((CharSequence)currentPomHash, (CharSequence)(baselinePomHash = (String)(baseLinePom = CacheDiff.findPom(baseline)).map(DigestItem::getHash).orElse(null)))) {
            this.addNewMismatch("effectivePom", currentPomHash, baselinePomHash, "Difference in effective pom suggests effectively different builds which cannot be reused", "Compare raw content of effective poms and eliminate differences. See How-To for common techniques");
        }
    }

    public static Optional<DigestItem> findPom(ProjectsInputInfo projectInputs) {
        for (DigestItem digestItemType : projectInputs.getItems()) {
            if (!"pom".equals(digestItemType.getType())) continue;
            return Optional.of(digestItemType);
        }
        return Optional.empty();
    }

    private void compareFiles(ProjectsInputInfo current, ProjectsInputInfo baseline) {
        Map<String, DigestItem> currentFiles = current.getItems().stream().filter(item -> "file".equals(item.getType())).collect(Collectors.toMap(DigestItem::getValue, item -> item));
        Map<String, DigestItem> baselineFiles = baseline.getItems().stream().filter(item -> "file".equals(item.getType())).collect(Collectors.toMap(DigestItem::getValue, item -> item));
        if (!Objects.equals(currentFiles.keySet(), baselineFiles.keySet())) {
            Set<String> currentVsBaseline = CacheDiff.diff(currentFiles.keySet(), baselineFiles.keySet());
            Set<String> baselineVsCurrent = CacheDiff.diff(baselineFiles.keySet(), currentFiles.keySet());
            this.addNewMismatch("source files", "Remote and local cache contain different sets of input files. Added files: " + currentVsBaseline + ". Removed files: " + baselineVsCurrent, "To match remote and local caches should have identical file sets. Unnecessary and transient files must be filtered out to make file sets match - see configuration guide");
            return;
        }
        for (Map.Entry<String, DigestItem> entry : currentFiles.entrySet()) {
            String filePath = entry.getKey();
            DigestItem currentFile = entry.getValue();
            DigestItem baselineFile = baselineFiles.get(filePath);
            if (StringUtils.equals((CharSequence)currentFile.getHash(), (CharSequence)baselineFile.getHash())) continue;
            String reason = "File content is different.";
            if (currentFile.getEol() != null && baselineFile.getEol() != null && !StringUtils.equals((CharSequence)baselineFile.getEol(), (CharSequence)currentFile.getEol())) {
                reason = reason + " Different line endings detected (text files relevant). Remote: " + baselineFile.getEol() + ", local: " + currentFile.getEol() + ".";
            }
            if (currentFile.getCharset() != null && baselineFile.getCharset() != null && !StringUtils.equals((CharSequence)baselineFile.getCharset(), (CharSequence)currentFile.getCharset())) {
                reason = reason + " Different charset detected (text files relevant). Remote: " + baselineFile.getEol() + ", local: " + currentFile.getEol() + ".";
            }
            this.addNewMismatch(filePath, currentFile.getHash(), baselineFile.getHash(), reason, "Different content manifests different build outcome. Ensure that difference is not caused by environment specifics, like line separators");
        }
    }

    private void compareDependencies(ProjectsInputInfo current, ProjectsInputInfo baseline) {
        Map<String, DigestItem> currentDependencies = current.getItems().stream().filter(item -> "dependency".equals(item.getType())).collect(Collectors.toMap(DigestItem::getValue, item -> item));
        Map<String, DigestItem> baselineDependencies = baseline.getItems().stream().filter(item -> "dependency".equals(item.getType())).collect(Collectors.toMap(DigestItem::getValue, item -> item));
        if (!Objects.equals(currentDependencies.keySet(), baselineDependencies.keySet())) {
            Set<String> currentVsBaseline = CacheDiff.diff(currentDependencies.keySet(), baselineDependencies.keySet());
            Set<String> baselineVsCurrent = CacheDiff.diff(baselineDependencies.keySet(), currentDependencies.keySet());
            this.addNewMismatch("dependencies files", "Remote and local builds contain different sets of dependencies and cannot be matched. Added dependencies: " + currentVsBaseline + ". Removed dependencies: " + baselineVsCurrent, "Remote and local builds should have identical dependencies. The difference manifests changes in downstream dependencies or introduced snapshots.");
            return;
        }
        for (Map.Entry<String, DigestItem> entry : currentDependencies.entrySet()) {
            String dependencyKey = entry.getKey();
            DigestItem currentDependency = entry.getValue();
            DigestItem baselineDependency = baselineDependencies.get(dependencyKey);
            if (StringUtils.equals((CharSequence)currentDependency.getHash(), (CharSequence)baselineDependency.getHash())) continue;
            this.addNewMismatch(dependencyKey, currentDependency.getHash(), baselineDependency.getHash(), "Downstream project or snapshot changed", "Find downstream project and investigate difference in the downstream project. Enable fail fast mode and single threaded execution to simplify debug.");
        }
    }

    private void compareExecutions(List<CompletedExecution> current, List<CompletedExecution> baseline) {
        HashMap<String, CompletedExecution> baselineExecutionsByKey = new HashMap<String, CompletedExecution>();
        for (CompletedExecution completedExecutionType : baseline) {
            baselineExecutionsByKey.put(completedExecutionType.getExecutionKey(), completedExecutionType);
        }
        HashMap<String, CompletedExecution> currentExecutionsByKey = new HashMap<String, CompletedExecution>();
        for (CompletedExecution e1 : current) {
            currentExecutionsByKey.put(e1.getExecutionKey(), e1);
        }
        for (CompletedExecution baselineExecution : baseline) {
            if (currentExecutionsByKey.containsKey(baselineExecution.getExecutionKey())) continue;
            this.addNewMismatch(baselineExecution.getExecutionKey(), "Baseline build contains excessive plugin " + baselineExecution.getExecutionKey(), "Different set of plugins produces different build results. Exclude non-critical plugins or make sure plugin sets match");
        }
        for (CompletedExecution currentExecution : current) {
            if (!baselineExecutionsByKey.containsKey(currentExecution.getExecutionKey())) {
                this.addNewMismatch(currentExecution.getExecutionKey(), "Cached build doesn't contain plugin " + currentExecution.getExecutionKey(), "Different set of plugins produces different build results. Filter out non-critical plugins or make sure remote cache always run full build with all plugins");
                continue;
            }
            CompletedExecution baselineExecution = (CompletedExecution)baselineExecutionsByKey.get(currentExecution.getExecutionKey());
            this.comparePlugins(currentExecution, baselineExecution);
        }
    }

    private void comparePlugins(CompletedExecution current, CompletedExecution baseline) {
        ArrayList<PropertyValue> trackedProperties = new ArrayList<PropertyValue>();
        for (PropertyValue propertyValueType : current.getProperties()) {
            if (!propertyValueType.isTracked().booleanValue()) continue;
            trackedProperties.add(propertyValueType);
        }
        if (trackedProperties.isEmpty()) {
            return;
        }
        HashMap<String, PropertyValue> baselinePropertiesByName = new HashMap<String, PropertyValue>();
        for (PropertyValue propertyValueType : baseline.getProperties()) {
            baselinePropertiesByName.put(propertyValueType.getName(), propertyValueType);
        }
        for (PropertyValue p : trackedProperties) {
            PropertyValue baselineValue = (PropertyValue)baselinePropertiesByName.get(p.getName());
            if (baselineValue != null && StringUtils.equals((CharSequence)baselineValue.getValue(), (CharSequence)p.getValue())) continue;
            this.addNewMismatch(p.getName(), p.getValue(), baselineValue == null ? null : baselineValue.getValue(), "Plugin: " + current.getExecutionKey() + " has mismatch in tracked property and cannot be reused", "Align properties between remote and local build or remove property from tracked list if mismatch could be tolerated. In some cases it is possible to add skip value to ignore lax mismatch");
        }
    }

    private void addNewMismatch(String item, String current, String baseline, String reason, String resolution) {
        Mismatch mismatch = new Mismatch();
        mismatch.setItem(item);
        mismatch.setCurrent(current);
        mismatch.setBaseline(baseline);
        mismatch.setReason(reason);
        mismatch.setResolution(resolution);
        this.report.add(mismatch);
    }

    private void addNewMismatch(String property, String reason, String resolution) {
        Mismatch mismatchType = new Mismatch();
        mismatchType.setItem(property);
        mismatchType.setReason(reason);
        mismatchType.setResolution(resolution);
        this.report.add(mismatchType);
    }

    private static <T> Set<T> diff(Set<T> a, Set<T> b) {
        return a.stream().filter(v -> !b.contains(v)).collect(Collectors.toSet());
    }
}

