/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.hash;

import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import net.openhft.hashing.LongHashFunction;
import org.apache.maven.buildcache.hash.Hash;
import org.apache.maven.buildcache.hash.HashAlgorithm;
import org.apache.maven.buildcache.hash.HashChecksum;
import org.apache.maven.buildcache.hash.SHA;
import org.apache.maven.buildcache.hash.Zah;

public enum HashFactory {
    SHA1(new SHA("SHA-1")),
    SHA256(new SHA("SHA-256")),
    SHA384(new SHA("SHA-384")),
    SHA512(new SHA("SHA-512")),
    XX(new Zah("XX", LongHashFunction.xx(), Zah.MemoryPolicy.Standard)),
    XXMM(new Zah("XXMM", LongHashFunction.xx(), Zah.MemoryPolicy.MemoryMappedBuffers)),
    METRO(new Zah("METRO", LongHashFunction.metro(), Zah.MemoryPolicy.Standard)),
    METRO_MM(new Zah("METRO+MM", LongHashFunction.metro(), Zah.MemoryPolicy.MemoryMappedBuffers));

    private static final Map<String, HashFactory> LOOKUP;
    private final Hash.Factory factory;

    public static HashFactory of(String algorithm) throws NoSuchAlgorithmException {
        HashFactory factory = LOOKUP.get(algorithm);
        if (factory == null) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        return factory;
    }

    private HashFactory(Hash.Factory factory) {
        this.factory = factory;
    }

    public String getAlgorithm() {
        return this.factory.getAlgorithm();
    }

    public HashAlgorithm createAlgorithm() {
        return new HashAlgorithm(this.factory.algorithm());
    }

    public HashChecksum createChecksum(int count) {
        return new HashChecksum(this.factory.algorithm(), this.factory.checksum(count));
    }

    static {
        LOOKUP = new HashMap<String, HashFactory>();
        for (HashFactory factory : HashFactory.values()) {
            LOOKUP.put(factory.getAlgorithm(), factory);
        }
    }
}

