/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.hash;

import java.nio.charset.StandardCharsets;

public class HexUtils {
    private static final byte[] ENC_ARRAY;
    private static final byte[] DEC_ARRAY;

    public static String encode(byte[] hash) {
        byte[] hexChars = new byte[hash.length * 2];
        for (int j = 0; j < hash.length; ++j) {
            int v = hash[j] & 0xFF;
            hexChars[j * 2] = ENC_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = ENC_ARRAY[v & 0xF];
        }
        return new String(hexChars, StandardCharsets.US_ASCII);
    }

    public static byte[] decode(String hex) {
        int size = hex.length();
        if (size % 2 != 0) {
            throw new IllegalArgumentException("String length should be even");
        }
        byte[] bytes = new byte[size / 2];
        int idx = 0;
        for (int i = 0; i < size; i += 2) {
            bytes[idx++] = (byte)(DEC_ARRAY[hex.charAt(i)] << 4 | DEC_ARRAY[hex.charAt(i + 1)]);
        }
        return bytes;
    }

    public static byte[] toByteArray(long value) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return result;
    }

    static {
        int i;
        ENC_ARRAY = new byte[16];
        DEC_ARRAY = new byte[256];
        for (i = 0; i < 10; i = (int)((byte)(i + 1))) {
            HexUtils.ENC_ARRAY[i] = (byte)(48 + i);
            HexUtils.DEC_ARRAY[48 + i] = i;
        }
        for (i = 10; i < 16; i = (int)((byte)(i + 1))) {
            HexUtils.ENC_ARRAY[i] = (byte)(97 + i - 10);
            HexUtils.DEC_ARRAY[97 + i - 10] = i;
            HexUtils.DEC_ARRAY[65 + i - 10] = i;
        }
    }
}

