/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.SessionScoped;
import org.apache.maven.buildcache.CacheUtils;
import org.apache.maven.buildcache.MultiModuleSupport;
import org.apache.maven.buildcache.NormalizedModelProvider;
import org.apache.maven.buildcache.Xpp3DomUtils;
import org.apache.maven.buildcache.xml.CacheConfig;
import org.apache.maven.lifecycle.internal.builder.BuilderCommon;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SessionScoped
@Named
public class DefaultNormalizedModelProvider
implements NormalizedModelProvider {
    private static final String NORMALIZED_VERSION = "cache-extension-version";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultNormalizedModelProvider.class);
    private final CacheConfig cacheConfig;
    private final MultiModuleSupport multiModuleSupport;
    private final ConcurrentMap<String, Model> modelCache = new ConcurrentHashMap<String, Model>();

    @Inject
    public DefaultNormalizedModelProvider(MultiModuleSupport multiModuleSupport, CacheConfig cacheConfig) {
        this.multiModuleSupport = multiModuleSupport;
        this.cacheConfig = cacheConfig;
    }

    @Override
    public Model normalizedModel(MavenProject project) {
        MavenProject validatedProject = Objects.requireNonNull(project, "project");
        return this.modelCache.computeIfAbsent(BuilderCommon.getKey((MavenProject)validatedProject), k -> this.normalizedModelInner(validatedProject));
    }

    private Model normalizedModelInner(MavenProject project) {
        MavenProject projectToNormalize = this.multiModuleSupport.tryToResolveProject(project.getGroupId(), project.getArtifactId(), project.getVersion()).orElse(project);
        Model prototype = projectToNormalize.getModel();
        Model resultModel = new Model();
        resultModel.setGroupId(prototype.getGroupId());
        resultModel.setArtifactId(prototype.getArtifactId());
        resultModel.setVersion(NORMALIZED_VERSION);
        resultModel.setModules(prototype.getModules());
        resultModel.setDependencies(this.normalizeDependencies(prototype.getDependencies()));
        Build protoBuild = prototype.getBuild();
        if (protoBuild == null) {
            return resultModel;
        }
        Build build = new Build();
        List plugins = prototype.getBuild().getPlugins();
        build.setPlugins(this.normalizePlugins(plugins));
        resultModel.setBuild(build);
        return resultModel;
    }

    private List<Dependency> normalizeDependencies(Collection<Dependency> source) {
        return source.stream().map(it -> {
            if (!this.multiModuleSupport.isPartOfMultiModule(it.getGroupId(), it.getArtifactId(), it.getVersion())) {
                return it;
            }
            Dependency cloned = it.clone();
            cloned.setVersion(NORMALIZED_VERSION);
            return cloned;
        }).sorted(DefaultNormalizedModelProvider::compareDependencies).collect(Collectors.toList());
    }

    private List<Plugin> normalizePlugins(List<Plugin> plugins) {
        if (plugins.isEmpty()) {
            return plugins;
        }
        return plugins.stream().map(plugin -> {
            Plugin copy = plugin.clone();
            List<String> excludeProperties = this.cacheConfig.getEffectivePomExcludeProperties(copy);
            if (!excludeProperties.isEmpty()) {
                CacheUtils.debugPrintCollection(LOGGER, excludeProperties, String.format("List of excluded properties for %s", copy.getArtifactId()), "Excluded property");
                this.removeBlacklistedAttributes(copy.getConfiguration(), excludeProperties);
                for (PluginExecution execution : copy.getExecutions()) {
                    this.removeBlacklistedAttributes(execution.getConfiguration(), excludeProperties);
                }
            }
            copy.setDependencies(this.normalizeDependencies(copy.getDependencies().stream().sorted(DefaultNormalizedModelProvider::compareDependencies).collect(Collectors.toList())));
            if (this.multiModuleSupport.isPartOfMultiModule(copy.getGroupId(), copy.getArtifactId(), copy.getVersion())) {
                copy.setVersion(NORMALIZED_VERSION);
            }
            return copy;
        }).collect(Collectors.toList());
    }

    private void removeBlacklistedAttributes(Object node, List<String> excludeProperties) {
        if (node == null) {
            return;
        }
        Object[] children = Xpp3DomUtils.getChildren(node);
        int indexToRemove = 0;
        for (Object child : children) {
            if (excludeProperties.contains(Xpp3DomUtils.getName(child))) {
                Xpp3DomUtils.removeChild(node, indexToRemove);
                continue;
            }
            ++indexToRemove;
            this.removeBlacklistedAttributes(child, excludeProperties);
        }
    }

    private static int compareDependencies(Dependency d1, Dependency d2) {
        return d1.getArtifactId().compareTo(d2.getArtifactId());
    }
}

