/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.checksum;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.buildcache.hash.HashChecksum;
import org.apache.maven.buildcache.xml.build.DigestItem;
import org.mozilla.universalchardet.UniversalDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigestUtils.class);
    private static final ThreadLocal<UniversalDetector> ENCODING_DETECTOR = ThreadLocal.withInitial(() -> new UniversalDetector(null));

    public static DigestItem pom(HashChecksum checksum, String effectivePom) {
        return DigestUtils.item("pom", effectivePom, checksum.update(effectivePom.getBytes(StandardCharsets.UTF_8)));
    }

    public static DigestItem file(HashChecksum checksum, Path basedir, Path file) throws IOException {
        byte[] content = Files.readAllBytes(file);
        String normalized = DigestUtils.normalize(basedir, file);
        DigestItem item = DigestUtils.item("file", normalized, checksum.update(content));
        try {
            DigestUtils.populateContentDetails(file, content, item);
        }
        catch (IOException ignore) {
            LOGGER.debug("Failed to compute digest for file {}", (Object)normalized, (Object)ignore);
        }
        return item;
    }

    private static void populateContentDetails(Path file, byte[] content, DigestItem item) throws IOException {
        String contentType = Files.probeContentType(file);
        if (contentType != null) {
            item.setContent(contentType);
        }
        boolean binary = DigestUtils.isBinary(contentType);
        item.setIsText(DigestUtils.isText(contentType) ? "yes" : (binary ? "no" : "unknown"));
        if (!binary) {
            UniversalDetector detector = ENCODING_DETECTOR.get();
            detector.reset();
            detector.handleData(content, 0, Math.min(content.length, 16384));
            detector.dataEnd();
            String detectedCharset = detector.getDetectedCharset();
            Charset charset = StandardCharsets.UTF_8;
            if (detectedCharset != null) {
                item.setCharset(detectedCharset);
                charset = Charset.forName(detectedCharset);
            }
            CharBuffer charBuffer = charset.decode(ByteBuffer.wrap(content));
            String lineSeparator = DigestUtils.detectLineSeparator(charBuffer);
            item.setEol(StringUtils.defaultString((String)lineSeparator, (String)"unknown"));
        }
    }

    private static boolean isText(String contentType) {
        return StringUtils.startsWith((CharSequence)contentType, (CharSequence)"text/") || StringUtils.containsAny((CharSequence)contentType, (CharSequence[])new CharSequence[]{"+json", "+xml"}) || StringUtils.equalsAny((CharSequence)contentType, (CharSequence[])new CharSequence[]{"application/json", "application/rtf", "application/x-sh", "application/xml", "application/javascript", "application/sql"});
    }

    private static boolean isBinary(String contentType) {
        return StringUtils.startsWithAny((CharSequence)contentType, (CharSequence[])new CharSequence[]{"image/", "audio/", "video/", "font/"}) || StringUtils.containsAny((CharSequence)contentType, (CharSequence[])new CharSequence[]{"+zip", "+gzip"}) || StringUtils.equalsAny((CharSequence)contentType, (CharSequence[])new CharSequence[]{"application/octet-stream", "application/java-archive", "application/x-bzip", "application/x-bzip2", "application/zip", "application/gzip", "application/x-tar", "application/msword", "application/vnd.ms-excel", "application/vnd.ms-powerpoint", "application/pdf"});
    }

    public static DigestItem dependency(HashChecksum checksum, String key, String hash) {
        return DigestUtils.item("dependency", key, checksum.update(hash));
    }

    private static String normalize(Path basedirPath, Path file) {
        return FilenameUtils.separatorsToUnix((String)DigestUtils.relativize(basedirPath, file).toString());
    }

    private static Path relativize(Path basedirPath, Path file) {
        try {
            return basedirPath.relativize(file);
        }
        catch (Exception ignore) {
            return file;
        }
    }

    private static DigestItem item(String type, String reference, String hash) {
        DigestItem item = new DigestItem();
        item.setType(type);
        item.setValue(reference);
        item.setHash(hash);
        return item;
    }

    private DigestUtils() {
    }

    public static String detectLineSeparator(CharSequence text) {
        int index = StringUtils.indexOfAny((CharSequence)text, (String)"\n\r");
        if (index == -1 || index >= text.length()) {
            return null;
        }
        char ch = text.charAt(index);
        if (ch == '\r') {
            return index + 1 < text.length() && text.charAt(index + 1) == '\n' ? "CRLF" : "CR";
        }
        return ch == '\n' ? "LF" : null;
    }
}

