/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.xml;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.maven.buildcache.CacheUtils;
import org.apache.maven.buildcache.hash.HashAlgorithm;
import org.apache.maven.buildcache.xml.CacheSource;
import org.apache.maven.buildcache.xml.DtoUtils;
import org.apache.maven.buildcache.xml.build.Artifact;
import org.apache.maven.buildcache.xml.build.CompletedExecution;
import org.apache.maven.buildcache.xml.build.DigestItem;
import org.apache.maven.buildcache.xml.build.ProjectsInputInfo;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecution;

public class Build {
    final org.apache.maven.buildcache.xml.build.Build dto;
    CacheSource source;
    volatile Map<String, CompletedExecution> execMap;

    public Build(List<String> goals, Artifact artifact, List<Artifact> attachedArtifacts, ProjectsInputInfo projectsInputInfo, List<CompletedExecution> completedExecutions, String hashAlgorithm) {
        this.dto = new org.apache.maven.buildcache.xml.build.Build();
        this.dto.setCacheImplementationVersion("v1.1");
        this.dto.setBuildTime(new Date());
        try {
            this.dto.setBuildServer(InetAddress.getLocalHost().getCanonicalHostName());
        }
        catch (UnknownHostException ignore) {
            this.dto.setBuildServer("unknown");
        }
        this.dto.setHashFunction(hashAlgorithm);
        this.dto.setArtifact(artifact);
        this.dto.setGoals(goals);
        this.dto.setAttachedArtifacts(attachedArtifacts);
        this.dto.setExecutions(completedExecutions);
        this.dto.setProjectsInputInfo(projectsInputInfo);
        this.source = CacheSource.BUILD;
    }

    public CacheSource getSource() {
        return this.source;
    }

    public Build(org.apache.maven.buildcache.xml.build.Build dto, CacheSource source) {
        this.dto = dto;
        this.source = source;
    }

    public static List<Artifact> createAttachedArtifacts(List<org.apache.maven.artifact.Artifact> artifacts, HashAlgorithm algorithm) throws IOException {
        ArrayList<Artifact> attachedArtifacts = new ArrayList<Artifact>();
        for (org.apache.maven.artifact.Artifact artifact : artifacts) {
            Artifact dto = DtoUtils.createDto(artifact);
            if (artifact.getFile() != null) {
                dto.setFileHash(algorithm.hash(artifact.getFile().toPath()));
            }
            attachedArtifacts.add(dto);
        }
        return attachedArtifacts;
    }

    public List<MojoExecution> getMissingExecutions(List<MojoExecution> mojos) {
        return mojos.stream().filter(mojo -> !this.hasCompletedExecution(CacheUtils.mojoExecutionKey(mojo))).collect(Collectors.toList());
    }

    private boolean hasCompletedExecution(String mojoExecutionKey) {
        return this.getExecutionMap().containsKey(mojoExecutionKey);
    }

    public String toString() {
        return "Build{dto=" + this.dto + '}';
    }

    public CompletedExecution findMojoExecutionInfo(MojoExecution mojoExecution) {
        return this.getExecutionMap().get(CacheUtils.mojoExecutionKey(mojoExecution));
    }

    public String getCacheImplementationVersion() {
        return this.dto.getCacheImplementationVersion();
    }

    public Artifact getArtifact() {
        return this.dto.getArtifact();
    }

    public List<Artifact> getAttachedArtifacts() {
        if (this.dto.getAttachedArtifacts() != null) {
            return this.dto.getAttachedArtifacts();
        }
        return Collections.emptyList();
    }

    public org.apache.maven.buildcache.xml.build.Build getDto() {
        return this.dto;
    }

    public String getHighestCompletedGoal() {
        return CacheUtils.getLast(this.dto.getGoals());
    }

    public DigestItem findArtifact(Dependency dependency) {
        if (CacheUtils.isPom(dependency)) {
            throw new IllegalArgumentException("Pom dependencies should not be treated as artifacts: " + dependency);
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(this.getAttachedArtifacts());
        artifacts.add(this.getArtifact());
        for (Artifact artifact : artifacts) {
            if (!this.isEquals(dependency, artifact)) continue;
            return DtoUtils.createdDigestedByProjectChecksum(artifact, this.dto.getProjectsInputInfo().getChecksum());
        }
        return null;
    }

    private boolean isEquals(Dependency dependency, Artifact artifact) {
        return Objects.equals(dependency.getGroupId(), artifact.getGroupId()) && Objects.equals(dependency.getArtifactId(), artifact.getArtifactId()) && Objects.equals(dependency.getType(), artifact.getType()) && Objects.equals(dependency.getClassifier(), artifact.getClassifier());
    }

    private Map<String, CompletedExecution> getExecutionMap() {
        if (this.execMap != null) {
            return this.execMap;
        }
        List<CompletedExecution> executionsList = this.dto.getExecutions();
        if (executionsList == null || executionsList.isEmpty()) {
            this.execMap = Collections.emptyMap();
            return this.execMap;
        }
        this.execMap = executionsList.stream().collect(Collectors.toMap(CompletedExecution::getExecutionKey, v -> v, (oldV, newV) -> oldV));
        return this.execMap;
    }
}

