/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.generator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.w3c.tidy.Tidy;

public final class GeneratorUtils {
    private GeneratorUtils() {
    }

    public static void writeDependencies(XMLWriter w, PluginDescriptor pluginDescriptor) {
        w.startElement("dependencies");
        List deps = pluginDescriptor.getDependencies();
        for (ComponentDependency dep : deps) {
            w.startElement("dependency");
            GeneratorUtils.element(w, "groupId", dep.getGroupId());
            GeneratorUtils.element(w, "artifactId", dep.getArtifactId());
            GeneratorUtils.element(w, "type", dep.getType());
            GeneratorUtils.element(w, "version", dep.getVersion());
            w.endElement();
        }
        w.endElement();
    }

    public static void element(XMLWriter w, String name, String value) {
        w.startElement(name);
        if (value == null) {
            value = "";
        }
        w.writeText(value);
        w.endElement();
    }

    public static void element(XMLWriter w, String name, String value, boolean asText) {
        GeneratorUtils.element(w, name, asText ? GeneratorUtils.toText(value) : value);
    }

    public static List<ComponentDependency> toComponentDependencies(List<Dependency> dependencies) {
        LinkedList<ComponentDependency> componentDeps = new LinkedList<ComponentDependency>();
        for (Dependency dependency : dependencies) {
            ComponentDependency cd = new ComponentDependency();
            cd.setArtifactId(dependency.getArtifactId());
            cd.setGroupId(dependency.getGroupId());
            cd.setVersion(dependency.getVersion());
            cd.setType(dependency.getType());
            componentDeps.add(cd);
        }
        return componentDeps;
    }

    private static String quoteReplacement(String s) {
        if (s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static String decodeJavadocTags(String description) {
        if (StringUtils.isEmpty((String)description)) {
            return "";
        }
        StringBuffer decoded = new StringBuffer(description.length() + 1024);
        Matcher matcher = Pattern.compile("\\{@(\\w+)\\s*([^\\}]*)\\}").matcher(description);
        while (matcher.find()) {
            String tag = matcher.group(1);
            String text = matcher.group(2);
            text = StringUtils.replace((String)text, (String)"&", (String)"&amp;");
            text = StringUtils.replace((String)text, (String)"<", (String)"&lt;");
            text = StringUtils.replace((String)text, (String)">", (String)"&gt;");
            if ("code".equals(tag)) {
                text = "<code>" + text + "</code>";
            } else if ("link".equals(tag) || "linkplain".equals(tag) || "value".equals(tag)) {
                String pattern = "(([^#\\.\\s]+\\.)*([^#\\.\\s]+))?(#([^\\(\\s]*)(\\([^\\)]*\\))?\\s*(\\S.*)?)?";
                int label = 7;
                int clazz = 3;
                int member = 5;
                int args = 6;
                Matcher link = Pattern.compile(pattern).matcher(text);
                if (link.matches() && StringUtils.isEmpty((String)(text = link.group(7)))) {
                    text = link.group(3);
                    if (StringUtils.isEmpty((String)text)) {
                        text = "";
                    }
                    if (StringUtils.isNotEmpty((String)link.group(5))) {
                        if (StringUtils.isNotEmpty((String)text)) {
                            text = text + '.';
                        }
                        text = text + link.group(5);
                        if (StringUtils.isNotEmpty((String)link.group(6))) {
                            text = text + "()";
                        }
                    }
                }
                if (!"linkplain".equals(tag)) {
                    text = "<code>" + text + "</code>";
                }
            }
            matcher.appendReplacement(decoded, text != null ? GeneratorUtils.quoteReplacement(text) : "");
        }
        matcher.appendTail(decoded);
        return decoded.toString();
    }

    public static String makeHtmlValid(String description) {
        if (StringUtils.isEmpty((String)description)) {
            return "";
        }
        String commentCleaned = GeneratorUtils.decodeJavadocTags(description);
        Tidy tidy = new Tidy();
        tidy.setDocType("loose");
        tidy.setXHTML(true);
        tidy.setXmlOut(true);
        tidy.setInputEncoding("UTF-8");
        tidy.setOutputEncoding("UTF-8");
        tidy.setMakeClean(true);
        tidy.setNumEntities(true);
        tidy.setQuoteNbsp(false);
        tidy.setQuiet(true);
        tidy.setShowWarnings(false);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(commentCleaned.length() + 256);
            tidy.parse((InputStream)new ByteArrayInputStream(commentCleaned.getBytes("UTF-8")), (OutputStream)out);
            commentCleaned = out.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if (StringUtils.isEmpty((String)commentCleaned)) {
            return "";
        }
        String ls = System.getProperty("line.separator");
        int startPos = commentCleaned.indexOf("<body>" + ls) + 6 + ls.length();
        int endPos = commentCleaned.indexOf(ls + "</body>");
        commentCleaned = commentCleaned.substring(startPos, endPos);
        return commentCleaned;
    }

    public static String toText(String html) {
        if (StringUtils.isEmpty((String)html)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        ParserDelegator parser = new ParserDelegator();
        MojoParserCallback htmlCallback = new MojoParserCallback(sb);
        try {
            ((HTMLEditorKit.Parser)parser).parse(new StringReader(GeneratorUtils.makeHtmlValid(html)), htmlCallback, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sb.toString().replace('\"', '\'');
    }

    public static String discoverPackageName(PluginDescriptor pluginDescriptor) {
        HashMap<String, Integer> packageNames = new HashMap<String, Integer>();
        List mojoDescriptors = pluginDescriptor.getMojos();
        if (mojoDescriptors == null) {
            return "";
        }
        for (MojoDescriptor descriptor : mojoDescriptors) {
            String impl = descriptor.getImplementation();
            if (StringUtils.equals((String)descriptor.getGoal(), (String)"help") && StringUtils.equals((String)"HelpMojo", (String)impl)) continue;
            if (impl.lastIndexOf(46) != -1) {
                String name = impl.substring(0, impl.lastIndexOf(46));
                if (packageNames.get(name) != null) {
                    int next = (Integer)packageNames.get(name) + 1;
                    packageNames.put(name, next);
                    continue;
                }
                packageNames.put(name, 1);
                continue;
            }
            packageNames.put("", 1);
        }
        String packageName = "";
        int max = 0;
        for (Map.Entry entry : packageNames.entrySet()) {
            int value = (Integer)entry.getValue();
            if (value <= max) continue;
            max = value;
            packageName = (String)entry.getKey();
        }
        return packageName;
    }

    public static boolean isMavenReport(String impl, MavenProject project) throws IllegalArgumentException {
        if (impl == null) {
            throw new IllegalArgumentException("mojo implementation should be declared");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (project != null) {
            List classPathStrings;
            try {
                classPathStrings = project.getCompileClasspathElements();
                if (project.getExecutionProject() != null) {
                    classPathStrings.addAll(project.getExecutionProject().getCompileClasspathElements());
                }
            }
            catch (DependencyResolutionRequiredException e) {
                throw new IllegalArgumentException(e);
            }
            ArrayList<URL> urls = new ArrayList<URL>(classPathStrings.size());
            for (String classPathString : classPathStrings) {
                try {
                    urls.add(new File(classPathString).toURL());
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), classLoader);
        }
        try {
            Class<?> clazz = Class.forName(impl, false, classLoader);
            return MavenReport.class.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static class MojoParserCallback
    extends HTMLEditorKit.ParserCallback {
        private boolean body;
        private int preformatted;
        private int depth;
        private Stack<Counter> numbering = new Stack();
        private boolean pendingNewline;
        private boolean simpleTag;
        private final StringBuilder sb;

        public MojoParserCallback(StringBuilder sb) {
            this.sb = sb;
        }

        @Override
        public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            this.simpleTag = true;
            if (this.body && HTML.Tag.BR.equals(t)) {
                this.newline(false);
            }
        }

        @Override
        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            this.simpleTag = false;
            if (this.body && (t.breaksFlow() || t.isBlock())) {
                this.newline(true);
            }
            if (HTML.Tag.OL.equals(t)) {
                this.numbering.push(new Counter());
            } else if (HTML.Tag.UL.equals(t)) {
                this.numbering.push(null);
            } else if (HTML.Tag.LI.equals(t)) {
                Counter counter = this.numbering.peek();
                if (counter == null) {
                    this.text("-\t");
                } else {
                    this.text(++counter.value + ".\t");
                }
                ++this.depth;
            } else if (HTML.Tag.DD.equals(t)) {
                ++this.depth;
            } else if (t.isPreformatted()) {
                ++this.preformatted;
            } else if (HTML.Tag.BODY.equals(t)) {
                this.body = true;
            }
        }

        @Override
        public void handleEndTag(HTML.Tag t, int pos) {
            if (HTML.Tag.OL.equals(t) || HTML.Tag.UL.equals(t)) {
                this.numbering.pop();
            } else if (HTML.Tag.LI.equals(t) || HTML.Tag.DD.equals(t)) {
                --this.depth;
            } else if (t.isPreformatted()) {
                --this.preformatted;
            } else if (HTML.Tag.BODY.equals(t)) {
                this.body = false;
            }
            if (this.body && (t.breaksFlow() || t.isBlock()) && !HTML.Tag.LI.equals(t)) {
                if ((HTML.Tag.P.equals(t) || HTML.Tag.PRE.equals(t) || HTML.Tag.OL.equals(t) || HTML.Tag.UL.equals(t) || HTML.Tag.DL.equals(t)) && this.numbering.isEmpty()) {
                    this.pendingNewline = false;
                    this.newline(this.pendingNewline);
                } else {
                    this.newline(true);
                }
            }
        }

        @Override
        public void handleText(char[] data, int pos) {
            int offset = 0;
            if (this.simpleTag && data[0] == '>') {
                this.simpleTag = false;
                ++offset;
                while (offset < data.length && data[offset] <= ' ') {
                    ++offset;
                }
            }
            if (offset < data.length) {
                String text = new String(data, offset, data.length - offset);
                this.text(text);
            }
        }

        @Override
        public void flush() {
            this.flushPendingNewline();
        }

        private void newline(boolean implicit) {
            if (implicit) {
                this.pendingNewline = true;
            } else {
                this.flushPendingNewline();
                this.sb.append('\n');
            }
        }

        private void flushPendingNewline() {
            if (this.pendingNewline) {
                this.pendingNewline = false;
                if (this.sb.length() > 0) {
                    this.sb.append('\n');
                }
            }
        }

        private void text(String data) {
            this.flushPendingNewline();
            if (this.sb.length() <= 0 || this.sb.charAt(this.sb.length() - 1) == '\n') {
                for (int i = 0; i < this.depth; ++i) {
                    this.sb.append('\t');
                }
            }
            String text = this.preformatted > 0 ? data : data.replace('\n', ' ');
            this.sb.append(text);
        }

        class Counter {
            int value;

            Counter() {
            }
        }
    }
}

