/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.ant.AntBuildWriterUtil;
import org.apache.maven.plugin.ant.ArtifactResolverWrapper;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlWriterUtil;

public class AntBuildWriter {
    protected static final int DEFAULT_INDENTATION_SIZE = 2;
    protected static final String DEFAULT_BUILD_FILENAME = "build.xml";
    protected static final String DEFAULT_MAVEN_BUILD_FILENAME = "maven-build.xml";
    protected static final String DEFAULT_MAVEN_PROPERTIES_FILENAME = "maven-build.properties";
    private MavenProject project;
    private ArtifactResolverWrapper artifactResolverWrapper;
    private File localRepository;
    private Settings settings;
    private boolean overwrite;

    public AntBuildWriter(MavenProject project, ArtifactResolverWrapper artifactResolverWrapper, Settings settings, boolean overwrite) {
        this.project = project;
        this.artifactResolverWrapper = artifactResolverWrapper;
        this.localRepository = new File(artifactResolverWrapper.getLocalRepository().getBasedir());
        this.settings = settings;
        this.overwrite = overwrite;
    }

    protected void writeBuildXmls() throws IOException {
        this.writeGeneratedBuildXml();
        this.writeBuildXml();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeBuildProperties() throws IOException {
        Resource[] array;
        int i;
        String[] compileSourceRoots;
        if (AntBuildWriterUtil.isPomPackaging(this.project)) {
            return;
        }
        Properties properties = new Properties();
        AntBuildWriter.addProperty(properties, "maven.build.finalName", AntBuildWriterUtil.toRelative(this.project.getBasedir(), this.project.getBuild().getFinalName()));
        AntBuildWriter.addProperty(properties, "maven.build.dir", AntBuildWriterUtil.toRelative(this.project.getBasedir(), this.project.getBuild().getDirectory()));
        AntBuildWriter.addProperty(properties, "project.build.directory", "${maven.build.dir}");
        AntBuildWriter.addProperty(properties, "maven.build.outputDir", "${maven.build.dir}/" + AntBuildWriterUtil.toRelative(new File(this.project.getBasedir(), properties.getProperty("maven.build.dir")), this.project.getBuild().getOutputDirectory()));
        AntBuildWriter.addProperty(properties, "project.build.outputDirectory", "${maven.build.outputDir}");
        if (!this.project.getCompileSourceRoots().isEmpty()) {
            compileSourceRoots = this.project.getCompileSourceRoots().toArray(new String[0]);
            for (i = 0; i < compileSourceRoots.length; ++i) {
                AntBuildWriter.addProperty(properties, "maven.build.srcDir." + i, AntBuildWriterUtil.toRelative(this.project.getBasedir(), compileSourceRoots[i]));
            }
        }
        if (this.project.getBuild().getResources() != null) {
            array = this.project.getBuild().getResources().toArray(new Resource[0]);
            for (i = 0; i < array.length; ++i) {
                AntBuildWriter.addProperty(properties, "maven.build.resourceDir." + i, AntBuildWriterUtil.toRelative(this.project.getBasedir(), array[i].getDirectory()));
            }
        }
        AntBuildWriter.addProperty(properties, "maven.build.testOutputDir", "${maven.build.dir}/" + AntBuildWriterUtil.toRelative(new File(this.project.getBasedir(), properties.getProperty("maven.build.dir")), this.project.getBuild().getTestOutputDirectory()));
        if (!this.project.getTestCompileSourceRoots().isEmpty()) {
            compileSourceRoots = this.project.getTestCompileSourceRoots().toArray(new String[0]);
            for (i = 0; i < compileSourceRoots.length; ++i) {
                AntBuildWriter.addProperty(properties, "maven.build.testDir." + i, AntBuildWriterUtil.toRelative(this.project.getBasedir(), compileSourceRoots[i]));
            }
        }
        if (this.project.getBuild().getTestResources() != null) {
            array = this.project.getBuild().getTestResources().toArray(new Resource[0]);
            for (i = 0; i < array.length; ++i) {
                AntBuildWriter.addProperty(properties, "maven.build.testResourceDir." + i, AntBuildWriterUtil.toRelative(this.project.getBasedir(), array[i].getDirectory()));
            }
        }
        AntBuildWriter.addProperty(properties, "maven.test.reports", "${maven.build.dir}/test-reports");
        AntBuildWriter.addProperty(properties, "maven.reporting.outputDirectory", "${maven.build.dir}/site");
        AntBuildWriter.addProperty(properties, "maven.settings.offline", String.valueOf(this.settings.isOffline()));
        AntBuildWriter.addProperty(properties, "maven.settings.interactiveMode", String.valueOf(this.settings.isInteractiveMode()));
        AntBuildWriter.addProperty(properties, "maven.repo.local", this.getLocalRepositoryPath());
        if (this.project.getProperties() != null) {
            Iterator<Map.Entry<Object, Object>> it = this.project.getProperties().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> property = it.next();
                AntBuildWriter.addProperty(properties, property.getKey().toString(), property.getValue().toString());
            }
        }
        FileOutputStream os = new FileOutputStream(new File(this.project.getBasedir(), DEFAULT_MAVEN_PROPERTIES_FILENAME));
        try {
            properties.store(os, "Generated by Maven Ant Plugin - DO NOT EDIT THIS FILE!");
        }
        finally {
            IOUtil.close((OutputStream)os);
        }
    }

    private void writeGeneratedBuildXml() throws IOException {
        File outputFile = new File(this.project.getBasedir(), DEFAULT_MAVEN_BUILD_FILENAME);
        String encoding = "UTF-8";
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), encoding);
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, StringUtils.repeat((String)" ", (int)2), encoding, null);
        AntBuildWriterUtil.writeHeader((XMLWriter)writer);
        writer.startElement("project");
        writer.addAttribute("name", this.project.getArtifactId() + "-from-maven");
        writer.addAttribute("default", "package");
        writer.addAttribute("basedir", ".");
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        this.writeProperties((XMLWriter)writer);
        this.writeBuildPathDefinition((XMLWriter)writer);
        this.writeCleanTarget((XMLWriter)writer);
        List compileSourceRoots = AntBuildWriterUtil.removeEmptyCompileSourceRoots(this.project.getCompileSourceRoots());
        this.writeCompileTarget((XMLWriter)writer, compileSourceRoots);
        List testCompileSourceRoots = AntBuildWriterUtil.removeEmptyCompileSourceRoots(this.project.getTestCompileSourceRoots());
        this.writeCompileTestsTarget((XMLWriter)writer, testCompileSourceRoots);
        this.writeTestTargets((XMLWriter)writer, testCompileSourceRoots);
        this.writeJavadocTarget((XMLWriter)writer);
        this.writePackageTarget((XMLWriter)writer);
        this.writeGetDepsTarget((XMLWriter)writer);
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        writer.endElement();
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        IOUtil.close((Writer)w);
    }

    private void writeBuildXml() throws IOException {
        File outputFile = new File(this.project.getBasedir(), DEFAULT_BUILD_FILENAME);
        if (outputFile.exists() && !this.overwrite) {
            return;
        }
        String encoding = "UTF-8";
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), encoding);
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, StringUtils.repeat((String)" ", (int)2), encoding, null);
        AntBuildWriterUtil.writeAntVersionHeader((XMLWriter)writer);
        writer.startElement("project");
        writer.addAttribute("name", this.project.getArtifactId());
        writer.addAttribute("default", "package");
        writer.addAttribute("basedir", ".");
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Import maven-build.xml into the current project", (int)1);
        writer.startElement("import");
        writer.addAttribute("file", DEFAULT_MAVEN_BUILD_FILENAME);
        writer.endElement();
        XmlWriterUtil.writeLineBreak((XMLWriter)writer, (int)1, (int)1);
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Help target", (int)1);
        writer.startElement("target");
        writer.addAttribute("name", "help");
        writer.startElement("echo");
        writer.addAttribute("message", "Please run: $ant -projecthelp");
        writer.endElement();
        writer.endElement();
        XmlWriterUtil.writeLineBreak((XMLWriter)writer, (int)2);
        writer.endElement();
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        IOUtil.close((Writer)w);
    }

    private void writeProperties(XMLWriter writer) {
        Resource[] array;
        int i;
        String[] compileSourceRoots;
        if (AntBuildWriterUtil.isPomPackaging(this.project)) {
            return;
        }
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Build environment properties", (int)1);
        writer.startElement("property");
        writer.addAttribute("file", "${user.home}/.m2/maven.properties");
        writer.endElement();
        writer.startElement("property");
        writer.addAttribute("file", DEFAULT_MAVEN_PROPERTIES_FILENAME);
        writer.endElement();
        XmlWriterUtil.writeLineBreak((XMLWriter)writer, (int)2, (int)1);
        writer.startElement("property");
        writer.addAttribute("name", "maven.build.finalName");
        writer.addAttribute("value", this.project.getBuild().getFinalName());
        writer.endElement();
        writer.startElement("property");
        writer.addAttribute("name", "maven.build.dir");
        writer.addAttribute("value", AntBuildWriterUtil.toRelative(this.project.getBasedir(), this.project.getBuild().getDirectory()));
        writer.endElement();
        writer.startElement("property");
        writer.addAttribute("name", "maven.build.outputDir");
        writer.addAttribute("value", "${maven.build.dir}/" + AntBuildWriterUtil.toRelative(new File(this.project.getBuild().getDirectory()), this.project.getBuild().getOutputDirectory()));
        writer.endElement();
        if (!this.project.getCompileSourceRoots().isEmpty()) {
            compileSourceRoots = this.project.getCompileSourceRoots().toArray(new String[0]);
            for (i = 0; i < compileSourceRoots.length; ++i) {
                writer.startElement("property");
                writer.addAttribute("name", "maven.build.srcDir." + i);
                writer.addAttribute("value", AntBuildWriterUtil.toRelative(this.project.getBasedir(), compileSourceRoots[i]));
                writer.endElement();
            }
        }
        if (this.project.getBuild().getResources() != null) {
            array = this.project.getBuild().getResources().toArray(new Resource[0]);
            for (i = 0; i < array.length; ++i) {
                writer.startElement("property");
                writer.addAttribute("name", "maven.build.resourceDir." + i);
                writer.addAttribute("value", AntBuildWriterUtil.toRelative(this.project.getBasedir(), array[i].getDirectory()));
                writer.endElement();
            }
        }
        writer.startElement("property");
        writer.addAttribute("name", "maven.build.testOutputDir");
        writer.addAttribute("value", "${maven.build.dir}/" + AntBuildWriterUtil.toRelative(new File(this.project.getBuild().getDirectory()), this.project.getBuild().getTestOutputDirectory()));
        writer.endElement();
        if (!this.project.getTestCompileSourceRoots().isEmpty()) {
            compileSourceRoots = this.project.getTestCompileSourceRoots().toArray(new String[0]);
            for (i = 0; i < compileSourceRoots.length; ++i) {
                writer.startElement("property");
                writer.addAttribute("name", "maven.build.testDir." + i);
                writer.addAttribute("value", AntBuildWriterUtil.toRelative(this.project.getBasedir(), compileSourceRoots[i]));
                writer.endElement();
            }
        }
        if (this.project.getBuild().getTestResources() != null) {
            array = this.project.getBuild().getTestResources().toArray(new Resource[0]);
            for (i = 0; i < array.length; ++i) {
                writer.startElement("property");
                writer.addAttribute("name", "maven.build.testResourceDir." + i);
                writer.addAttribute("value", AntBuildWriterUtil.toRelative(this.project.getBasedir(), array[i].getDirectory()));
                writer.endElement();
            }
        }
        writer.startElement("property");
        writer.addAttribute("name", "maven.test.reports");
        writer.addAttribute("value", "${maven.build.dir}/test-reports");
        writer.endElement();
        String reportingOutputDir = this.project.getReporting().getOutputDirectory();
        if (!new File(reportingOutputDir).isAbsolute()) {
            reportingOutputDir = new File(this.project.getBasedir(), reportingOutputDir).getAbsolutePath();
        }
        writer.startElement("property");
        writer.addAttribute("name", "maven.reporting.outputDirectory");
        writer.addAttribute("value", "${maven.build.dir}/" + AntBuildWriterUtil.toRelative(new File(this.project.getBuild().getDirectory()), reportingOutputDir));
        writer.endElement();
        XmlWriterUtil.writeLineBreak((XMLWriter)writer, (int)2, (int)1);
        writer.startElement("property");
        writer.addAttribute("name", "maven.repo.local");
        writer.addAttribute("value", "${user.home}/.m2/repository");
        writer.endElement();
        writer.startElement("property");
        writer.addAttribute("name", "maven.settings.offline");
        writer.addAttribute("value", String.valueOf(this.settings.isOffline()));
        writer.endElement();
        writer.startElement("property");
        writer.addAttribute("name", "maven.settings.interactiveMode");
        writer.addAttribute("value", String.valueOf(this.settings.isInteractiveMode()));
        writer.endElement();
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
    }

    private String getLocalRepositoryPath() {
        String userHome = System.getProperty("user.home");
        String defaultPath = (userHome + "/.m2/repository").replace('\\', '/');
        String actualPath = this.localRepository.getAbsolutePath().replace('\\', '/');
        if (actualPath.equals(defaultPath)) {
            return "${user.home}/.m2/repository";
        }
        return this.localRepository.getAbsolutePath();
    }

    private void writeBuildPathDefinition(XMLWriter writer) {
        String path;
        Artifact artifact;
        Iterator i;
        if (AntBuildWriterUtil.isPomPackaging(this.project)) {
            return;
        }
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Defining classpaths", (int)1);
        writer.startElement("path");
        writer.addAttribute("id", "build.classpath");
        writer.startElement("fileset");
        writer.addAttribute("dir", "${maven.repo.local}");
        if (!this.project.getCompileArtifacts().isEmpty()) {
            i = this.project.getCompileArtifacts().iterator();
            while (i.hasNext()) {
                artifact = (Artifact)i.next();
                path = this.artifactResolverWrapper.getLocalArtifactPath(artifact);
                writer.startElement("include");
                writer.addAttribute("name", path);
                writer.endElement();
            }
        } else {
            writer.startElement("include");
            writer.addAttribute("name", "*.jar");
            writer.endElement();
        }
        writer.endElement();
        writer.endElement();
        writer.startElement("path");
        writer.addAttribute("id", "build.test.classpath");
        writer.startElement("fileset");
        writer.addAttribute("dir", "${maven.repo.local}");
        if (!this.project.getTestArtifacts().isEmpty()) {
            i = this.project.getTestArtifacts().iterator();
            while (i.hasNext()) {
                artifact = (Artifact)i.next();
                path = this.artifactResolverWrapper.getLocalArtifactPath(artifact);
                writer.startElement("include");
                writer.addAttribute("name", path);
                writer.endElement();
            }
        } else {
            writer.startElement("include");
            writer.addAttribute("name", "*.jar");
            writer.endElement();
        }
        writer.endElement();
        writer.endElement();
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
    }

    private void writeCleanTarget(XMLWriter writer) {
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Cleaning up target", (int)1);
        writer.startElement("target");
        writer.addAttribute("name", "clean");
        writer.addAttribute("description", "Clean the output directory");
        if (AntBuildWriterUtil.isPomPackaging(this.project)) {
            if (this.project.getModules() != null) {
                Iterator it = this.project.getModules().iterator();
                while (it.hasNext()) {
                    String moduleSubPath = (String)it.next();
                    AntBuildWriterUtil.writeAntTask(writer, this.project, moduleSubPath, "clean");
                }
            }
        } else {
            writer.startElement("delete");
            writer.addAttribute("dir", "${maven.build.dir}");
            writer.endElement();
        }
        writer.endElement();
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
    }

    private void writeCompileTarget(XMLWriter writer, List compileSourceRoots) throws IOException {
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Compilation target", (int)1);
        if (AntBuildWriterUtil.isPomPackaging(this.project)) {
            writer.startElement("target");
            writer.addAttribute("name", "compile");
            writer.addAttribute("description", "Compile the code");
            if (this.project.getModules() != null) {
                Iterator it = this.project.getModules().iterator();
                while (it.hasNext()) {
                    String moduleSubPath = (String)it.next();
                    AntBuildWriterUtil.writeAntTask(writer, this.project, moduleSubPath, "compile");
                }
            }
            writer.endElement();
        } else {
            writer.startElement("target");
            writer.addAttribute("name", "compile");
            writer.addAttribute("depends", "get-deps");
            writer.addAttribute("description", "Compile the code");
            this.writeCompileTasks(writer, "${maven.build.outputDir}", compileSourceRoots, this.project.getBuild().getResources(), null, false);
            writer.endElement();
        }
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
    }

    private void writeCompileTestsTarget(XMLWriter writer, List testCompileSourceRoots) throws IOException {
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Test-compilation target", (int)1);
        if (AntBuildWriterUtil.isPomPackaging(this.project)) {
            writer.startElement("target");
            writer.addAttribute("name", "compile-tests");
            writer.addAttribute("description", "Compile the test code");
            if (this.project.getModules() != null) {
                Iterator it = this.project.getModules().iterator();
                while (it.hasNext()) {
                    String moduleSubPath = (String)it.next();
                    AntBuildWriterUtil.writeAntTask(writer, this.project, moduleSubPath, "compile-tests");
                }
            }
            writer.endElement();
        } else {
            writer.startElement("target");
            writer.addAttribute("name", "compile-tests");
            AntBuildWriterUtil.addWrapAttribute(writer, "target", "depends", "compile", 2);
            AntBuildWriterUtil.addWrapAttribute(writer, "target", "description", "Compile the test code", 2);
            AntBuildWriterUtil.addWrapAttribute(writer, "target", "unless", "maven.test.skip", 2);
            this.writeCompileTasks(writer, "${maven.build.testOutputDir}", testCompileSourceRoots, this.project.getBuild().getTestResources(), "${maven.build.outputDir}", true);
            writer.endElement();
        }
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
    }

    private void writeTestTargets(XMLWriter writer, List testCompileSourceRoots) throws IOException {
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Run all tests", (int)1);
        if (AntBuildWriterUtil.isPomPackaging(this.project)) {
            writer.startElement("target");
            writer.addAttribute("name", "test");
            writer.addAttribute("description", "Run the test cases");
            if (this.project.getModules() != null) {
                Iterator it = this.project.getModules().iterator();
                while (it.hasNext()) {
                    String moduleSubPath = (String)it.next();
                    AntBuildWriterUtil.writeAntTask(writer, this.project, moduleSubPath, "test");
                }
            }
            writer.endElement();
        } else {
            writer.startElement("target");
            writer.addAttribute("name", "test");
            AntBuildWriterUtil.addWrapAttribute(writer, "target", "depends", "compile-tests, junit-missing", 2);
            AntBuildWriterUtil.addWrapAttribute(writer, "target", "unless", "junit.skipped", 2);
            AntBuildWriterUtil.addWrapAttribute(writer, "target", "description", "Run the test cases", 2);
            if (!testCompileSourceRoots.isEmpty()) {
                writer.startElement("mkdir");
                writer.addAttribute("dir", "${maven.test.reports}");
                writer.endElement();
                writer.startElement("junit");
                writer.addAttribute("printSummary", "yes");
                writer.addAttribute("haltonerror", "true");
                writer.addAttribute("haltonfailure", "true");
                writer.addAttribute("fork", "true");
                writer.addAttribute("dir", ".");
                writer.startElement("sysproperty");
                writer.addAttribute("key", "basedir");
                writer.addAttribute("value", ".");
                writer.endElement();
                writer.startElement("formatter");
                writer.addAttribute("type", "xml");
                writer.endElement();
                writer.startElement("formatter");
                writer.addAttribute("type", "plain");
                writer.addAttribute("usefile", "false");
                writer.endElement();
                writer.startElement("classpath");
                writer.startElement("path");
                writer.addAttribute("refid", "build.test.classpath");
                writer.endElement();
                writer.startElement("pathelement");
                writer.addAttribute("location", "${maven.build.outputDir}");
                writer.endElement();
                writer.startElement("pathelement");
                writer.addAttribute("location", "${maven.build.testOutputDir}");
                writer.endElement();
                writer.endElement();
                writer.startElement("batchtest");
                writer.addAttribute("todir", "${maven.test.reports}");
                writer.addAttribute("unless", "test");
                List<String> includes = this.getTestIncludes();
                List excludes = this.getTestExcludes();
                this.writeTestFilesets(writer, testCompileSourceRoots, includes, excludes);
                writer.endElement();
                writer.startElement("batchtest");
                writer.addAttribute("todir", "${maven.test.reports}");
                writer.addAttribute("if", "test");
                includes = Arrays.asList("**/${test}.java");
                this.writeTestFilesets(writer, testCompileSourceRoots, includes, excludes);
                writer.endElement();
                writer.endElement();
            }
            writer.endElement();
            XmlWriterUtil.writeLineBreak((XMLWriter)writer, (int)2, (int)1);
            writer.startElement("target");
            writer.addAttribute("name", "test-junit-present");
            writer.startElement("available");
            writer.addAttribute("classname", "junit.framework.Test");
            writer.addAttribute("property", "junit.present");
            writer.endElement();
            writer.endElement();
            XmlWriterUtil.writeLineBreak((XMLWriter)writer, (int)2, (int)1);
            writer.startElement("target");
            writer.addAttribute("name", "test-junit-status");
            AntBuildWriterUtil.addWrapAttribute(writer, "target", "depends", "test-junit-present", 2);
            writer.startElement("condition");
            writer.addAttribute("property", "junit.missing");
            writer.startElement("and");
            writer.startElement("isfalse");
            writer.addAttribute("value", "${junit.present}");
            writer.endElement();
            writer.startElement("isfalse");
            writer.addAttribute("value", "${maven.test.skip}");
            writer.endElement();
            writer.endElement();
            writer.endElement();
            writer.startElement("condition");
            writer.addAttribute("property", "junit.skipped");
            writer.startElement("or");
            writer.startElement("isfalse");
            writer.addAttribute("value", "${junit.present}");
            writer.endElement();
            writer.startElement("istrue");
            writer.addAttribute("value", "${maven.test.skip}");
            writer.endElement();
            writer.endElement();
            writer.endElement();
            writer.endElement();
            XmlWriterUtil.writeLineBreak((XMLWriter)writer, (int)2, (int)1);
            writer.startElement("target");
            writer.addAttribute("name", "junit-missing");
            AntBuildWriterUtil.addWrapAttribute(writer, "target", "depends", "test-junit-status", 2);
            AntBuildWriterUtil.addWrapAttribute(writer, "target", "if", "junit.missing", 2);
            writer.startElement("echo");
            writer.writeText(StringUtils.repeat((String)"=", (int)35) + " WARNING " + StringUtils.repeat((String)"=", (int)35));
            writer.endElement();
            writer.startElement("echo");
            writer.writeText(" JUnit is not present in your $ANT_HOME/lib directory. Tests not executed.");
            writer.endElement();
            writer.startElement("echo");
            writer.writeText(StringUtils.repeat((String)"=", (int)79));
            writer.endElement();
            writer.endElement();
        }
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
    }

    private List getTestIncludes() throws IOException {
        List<String> includes = AntBuildWriter.getSelectorList(AntBuildWriterUtil.getMavenSurefirePluginOptions(this.project, "includes", null));
        if (includes == null || includes.isEmpty()) {
            includes = Arrays.asList("**/Test*.java", "**/*Test.java", "**/*TestCase.java");
        }
        return includes;
    }

    private List getTestExcludes() throws IOException {
        List<String> excludes = AntBuildWriter.getSelectorList(AntBuildWriterUtil.getMavenSurefirePluginOptions(this.project, "excludes", null));
        if (excludes == null || excludes.isEmpty()) {
            excludes = Arrays.asList("**/*Abstract*Test.java");
        }
        return excludes;
    }

    private void writeTestFilesets(XMLWriter writer, List testCompileSourceRoots, List includes, List excludes) {
        for (int i = 0; i < testCompileSourceRoots.size(); ++i) {
            writer.startElement("fileset");
            writer.addAttribute("dir", "${maven.build.testDir." + i + "}");
            AntBuildWriterUtil.writeIncludesExcludes(writer, includes, excludes);
            writer.endElement();
        }
    }

    private void writeJavadocTarget(XMLWriter writer) throws IOException {
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Javadoc target", (int)1);
        writer.startElement("target");
        writer.addAttribute("name", "javadoc");
        writer.addAttribute("description", "Generates the Javadoc of the application");
        if (AntBuildWriterUtil.isPomPackaging(this.project)) {
            if (this.project.getModules() != null) {
                Iterator it = this.project.getModules().iterator();
                while (it.hasNext()) {
                    String moduleSubPath = (String)it.next();
                    AntBuildWriterUtil.writeAntTask(writer, this.project, moduleSubPath, "javadoc");
                }
            }
        } else {
            AntBuildWriterUtil.writeJavadocTask(writer, this.project, this.artifactResolverWrapper);
        }
        writer.endElement();
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
    }

    private void writePackageTarget(XMLWriter writer) throws IOException {
        String synonym = null;
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Package target", (int)1);
        writer.startElement("target");
        writer.addAttribute("name", "package");
        if (!AntBuildWriterUtil.isPomPackaging(this.project)) {
            writer.addAttribute("depends", "compile,test");
        }
        writer.addAttribute("description", "Package the application");
        if (AntBuildWriterUtil.isPomPackaging(this.project)) {
            if (this.project.getModules() != null) {
                Iterator it = this.project.getModules().iterator();
                while (it.hasNext()) {
                    String moduleSubPath = (String)it.next();
                    AntBuildWriterUtil.writeAntTask(writer, this.project, moduleSubPath, "package");
                }
            }
        } else if (AntBuildWriterUtil.isJarPackaging(this.project)) {
            AntBuildWriterUtil.writeJarTask(writer, this.project);
            synonym = "jar";
        } else if (AntBuildWriterUtil.isEarPackaging(this.project)) {
            AntBuildWriterUtil.writeEarTask(writer, this.project, this.artifactResolverWrapper);
            synonym = "ear";
        } else if (AntBuildWriterUtil.isWarPackaging(this.project)) {
            AntBuildWriterUtil.writeWarTask(writer, this.project, this.artifactResolverWrapper);
            synonym = "war";
        } else {
            writer.startElement("echo");
            writer.addAttribute("message", "No Ant task exists for the packaging '" + this.project.getPackaging() + "'. " + "You could overrided the Ant package target in your build.xml.");
            writer.endElement();
        }
        writer.endElement();
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        if (synonym != null) {
            XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"A dummy target for the package named after the type it creates", (int)1);
            writer.startElement("target");
            writer.addAttribute("name", synonym);
            writer.addAttribute("depends", "package");
            writer.addAttribute("description", "Builds the " + synonym + " for the application");
            writer.endElement();
            XmlWriterUtil.writeLineBreak((XMLWriter)writer);
        }
    }

    private void writeCompileTasks(XMLWriter writer, String outputDirectory, List compileSourceRoots, List resources, String additionalClassesDirectory, boolean isTest) throws IOException {
        writer.startElement("mkdir");
        writer.addAttribute("dir", outputDirectory);
        writer.endElement();
        if (!compileSourceRoots.isEmpty()) {
            writer.startElement("javac");
            writer.addAttribute("destdir", outputDirectory);
            Map[] includes = AntBuildWriterUtil.getMavenCompilerPluginOptions(this.project, "includes", null);
            AntBuildWriterUtil.addWrapAttribute(writer, "javac", "includes", AntBuildWriter.getCommaSeparatedList(includes, "include"), 3);
            Map[] excludes = AntBuildWriterUtil.getMavenCompilerPluginOptions(this.project, "excludes", null);
            AntBuildWriterUtil.addWrapAttribute(writer, "javac", "excludes", AntBuildWriter.getCommaSeparatedList(excludes, "exclude"), 3);
            AntBuildWriterUtil.addWrapAttribute(writer, "javac", "encoding", AntBuildWriterUtil.getMavenCompilerPluginBasicOption(this.project, "encoding", null), 3);
            AntBuildWriterUtil.addWrapAttribute(writer, "javac", "nowarn", AntBuildWriterUtil.getMavenCompilerPluginBasicOption(this.project, "showWarnings", "false"), 3);
            AntBuildWriterUtil.addWrapAttribute(writer, "javac", "debug", AntBuildWriterUtil.getMavenCompilerPluginBasicOption(this.project, "debug", "true"), 3);
            AntBuildWriterUtil.addWrapAttribute(writer, "javac", "optimize", AntBuildWriterUtil.getMavenCompilerPluginBasicOption(this.project, "optimize", "false"), 3);
            AntBuildWriterUtil.addWrapAttribute(writer, "javac", "deprecation", AntBuildWriterUtil.getMavenCompilerPluginBasicOption(this.project, "showDeprecation", "true"), 3);
            AntBuildWriterUtil.addWrapAttribute(writer, "javac", "target", AntBuildWriterUtil.getMavenCompilerPluginBasicOption(this.project, "target", "1.1"), 3);
            AntBuildWriterUtil.addWrapAttribute(writer, "javac", "verbose", AntBuildWriterUtil.getMavenCompilerPluginBasicOption(this.project, "verbose", "false"), 3);
            AntBuildWriterUtil.addWrapAttribute(writer, "javac", "fork", AntBuildWriterUtil.getMavenCompilerPluginBasicOption(this.project, "fork", "false"), 3);
            AntBuildWriterUtil.addWrapAttribute(writer, "javac", "memoryMaximumSize", AntBuildWriterUtil.getMavenCompilerPluginBasicOption(this.project, "meminitial", null), 3);
            AntBuildWriterUtil.addWrapAttribute(writer, "javac", "memoryInitialSize", AntBuildWriterUtil.getMavenCompilerPluginBasicOption(this.project, "maxmem", null), 3);
            AntBuildWriterUtil.addWrapAttribute(writer, "javac", "source", AntBuildWriterUtil.getMavenCompilerPluginBasicOption(this.project, "source", "1.3"), 3);
            String[] compileSourceRootsArray = compileSourceRoots.toArray(new String[0]);
            for (int i = 0; i < compileSourceRootsArray.length; ++i) {
                writer.startElement("src");
                writer.startElement("pathelement");
                if (isTest) {
                    writer.addAttribute("location", "${maven.build.testDir." + i + "}");
                } else {
                    writer.addAttribute("location", "${maven.build.srcDir." + i + "}");
                }
                writer.endElement();
                writer.endElement();
            }
            if (additionalClassesDirectory == null) {
                writer.startElement("classpath");
                if (isTest) {
                    writer.addAttribute("refid", "build.test.classpath");
                } else {
                    writer.addAttribute("refid", "build.classpath");
                }
                writer.endElement();
            } else {
                writer.startElement("classpath");
                writer.startElement("path");
                if (isTest) {
                    writer.addAttribute("refid", "build.test.classpath");
                } else {
                    writer.addAttribute("refid", "build.classpath");
                }
                writer.endElement();
                writer.startElement("pathelement");
                writer.addAttribute("location", additionalClassesDirectory);
                writer.endElement();
                writer.endElement();
            }
            writer.endElement();
        }
        Resource[] array = resources.toArray(new Resource[0]);
        for (int i = 0; i < array.length; ++i) {
            Resource resource = array[i];
            if (!new File(resource.getDirectory()).exists()) continue;
            String outputDir = outputDirectory;
            if (resource.getTargetPath() != null && resource.getTargetPath().length() > 0) {
                outputDir = outputDir + "/" + resource.getTargetPath();
                writer.startElement("mkdir");
                writer.addAttribute("dir", outputDir);
                writer.endElement();
            }
            writer.startElement("copy");
            writer.addAttribute("todir", outputDir);
            writer.startElement("fileset");
            if (isTest) {
                writer.addAttribute("dir", "${maven.build.testResourceDir." + i + "}");
            } else {
                writer.addAttribute("dir", "${maven.build.resourceDir." + i + "}");
            }
            AntBuildWriterUtil.writeIncludesExcludes(writer, resource.getIncludes(), resource.getExcludes());
            writer.endElement();
            writer.endElement();
        }
    }

    private void writeGetDepsTarget(XMLWriter writer) {
        if (AntBuildWriterUtil.isPomPackaging(this.project)) {
            return;
        }
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Download dependencies target", (int)1);
        writer.startElement("target");
        writer.addAttribute("name", "test-offline");
        writer.startElement("condition");
        writer.addAttribute("property", "maven.mode.offline");
        writer.startElement("equals");
        writer.addAttribute("arg1", "${maven.settings.offline}");
        writer.addAttribute("arg2", "true");
        writer.endElement();
        writer.endElement();
        writer.endElement();
        XmlWriterUtil.writeLineBreak((XMLWriter)writer, (int)2, (int)1);
        writer.startElement("target");
        writer.addAttribute("name", "get-deps");
        AntBuildWriterUtil.addWrapAttribute(writer, "target", "depends", "test-offline", 2);
        AntBuildWriterUtil.addWrapAttribute(writer, "target", "description", "Download all dependencies", 2);
        AntBuildWriterUtil.addWrapAttribute(writer, "target", "unless", "maven.mode.offline", 2);
        writer.startElement("mkdir");
        writer.addAttribute("dir", "${maven.repo.local}");
        writer.endElement();
        String basedir = this.project.getBasedir().getAbsolutePath();
        Iterator i = this.project.getTestArtifacts().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            String path = this.artifactResolverWrapper.getLocalArtifactPath(artifact);
            if (new File(path).exists()) continue;
            File parentDirs = new File(path).getParentFile();
            if (parentDirs != null) {
                writer.startElement("mkdir");
                writer.addAttribute("dir", "${maven.repo.local}/" + parentDirs.getPath().replace('\\', '/'));
                writer.endElement();
            }
            Iterator j = this.project.getRepositories().iterator();
            while (j.hasNext()) {
                Repository repository = (Repository)j.next();
                String url = repository.getUrl();
                String localDir = AntBuildWriter.getProjectRepoDirectory(url, basedir);
                if (localDir != null) {
                    if (localDir.length() > 0 && !localDir.endsWith("/")) {
                        localDir = localDir + '/';
                    }
                    writer.startElement("copy");
                    writer.addAttribute("file", localDir + path);
                    AntBuildWriterUtil.addWrapAttribute(writer, "copy", "tofile", "${maven.repo.local}/" + path, 3);
                    AntBuildWriterUtil.addWrapAttribute(writer, "copy", "failonerror", "false", 3);
                    writer.endElement();
                    continue;
                }
                writer.startElement("get");
                writer.addAttribute("src", url + '/' + path);
                AntBuildWriterUtil.addWrapAttribute(writer, "get", "dest", "${maven.repo.local}/" + path, 3);
                AntBuildWriterUtil.addWrapAttribute(writer, "get", "usetimestamp", "false", 3);
                AntBuildWriterUtil.addWrapAttribute(writer, "get", "ignoreerrors", "true", 3);
                writer.endElement();
            }
        }
        writer.endElement();
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
    }

    static String getProjectRepoDirectory(String repoUrl, String projectDir) {
        try {
            String path;
            String temp;
            if (repoUrl.regionMatches(true, 0, "file://", 0, 7) && !(temp = repoUrl.substring(7)).startsWith("/") && !temp.regionMatches(true, 0, "localhost/", 0, 10)) {
                repoUrl = "file:///" + temp;
            }
            if ((path = FileUtils.toFile((URL)new URL(repoUrl)).getPath()).startsWith(projectDir)) {
                if ((path = path.substring(projectDir.length()).replace('\\', '/')).startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                return path;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void addProperty(Properties properties, String name, String value) {
        properties.put(name, StringUtils.isNotEmpty((String)value) ? value : "");
    }

    private static String getCommaSeparatedList(Map[] includes, String key) {
        if (includes == null || includes.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < includes.length; ++i) {
            String s = (String)includes[i].get(key);
            if (StringUtils.isEmpty((String)s)) continue;
            sb.append(s);
            if (i >= includes.length - 1) continue;
            sb.append(",");
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    private static List getSelectorList(Map[] options) {
        ArrayList list = new ArrayList();
        if (options != null && options.length > 0) {
            for (int i = 0; i < options.length; ++i) {
                Map option = options[i];
                list.addAll(option.values());
            }
        }
        return list;
    }
}

