/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.antrun;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.antrun.AntPropertyHelper;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.types.Path;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractAntMojo
extends AbstractMojo {
    protected void executeTasks(Target antTasks, MavenProject mavenProject) throws MojoExecutionException {
        this.executeTasks(antTasks, mavenProject, null);
    }

    protected void executeTasks(Target antTasks, MavenProject mavenProject, List pluginArtifacts) throws MojoExecutionException {
        if (antTasks == null) {
            this.getLog().info((CharSequence)"No ant tasks defined - SKIPPED");
            return;
        }
        try {
            ExpressionEvaluator exprEvaluator = (ExpressionEvaluator)antTasks.getProject().getReference("maven.expressionEvaluator");
            Project antProject = antTasks.getProject();
            PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper((Project)antProject);
            propertyHelper.setNext((PropertyHelper)new AntPropertyHelper(exprEvaluator, mavenProject.getArtifacts(), this.getLog()));
            DefaultLogger antLogger = new DefaultLogger();
            antLogger.setOutputPrintStream(System.out);
            antLogger.setErrorPrintStream(System.err);
            antLogger.setMessageOutputLevel(this.getLog().isDebugEnabled() ? 4 : 2);
            antProject.addBuildListener((BuildListener)antLogger);
            antProject.setBaseDir(mavenProject.getBasedir());
            Path p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getCompileClasspathElements().iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.dependency.classpath", (Object)p);
            antProject.addReference("maven.compile.classpath", (Object)p);
            p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getRuntimeClasspathElements().iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.runtime.classpath", (Object)p);
            p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getTestClasspathElements().iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.test.classpath", (Object)p);
            antProject.addReference("maven.plugin.classpath", (Object)this.getPathFromArtifacts(pluginArtifacts, antProject));
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"Executing tasks");
            }
            antTasks.execute();
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"Executed tasks");
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("DependencyResolutionRequiredException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (BuildException e) {
            throw new MojoExecutionException("An Ant BuildException has occured: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing ant tasks: " + e.getMessage(), e);
        }
    }

    public Path getPathFromArtifacts(Collection artifacts, Project antProject) throws DependencyResolutionRequiredException {
        if (artifacts == null) {
            return new Path(antProject);
        }
        ArrayList<String> list = new ArrayList<String>(artifacts.size());
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            File file = a.getFile();
            if (file == null) {
                throw new DependencyResolutionRequiredException(a);
            }
            list.add(file.getPath());
        }
        Path p = new Path(antProject);
        p.setPath(StringUtils.join(list.iterator(), (String)File.pathSeparator));
        return p;
    }
}

