/*
 * $Id$
 */

package org.apache.maven.plugins.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Describes the assembly layout and packaging.
 * 
 * @version $Revision$ $Date$
 */
public class Assembly implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field formats
     */
    private java.util.List formats;

    /**
     * Field includeBaseDirectory
     */
    private boolean includeBaseDirectory = true;

    /**
     * Field includeSiteDirectory
     */
    private boolean includeSiteDirectory = false;

    /**
     * Field moduleSets
     */
    private java.util.List moduleSets;

    /**
     * Field fileSets
     */
    private java.util.List fileSets;

    /**
     * Field files
     */
    private java.util.List files;

    /**
     * Field dependencySets
     */
    private java.util.List dependencySets;

    /**
     * Field repositories
     */
    private java.util.List repositories;

    /**
     * Field componentDescriptors
     */
    private java.util.List componentDescriptors;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addComponentDescriptor
     * 
     * @param string
     */
    public void addComponentDescriptor(String string)
    {
        getComponentDescriptors().add( string );
    } //-- void addComponentDescriptor(String) 

    /**
     * Method addDependencySet
     * 
     * @param dependencySet
     */
    public void addDependencySet(DependencySet dependencySet)
    {
        getDependencySets().add( dependencySet );
    } //-- void addDependencySet(DependencySet) 

    /**
     * Method addFile
     * 
     * @param fileItem
     */
    public void addFile(FileItem fileItem)
    {
        getFiles().add( fileItem );
    } //-- void addFile(FileItem) 

    /**
     * Method addFileSet
     * 
     * @param fileSet
     */
    public void addFileSet(FileSet fileSet)
    {
        getFileSets().add( fileSet );
    } //-- void addFileSet(FileSet) 

    /**
     * Method addFormat
     * 
     * @param string
     */
    public void addFormat(String string)
    {
        getFormats().add( string );
    } //-- void addFormat(String) 

    /**
     * Method addModuleSet
     * 
     * @param moduleSet
     */
    public void addModuleSet(ModuleSet moduleSet)
    {
        getModuleSets().add( moduleSet );
    } //-- void addModuleSet(ModuleSet) 

    /**
     * Method addRepository
     * 
     * @param repository
     */
    public void addRepository(Repository repository)
    {
        getRepositories().add( repository );
    } //-- void addRepository(Repository) 

    /**
     * Method getComponentDescriptors
     */
    public java.util.List getComponentDescriptors()
    {
        if ( this.componentDescriptors == null )
        {
            this.componentDescriptors = new java.util.ArrayList();
        }
        
        return this.componentDescriptors;
    } //-- java.util.List getComponentDescriptors() 

    /**
     * Method getDependencySets
     */
    public java.util.List getDependencySets()
    {
        if ( this.dependencySets == null )
        {
            this.dependencySets = new java.util.ArrayList();
        }
        
        return this.dependencySets;
    } //-- java.util.List getDependencySets() 

    /**
     * Method getFileSets
     */
    public java.util.List getFileSets()
    {
        if ( this.fileSets == null )
        {
            this.fileSets = new java.util.ArrayList();
        }
        
        return this.fileSets;
    } //-- java.util.List getFileSets() 

    /**
     * Method getFiles
     */
    public java.util.List getFiles()
    {
        if ( this.files == null )
        {
            this.files = new java.util.ArrayList();
        }
        
        return this.files;
    } //-- java.util.List getFiles() 

    /**
     * Method getFormats
     */
    public java.util.List getFormats()
    {
        if ( this.formats == null )
        {
            this.formats = new java.util.ArrayList();
        }
        
        return this.formats;
    } //-- java.util.List getFormats() 

    /**
     * Get 
     *             The id of this assembly. This is a symbolic name
     * for a
     *             particular assembly of files from this project.
     *           
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Method getModuleSets
     */
    public java.util.List getModuleSets()
    {
        if ( this.moduleSets == null )
        {
            this.moduleSets = new java.util.ArrayList();
        }
        
        return this.moduleSets;
    } //-- java.util.List getModuleSets() 

    /**
     * Method getRepositories
     */
    public java.util.List getRepositories()
    {
        if ( this.repositories == null )
        {
            this.repositories = new java.util.ArrayList();
        }
        
        return this.repositories;
    } //-- java.util.List getRepositories() 

    /**
     * Get 
     *             Includes a base directory in the final archive.
     * For example,
     *             if you are creating an assembly named
     * "your-app", setting
     *             includeBaseDirectory to true will create an
     * archive that
     *             includes this base directory. If this option is
     * set to false
     *             the archive created will unzip its content to
     * the current
     *             directory.
     *           
     */
    public boolean isIncludeBaseDirectory()
    {
        return this.includeBaseDirectory;
    } //-- boolean isIncludeBaseDirectory() 

    /**
     * Get null
     */
    public boolean isIncludeSiteDirectory()
    {
        return this.includeSiteDirectory;
    } //-- boolean isIncludeSiteDirectory() 

    /**
     * Method removeComponentDescriptor
     * 
     * @param string
     */
    public void removeComponentDescriptor(String string)
    {
        getComponentDescriptors().remove( string );
    } //-- void removeComponentDescriptor(String) 

    /**
     * Method removeDependencySet
     * 
     * @param dependencySet
     */
    public void removeDependencySet(DependencySet dependencySet)
    {
        getDependencySets().remove( dependencySet );
    } //-- void removeDependencySet(DependencySet) 

    /**
     * Method removeFile
     * 
     * @param fileItem
     */
    public void removeFile(FileItem fileItem)
    {
        getFiles().remove( fileItem );
    } //-- void removeFile(FileItem) 

    /**
     * Method removeFileSet
     * 
     * @param fileSet
     */
    public void removeFileSet(FileSet fileSet)
    {
        getFileSets().remove( fileSet );
    } //-- void removeFileSet(FileSet) 

    /**
     * Method removeFormat
     * 
     * @param string
     */
    public void removeFormat(String string)
    {
        getFormats().remove( string );
    } //-- void removeFormat(String) 

    /**
     * Method removeModuleSet
     * 
     * @param moduleSet
     */
    public void removeModuleSet(ModuleSet moduleSet)
    {
        getModuleSets().remove( moduleSet );
    } //-- void removeModuleSet(ModuleSet) 

    /**
     * Method removeRepository
     * 
     * @param repository
     */
    public void removeRepository(Repository repository)
    {
        getRepositories().remove( repository );
    } //-- void removeRepository(Repository) 

    /**
     * Set 
     *             File relative to basedir containing Component.
     *           
     * 
     * @param componentDescriptors
     */
    public void setComponentDescriptors(java.util.List componentDescriptors)
    {
        this.componentDescriptors = componentDescriptors;
    } //-- void setComponentDescriptors(java.util.List) 

    /**
     * Set 
     *             Specify assembly behavior for sets of
     * dependencies.
     *           
     * 
     * @param dependencySets
     */
    public void setDependencySets(java.util.List dependencySets)
    {
        this.dependencySets = dependencySets;
    } //-- void setDependencySets(java.util.List) 

    /**
     * Set 
     *             Specify assembly parameters for groups of files.
     *           
     * 
     * @param fileSets
     */
    public void setFileSets(java.util.List fileSets)
    {
        this.fileSets = fileSets;
    } //-- void setFileSets(java.util.List) 

    /**
     * Set 
     *             Specify assembly parameters for single files.
     *           
     * 
     * @param files
     */
    public void setFiles(java.util.List files)
    {
        this.files = files;
    } //-- void setFiles(java.util.List) 

    /**
     * Set 
     *             
     *             Specify the formats of the assembly.  A format
     * is specified by 
     *             supplying one of the following values in a
     * &lt;format&gt; subelement:
     *             <ul>
     *               <li><b>"zip"</b> - Creates a ZIP file
     * format</li>
     *               <li><b>"gz"</b> - Creates a GZIP format</li>
     *               <li><b>"tar"</b> - Creates a TAR format</li>
     *               <li><b>"tar.gz"</b> - Creates a gzip'd TAR
     * format</li>
     *               <li><b>"tar.bz2</b> - Creates a bzip'd TAR
     * format</li>
     *             </ul>
     *             
     *           
     * 
     * @param formats
     */
    public void setFormats(java.util.List formats)
    {
        this.formats = formats;
    } //-- void setFormats(java.util.List) 

    /**
     * Set 
     *             The id of this assembly. This is a symbolic name
     * for a
     *             particular assembly of files from this project.
     *           
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Set 
     *             Includes a base directory in the final archive.
     * For example,
     *             if you are creating an assembly named
     * "your-app", setting
     *             includeBaseDirectory to true will create an
     * archive that
     *             includes this base directory. If this option is
     * set to false
     *             the archive created will unzip its content to
     * the current
     *             directory.
     *           
     * 
     * @param includeBaseDirectory
     */
    public void setIncludeBaseDirectory(boolean includeBaseDirectory)
    {
        this.includeBaseDirectory = includeBaseDirectory;
    } //-- void setIncludeBaseDirectory(boolean) 

    /**
     * Set null
     * 
     * @param includeSiteDirectory
     */
    public void setIncludeSiteDirectory(boolean includeSiteDirectory)
    {
        this.includeSiteDirectory = includeSiteDirectory;
    } //-- void setIncludeSiteDirectory(boolean) 

    /**
     * Set 
     *             Specify which modules source files to include in
     * the assembly
     *           
     * 
     * @param moduleSets
     */
    public void setModuleSets(java.util.List moduleSets)
    {
        this.moduleSets = moduleSets;
    } //-- void setModuleSets(java.util.List) 

    /**
     * Set 
     *             Specify assembly behavior for sets of
     * repositories.
     *           
     * 
     * @param repositories
     */
    public void setRepositories(java.util.List repositories)
    {
        this.repositories = repositories;
    } //-- void setRepositories(java.util.List) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
