/*
 * $Id$
 */

package org.apache.maven.plugins.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Describes the component layout and packaging.
 * 
 * @version $Revision$ $Date$
 */
public class Component implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field fileSets
     */
    private java.util.List fileSets;

    /**
     * Field files
     */
    private java.util.List files;

    /**
     * Field dependencySets
     */
    private java.util.List dependencySets;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addDependencySet
     * 
     * @param dependencySet
     */
    public void addDependencySet(DependencySet dependencySet)
    {
        getDependencySets().add( dependencySet );
    } //-- void addDependencySet(DependencySet) 

    /**
     * Method addFile
     * 
     * @param fileItem
     */
    public void addFile(FileItem fileItem)
    {
        getFiles().add( fileItem );
    } //-- void addFile(FileItem) 

    /**
     * Method addFileSet
     * 
     * @param fileSet
     */
    public void addFileSet(FileSet fileSet)
    {
        getFileSets().add( fileSet );
    } //-- void addFileSet(FileSet) 

    /**
     * Method getDependencySets
     */
    public java.util.List getDependencySets()
    {
        if ( this.dependencySets == null )
        {
            this.dependencySets = new java.util.ArrayList();
        }
        
        return this.dependencySets;
    } //-- java.util.List getDependencySets() 

    /**
     * Method getFileSets
     */
    public java.util.List getFileSets()
    {
        if ( this.fileSets == null )
        {
            this.fileSets = new java.util.ArrayList();
        }
        
        return this.fileSets;
    } //-- java.util.List getFileSets() 

    /**
     * Method getFiles
     */
    public java.util.List getFiles()
    {
        if ( this.files == null )
        {
            this.files = new java.util.ArrayList();
        }
        
        return this.files;
    } //-- java.util.List getFiles() 

    /**
     * Method removeDependencySet
     * 
     * @param dependencySet
     */
    public void removeDependencySet(DependencySet dependencySet)
    {
        getDependencySets().remove( dependencySet );
    } //-- void removeDependencySet(DependencySet) 

    /**
     * Method removeFile
     * 
     * @param fileItem
     */
    public void removeFile(FileItem fileItem)
    {
        getFiles().remove( fileItem );
    } //-- void removeFile(FileItem) 

    /**
     * Method removeFileSet
     * 
     * @param fileSet
     */
    public void removeFileSet(FileSet fileSet)
    {
        getFileSets().remove( fileSet );
    } //-- void removeFileSet(FileSet) 

    /**
     * Set 
     *             Specify assembly behavior for sets of
     * dependencies.
     *           
     * 
     * @param dependencySets
     */
    public void setDependencySets(java.util.List dependencySets)
    {
        this.dependencySets = dependencySets;
    } //-- void setDependencySets(java.util.List) 

    /**
     * Set 
     *             Specify assembly parameters for groups of files.
     *           
     * 
     * @param fileSets
     */
    public void setFileSets(java.util.List fileSets)
    {
        this.fileSets = fileSets;
    } //-- void setFileSets(java.util.List) 

    /**
     * Set 
     *             Specify assembly parameters for single files.
     *           
     * 
     * @param files
     */
    public void setFiles(java.util.List files)
    {
        this.files = files;
    } //-- void setFiles(java.util.List) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
