/*
 * $Id$
 */

package org.apache.maven.plugins.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Defines a Maven repository to be included in the assembly.
 * 
 * @version $Revision$ $Date$
 */
public class Repository extends SetBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field includeMetadata
     */
    private boolean includeMetadata = false;

    /**
     * Field groupVersionAlignments
     */
    private java.util.List groupVersionAlignments;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addGroupVersionAlignment
     * 
     * @param groupVersionAlignment
     */
    public void addGroupVersionAlignment(GroupVersionAlignment groupVersionAlignment)
    {
        getGroupVersionAlignments().add( groupVersionAlignment );
    } //-- void addGroupVersionAlignment(GroupVersionAlignment) 

    /**
     * Method getGroupVersionAlignments
     */
    public java.util.List getGroupVersionAlignments()
    {
        if ( this.groupVersionAlignments == null )
        {
            this.groupVersionAlignments = new java.util.ArrayList();
        }
        
        return this.groupVersionAlignments;
    } //-- java.util.List getGroupVersionAlignments() 

    /**
     * Get 
     *             If set to true, this property will trigger the
     * creation of repository
     *             metadata which will allow the repository to be
     * used as a functional remote
     *             repository.
     *           
     */
    public boolean isIncludeMetadata()
    {
        return this.includeMetadata;
    } //-- boolean isIncludeMetadata() 

    /**
     * Method removeGroupVersionAlignment
     * 
     * @param groupVersionAlignment
     */
    public void removeGroupVersionAlignment(GroupVersionAlignment groupVersionAlignment)
    {
        getGroupVersionAlignments().remove( groupVersionAlignment );
    } //-- void removeGroupVersionAlignment(GroupVersionAlignment) 

    /**
     * Set Align a group to a version or an individual artifact.
     * 
     * @param groupVersionAlignments
     */
    public void setGroupVersionAlignments(java.util.List groupVersionAlignments)
    {
        this.groupVersionAlignments = groupVersionAlignments;
    } //-- void setGroupVersionAlignments(java.util.List) 

    /**
     * Set 
     *             If set to true, this property will trigger the
     * creation of repository
     *             metadata which will allow the repository to be
     * used as a functional remote
     *             repository.
     *           
     * 
     * @param includeMetadata
     */
    public void setIncludeMetadata(boolean includeMetadata)
    {
        this.includeMetadata = includeMetadata;
    } //-- void setIncludeMetadata(boolean) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
