/*
 * $Id$
 */

package org.apache.maven.plugins.assembly.model.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.Writer;
import java.text.DateFormat;
import java.util.Iterator;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.model.DependencySet;
import org.apache.maven.plugins.assembly.model.FileItem;
import org.apache.maven.plugins.assembly.model.FileSet;
import org.apache.maven.plugins.assembly.model.GroupVersionAlignment;
import org.apache.maven.plugins.assembly.model.ModuleBinaries;
import org.apache.maven.plugins.assembly.model.ModuleSet;
import org.apache.maven.plugins.assembly.model.ModuleSources;
import org.apache.maven.plugins.assembly.model.Repository;
import org.apache.maven.plugins.assembly.model.SetBase;
import org.codehaus.plexus.util.xml.pull.*;

/**
 * Class AssemblyXpp3Writer.
 * 
 * @version $Revision$ $Date$
 */
public class AssemblyXpp3Writer {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field serializer
     */
    private org.codehaus.plexus.util.xml.pull.XmlSerializer serializer;

    /**
     * Field NAMESPACE
     */
    private String NAMESPACE;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write
     * 
     * @param writer
     * @param assembly
     */
    public void write(Writer writer, Assembly assembly)
        throws java.io.IOException
    {
        serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( writer );
        serializer.startDocument( assembly.getModelEncoding(), null );
        writeAssembly( assembly, "assembly", serializer );
        serializer.endDocument();
    } //-- void write(Writer, Assembly) 

    /**
     * Method writeAssembly
     * 
     * @param assembly
     * @param serializer
     * @param tagName
     */
    private void writeAssembly(Assembly assembly, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( assembly != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( assembly.getId() != null )
            {
                serializer.startTag( NAMESPACE, "id" ).text( assembly.getId() ).endTag( NAMESPACE, "id" );
            }
            if ( assembly.getFormats() != null && assembly.getFormats().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "formats" );
                for ( Iterator iter = assembly.getFormats().iterator(); iter.hasNext(); )
                {
                    String format = (String) iter.next();
                    serializer.startTag( NAMESPACE, "format" ).text( format ).endTag( NAMESPACE, "format" );
                }
                serializer.endTag( NAMESPACE, "formats" );
            }
            if ( assembly.isIncludeBaseDirectory() != true )
            {
                serializer.startTag( NAMESPACE, "includeBaseDirectory" ).text( String.valueOf( assembly.isIncludeBaseDirectory() ) ).endTag( NAMESPACE, "includeBaseDirectory" );
            }
            if ( assembly.isIncludeSiteDirectory() != false )
            {
                serializer.startTag( NAMESPACE, "includeSiteDirectory" ).text( String.valueOf( assembly.isIncludeSiteDirectory() ) ).endTag( NAMESPACE, "includeSiteDirectory" );
            }
            if ( assembly.getModuleSets() != null && assembly.getModuleSets().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "moduleSets" );
                for ( Iterator iter = assembly.getModuleSets().iterator(); iter.hasNext(); )
                {
                    ModuleSet o = (ModuleSet) iter.next();
                    writeModuleSet( o, "moduleSet", serializer );
                }
                serializer.endTag( NAMESPACE, "moduleSets" );
            }
            if ( assembly.getFileSets() != null && assembly.getFileSets().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "fileSets" );
                for ( Iterator iter = assembly.getFileSets().iterator(); iter.hasNext(); )
                {
                    FileSet o = (FileSet) iter.next();
                    writeFileSet( o, "fileSet", serializer );
                }
                serializer.endTag( NAMESPACE, "fileSets" );
            }
            if ( assembly.getFiles() != null && assembly.getFiles().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "files" );
                for ( Iterator iter = assembly.getFiles().iterator(); iter.hasNext(); )
                {
                    FileItem o = (FileItem) iter.next();
                    writeFileItem( o, "file", serializer );
                }
                serializer.endTag( NAMESPACE, "files" );
            }
            if ( assembly.getDependencySets() != null && assembly.getDependencySets().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "dependencySets" );
                for ( Iterator iter = assembly.getDependencySets().iterator(); iter.hasNext(); )
                {
                    DependencySet o = (DependencySet) iter.next();
                    writeDependencySet( o, "dependencySet", serializer );
                }
                serializer.endTag( NAMESPACE, "dependencySets" );
            }
            if ( assembly.getRepositories() != null && assembly.getRepositories().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "repositories" );
                for ( Iterator iter = assembly.getRepositories().iterator(); iter.hasNext(); )
                {
                    Repository o = (Repository) iter.next();
                    writeRepository( o, "repository", serializer );
                }
                serializer.endTag( NAMESPACE, "repositories" );
            }
            if ( assembly.getComponentDescriptors() != null && assembly.getComponentDescriptors().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "componentDescriptors" );
                for ( Iterator iter = assembly.getComponentDescriptors().iterator(); iter.hasNext(); )
                {
                    String componentDescriptor = (String) iter.next();
                    serializer.startTag( NAMESPACE, "componentDescriptor" ).text( componentDescriptor ).endTag( NAMESPACE, "componentDescriptor" );
                }
                serializer.endTag( NAMESPACE, "componentDescriptors" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeAssembly(Assembly, String, XmlSerializer) 

    /**
     * Method writeDependencySet
     * 
     * @param dependencySet
     * @param serializer
     * @param tagName
     */
    private void writeDependencySet(DependencySet dependencySet, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( dependencySet != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( dependencySet.getOutputFileNameMapping() != null && !dependencySet.getOutputFileNameMapping().equals( "${artifactId}-${version}.${extension}" ) )
            {
                serializer.startTag( NAMESPACE, "outputFileNameMapping" ).text( dependencySet.getOutputFileNameMapping() ).endTag( NAMESPACE, "outputFileNameMapping" );
            }
            if ( dependencySet.isUnpack() != false )
            {
                serializer.startTag( NAMESPACE, "unpack" ).text( String.valueOf( dependencySet.isUnpack() ) ).endTag( NAMESPACE, "unpack" );
            }
            if ( dependencySet.getScope() != null && !dependencySet.getScope().equals( "runtime" ) )
            {
                serializer.startTag( NAMESPACE, "scope" ).text( dependencySet.getScope() ).endTag( NAMESPACE, "scope" );
            }
            if ( dependencySet.getOutputDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "outputDirectory" ).text( dependencySet.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
            }
            if ( dependencySet.getIncludes() != null && dependencySet.getIncludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = dependencySet.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( dependencySet.getExcludes() != null && dependencySet.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = dependencySet.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            if ( dependencySet.getFileMode() != null && !dependencySet.getFileMode().equals( "0644" ) )
            {
                serializer.startTag( NAMESPACE, "fileMode" ).text( dependencySet.getFileMode() ).endTag( NAMESPACE, "fileMode" );
            }
            if ( dependencySet.getDirectoryMode() != null && !dependencySet.getDirectoryMode().equals( "0755" ) )
            {
                serializer.startTag( NAMESPACE, "directoryMode" ).text( dependencySet.getDirectoryMode() ).endTag( NAMESPACE, "directoryMode" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeDependencySet(DependencySet, String, XmlSerializer) 

    /**
     * Method writeFileItem
     * 
     * @param fileItem
     * @param serializer
     * @param tagName
     */
    private void writeFileItem(FileItem fileItem, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( fileItem != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( fileItem.getSource() != null )
            {
                serializer.startTag( NAMESPACE, "source" ).text( fileItem.getSource() ).endTag( NAMESPACE, "source" );
            }
            if ( fileItem.getOutputDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "outputDirectory" ).text( fileItem.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
            }
            if ( fileItem.getDestName() != null )
            {
                serializer.startTag( NAMESPACE, "destName" ).text( fileItem.getDestName() ).endTag( NAMESPACE, "destName" );
            }
            if ( fileItem.getFileMode() != null && !fileItem.getFileMode().equals( "0644" ) )
            {
                serializer.startTag( NAMESPACE, "fileMode" ).text( fileItem.getFileMode() ).endTag( NAMESPACE, "fileMode" );
            }
            if ( fileItem.getLineEnding() != null )
            {
                serializer.startTag( NAMESPACE, "lineEnding" ).text( fileItem.getLineEnding() ).endTag( NAMESPACE, "lineEnding" );
            }
            if ( fileItem.isFiltered() != false )
            {
                serializer.startTag( NAMESPACE, "filtered" ).text( String.valueOf( fileItem.isFiltered() ) ).endTag( NAMESPACE, "filtered" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeFileItem(FileItem, String, XmlSerializer) 

    /**
     * Method writeFileSet
     * 
     * @param fileSet
     * @param serializer
     * @param tagName
     */
    private void writeFileSet(FileSet fileSet, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( fileSet != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( fileSet.getDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "directory" ).text( fileSet.getDirectory() ).endTag( NAMESPACE, "directory" );
            }
            if ( fileSet.getLineEnding() != null )
            {
                serializer.startTag( NAMESPACE, "lineEnding" ).text( fileSet.getLineEnding() ).endTag( NAMESPACE, "lineEnding" );
            }
            if ( fileSet.getOutputDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "outputDirectory" ).text( fileSet.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
            }
            if ( fileSet.getIncludes() != null && fileSet.getIncludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = fileSet.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( fileSet.getExcludes() != null && fileSet.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = fileSet.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            if ( fileSet.getFileMode() != null && !fileSet.getFileMode().equals( "0644" ) )
            {
                serializer.startTag( NAMESPACE, "fileMode" ).text( fileSet.getFileMode() ).endTag( NAMESPACE, "fileMode" );
            }
            if ( fileSet.getDirectoryMode() != null && !fileSet.getDirectoryMode().equals( "0755" ) )
            {
                serializer.startTag( NAMESPACE, "directoryMode" ).text( fileSet.getDirectoryMode() ).endTag( NAMESPACE, "directoryMode" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeFileSet(FileSet, String, XmlSerializer) 

    /**
     * Method writeGroupVersionAlignment
     * 
     * @param groupVersionAlignment
     * @param serializer
     * @param tagName
     */
    private void writeGroupVersionAlignment(GroupVersionAlignment groupVersionAlignment, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( groupVersionAlignment != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( groupVersionAlignment.getId() != null )
            {
                serializer.startTag( NAMESPACE, "id" ).text( groupVersionAlignment.getId() ).endTag( NAMESPACE, "id" );
            }
            if ( groupVersionAlignment.getVersion() != null )
            {
                serializer.startTag( NAMESPACE, "version" ).text( groupVersionAlignment.getVersion() ).endTag( NAMESPACE, "version" );
            }
            if ( groupVersionAlignment.getExcludes() != null && groupVersionAlignment.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = groupVersionAlignment.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeGroupVersionAlignment(GroupVersionAlignment, String, XmlSerializer) 

    /**
     * Method writeModuleBinaries
     * 
     * @param moduleBinaries
     * @param serializer
     * @param tagName
     */
    private void writeModuleBinaries(ModuleBinaries moduleBinaries, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( moduleBinaries != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( moduleBinaries.isIncludeDependencies() != false )
            {
                serializer.startTag( NAMESPACE, "includeDependencies" ).text( String.valueOf( moduleBinaries.isIncludeDependencies() ) ).endTag( NAMESPACE, "includeDependencies" );
            }
            if ( moduleBinaries.isUnpack() != true )
            {
                serializer.startTag( NAMESPACE, "unpack" ).text( String.valueOf( moduleBinaries.isUnpack() ) ).endTag( NAMESPACE, "unpack" );
            }
            if ( moduleBinaries.getOutputFileNameMapping() != null && !moduleBinaries.getOutputFileNameMapping().equals( "${artifactId}-${version}.${extension}" ) )
            {
                serializer.startTag( NAMESPACE, "outputFileNameMapping" ).text( moduleBinaries.getOutputFileNameMapping() ).endTag( NAMESPACE, "outputFileNameMapping" );
            }
            if ( moduleBinaries.getOutputDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "outputDirectory" ).text( moduleBinaries.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
            }
            if ( moduleBinaries.getIncludes() != null && moduleBinaries.getIncludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = moduleBinaries.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( moduleBinaries.getExcludes() != null && moduleBinaries.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = moduleBinaries.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            if ( moduleBinaries.getFileMode() != null && !moduleBinaries.getFileMode().equals( "0644" ) )
            {
                serializer.startTag( NAMESPACE, "fileMode" ).text( moduleBinaries.getFileMode() ).endTag( NAMESPACE, "fileMode" );
            }
            if ( moduleBinaries.getDirectoryMode() != null && !moduleBinaries.getDirectoryMode().equals( "0755" ) )
            {
                serializer.startTag( NAMESPACE, "directoryMode" ).text( moduleBinaries.getDirectoryMode() ).endTag( NAMESPACE, "directoryMode" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeModuleBinaries(ModuleBinaries, String, XmlSerializer) 

    /**
     * Method writeModuleSet
     * 
     * @param moduleSet
     * @param serializer
     * @param tagName
     */
    private void writeModuleSet(ModuleSet moduleSet, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( moduleSet != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( moduleSet.getIncludes() != null && moduleSet.getIncludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = moduleSet.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( moduleSet.getExcludes() != null && moduleSet.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = moduleSet.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            if ( moduleSet.getSources() != null )
            {
                writeModuleSources( moduleSet.getSources(), "sources", serializer );
            }
            if ( moduleSet.getBinaries() != null )
            {
                writeModuleBinaries( moduleSet.getBinaries(), "binaries", serializer );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeModuleSet(ModuleSet, String, XmlSerializer) 

    /**
     * Method writeModuleSources
     * 
     * @param moduleSources
     * @param serializer
     * @param tagName
     */
    private void writeModuleSources(ModuleSources moduleSources, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( moduleSources != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( moduleSources.getOutputDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "outputDirectory" ).text( moduleSources.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
            }
            if ( moduleSources.getIncludes() != null && moduleSources.getIncludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = moduleSources.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( moduleSources.getExcludes() != null && moduleSources.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = moduleSources.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            if ( moduleSources.getFileMode() != null && !moduleSources.getFileMode().equals( "0644" ) )
            {
                serializer.startTag( NAMESPACE, "fileMode" ).text( moduleSources.getFileMode() ).endTag( NAMESPACE, "fileMode" );
            }
            if ( moduleSources.getDirectoryMode() != null && !moduleSources.getDirectoryMode().equals( "0755" ) )
            {
                serializer.startTag( NAMESPACE, "directoryMode" ).text( moduleSources.getDirectoryMode() ).endTag( NAMESPACE, "directoryMode" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeModuleSources(ModuleSources, String, XmlSerializer) 

    /**
     * Method writeRepository
     * 
     * @param repository
     * @param serializer
     * @param tagName
     */
    private void writeRepository(Repository repository, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( repository != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( repository.isIncludeMetadata() != false )
            {
                serializer.startTag( NAMESPACE, "includeMetadata" ).text( String.valueOf( repository.isIncludeMetadata() ) ).endTag( NAMESPACE, "includeMetadata" );
            }
            if ( repository.getGroupVersionAlignments() != null && repository.getGroupVersionAlignments().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "groupVersionAlignments" );
                for ( Iterator iter = repository.getGroupVersionAlignments().iterator(); iter.hasNext(); )
                {
                    GroupVersionAlignment o = (GroupVersionAlignment) iter.next();
                    writeGroupVersionAlignment( o, "groupVersionAlignment", serializer );
                }
                serializer.endTag( NAMESPACE, "groupVersionAlignments" );
            }
            if ( repository.getOutputDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "outputDirectory" ).text( repository.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
            }
            if ( repository.getIncludes() != null && repository.getIncludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = repository.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( repository.getExcludes() != null && repository.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = repository.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            if ( repository.getFileMode() != null && !repository.getFileMode().equals( "0644" ) )
            {
                serializer.startTag( NAMESPACE, "fileMode" ).text( repository.getFileMode() ).endTag( NAMESPACE, "fileMode" );
            }
            if ( repository.getDirectoryMode() != null && !repository.getDirectoryMode().equals( "0755" ) )
            {
                serializer.startTag( NAMESPACE, "directoryMode" ).text( repository.getDirectoryMode() ).endTag( NAMESPACE, "directoryMode" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeRepository(Repository, String, XmlSerializer) 

    /**
     * Method writeSetBase
     * 
     * @param setBase
     * @param serializer
     * @param tagName
     */
    private void writeSetBase(SetBase setBase, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( setBase != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( setBase.getOutputDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "outputDirectory" ).text( setBase.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
            }
            if ( setBase.getIncludes() != null && setBase.getIncludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = setBase.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( setBase.getExcludes() != null && setBase.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = setBase.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            if ( setBase.getFileMode() != null && !setBase.getFileMode().equals( "0644" ) )
            {
                serializer.startTag( NAMESPACE, "fileMode" ).text( setBase.getFileMode() ).endTag( NAMESPACE, "fileMode" );
            }
            if ( setBase.getDirectoryMode() != null && !setBase.getDirectoryMode().equals( "0755" ) )
            {
                serializer.startTag( NAMESPACE, "directoryMode" ).text( setBase.getDirectoryMode() ).endTag( NAMESPACE, "directoryMode" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeSetBase(SetBase, String, XmlSerializer) 

}
