/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.AssemblyArchiver;
import org.apache.maven.plugin.assembly.archive.ManifestCreationFinalizer;
import org.apache.maven.plugin.assembly.archive.archiver.PrefixingProxyArchiver;
import org.apache.maven.plugin.assembly.archive.phase.AssemblyArchiverPhase;
import org.apache.maven.plugin.assembly.filter.ComponentsXmlArchiverFileFilter;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.utils.AssemblyFileUtils;
import org.apache.maven.plugin.assembly.utils.AssemblyFormatUtils;
import org.codehaus.plexus.archiver.AbstractArchiveFinalizer;
import org.codehaus.plexus.archiver.ArchiveFileFilter;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FilterEnabled;
import org.codehaus.plexus.archiver.FinalizerEnabled;
import org.codehaus.plexus.archiver.filters.JarSecurityFileFilter;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.archiver.tar.TarLongFileMode;
import org.codehaus.plexus.archiver.war.WarArchiver;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class DefaultAssemblyArchiver
extends AbstractLogEnabled
implements AssemblyArchiver {
    private static final ArchiveFileFilter JAR_SECURITY_FILE_FILTER = new JarSecurityFileFilter();
    private ArchiverManager archiverManager;
    private List assemblyPhases;

    public DefaultAssemblyArchiver() {
    }

    public DefaultAssemblyArchiver(ArchiverManager archiverManager, List assemblyPhases) {
        this.archiverManager = archiverManager;
        this.assemblyPhases = assemblyPhases;
    }

    public File createArchive(Assembly assembly, String fullName, String format, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException {
        String filename = fullName + "." + format;
        AssemblyFileUtils.verifyTempDirectoryAvailability(configSource.getTemporaryRootDirectory(), this.getLogger());
        ComponentsXmlArchiverFileFilter componentsXmlFilter = new ComponentsXmlArchiverFileFilter();
        File outputDirectory = configSource.getOutputDirectory();
        File destFile = new File(outputDirectory, filename);
        try {
            String finalName = configSource.getFinalName();
            String specifiedBasedir = assembly.getBaseDirectory();
            String basedir = finalName;
            if (specifiedBasedir != null) {
                basedir = AssemblyFormatUtils.getOutputDirectory(specifiedBasedir, configSource.getProject(), finalName);
            }
            Archiver archiver = this.createArchiver(format, assembly.isIncludeBaseDirectory(), basedir, configSource, componentsXmlFilter);
            Iterator phaseIterator = this.assemblyPhases.iterator();
            while (phaseIterator.hasNext()) {
                AssemblyArchiverPhase phase = (AssemblyArchiverPhase)phaseIterator.next();
                phase.execute(assembly, archiver, configSource);
            }
            archiver.setDestFile(destFile);
            archiver.createArchive();
        }
        catch (ArchiverException e) {
            throw new ArchiveCreationException("Error creating assembly archive: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ArchiveCreationException("Error creating assembly archive: " + e.getMessage(), e);
        }
        catch (NoSuchArchiverException e) {
            throw new ArchiveCreationException("Unable to obtain archiver for extension '" + format + "'");
        }
        return destFile;
    }

    protected Archiver createArchiver(String format, boolean includeBaseDir, String finalName, AssemblerConfigurationSource configSource, ComponentsXmlArchiverFileFilter componentsXmlFilter) throws ArchiverException, NoSuchArchiverException {
        Archiver archiver = format.startsWith("tar") ? this.createTarArchiver(format, configSource.getTarLongFileMode()) : ("war".equals(format) ? this.createWarArchiver() : this.archiverManager.getArchiver(format));
        this.configureArchiverFilters(archiver, componentsXmlFilter);
        this.configureArchiverFinalizers(archiver, format, configSource, componentsXmlFilter);
        if (includeBaseDir) {
            archiver = new PrefixingProxyArchiver(finalName, archiver);
        }
        return archiver;
    }

    protected void configureArchiverFinalizers(Archiver archiver, String format, AssemblerConfigurationSource configSource, ComponentsXmlArchiverFileFilter componentsXmlFilter) {
        if (archiver instanceof FinalizerEnabled) {
            ArrayList<AbstractArchiveFinalizer> finalizers = new ArrayList<AbstractArchiveFinalizer>();
            finalizers.add(componentsXmlFilter);
            if ("jar".equals(format)) {
                finalizers.add(new ManifestCreationFinalizer(configSource.getProject(), configSource.getJarArchiveConfiguration()));
            }
            ((FinalizerEnabled)archiver).setArchiveFinalizers(finalizers);
        }
    }

    protected void configureArchiverFilters(Archiver archiver, ComponentsXmlArchiverFileFilter componentsXmlFilter) {
        if (archiver instanceof FilterEnabled) {
            ArrayList<ArchiveFileFilter> filters = new ArrayList<ArchiveFileFilter>();
            filters.add(componentsXmlFilter);
            if (archiver instanceof JarArchiver) {
                filters.add(JAR_SECURITY_FILE_FILTER);
            }
            ((FilterEnabled)archiver).setArchiveFilters(filters);
        }
    }

    protected Archiver createWarArchiver() throws NoSuchArchiverException {
        WarArchiver warArchiver = (WarArchiver)this.archiverManager.getArchiver("war");
        warArchiver.setIgnoreWebxml(false);
        return warArchiver;
    }

    protected Archiver createTarArchiver(String format, String tarLongFileMode) throws NoSuchArchiverException, ArchiverException {
        TarArchiver tarArchiver = (TarArchiver)this.archiverManager.getArchiver("tar");
        int index = format.indexOf(46);
        if (index >= 0) {
            TarArchiver.TarCompressionMethod tarCompressionMethod = new TarArchiver.TarCompressionMethod();
            String compression = format.substring(index + 1);
            if ("gz".equals(compression)) {
                tarCompressionMethod.setValue("gzip");
            } else if ("bz2".equals(compression)) {
                tarCompressionMethod.setValue("bzip2");
            } else {
                throw new IllegalArgumentException("Unknown compression format: " + compression);
            }
            tarArchiver.setCompression(tarCompressionMethod);
        }
        TarLongFileMode tarFileMode = new TarLongFileMode();
        tarFileMode.setValue(tarLongFileMode);
        tarArchiver.setLongfile(tarFileMode);
        return tarArchiver;
    }
}

