/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.artifact;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.assembly.artifact.DependencyResolver;
import org.apache.maven.plugin.assembly.utils.FilterUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.apache.maven.shared.artifact.filter.ScopeArtifactFilter;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;

public class DefaultDependencyResolver
extends AbstractLogEnabled
implements DependencyResolver {
    private ArtifactResolver resolver;
    private ArtifactMetadataSource metadataSource;
    private ArtifactFactory factory;

    public DefaultDependencyResolver() {
    }

    public DefaultDependencyResolver(ArtifactResolver resolver, ArtifactMetadataSource metadataSource, ArtifactFactory factory, Logger logger) {
        this.resolver = resolver;
        this.metadataSource = metadataSource;
        this.factory = factory;
        this.enableLogging(logger);
    }

    public Set resolveDependencies(MavenProject project, String scope, ArtifactRepository localRepository, List remoteRepositories) throws InvalidDependencyVersionException, ArtifactResolutionException, ArtifactNotFoundException {
        List repos = this.aggregateRemoteArtifactRepositories(remoteRepositories, project);
        ScopeArtifactFilter filter = new ScopeArtifactFilter(scope);
        Artifact artifact = this.factory.createBuildArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), project.getPackaging());
        Set dependencyArtifacts = MavenMetadataSource.createArtifacts((ArtifactFactory)this.factory, (List)project.getDependencies(), null, (ArtifactFilter)filter, (MavenProject)project);
        ArtifactResolutionResult result = this.resolver.resolveTransitively(dependencyArtifacts, artifact, localRepository, repos, this.metadataSource, (ArtifactFilter)filter);
        this.getLogger().debug("While resolving dependencies of " + project.getId() + ":");
        FilterUtils.reportFilteringStatistics(Collections.singleton(filter), this.getLogger());
        return result.getArtifacts();
    }

    private List aggregateRemoteArtifactRepositories(List remoteRepositories, MavenProject project) {
        ArrayList<List> repoLists = new ArrayList<List>();
        repoLists.add(remoteRepositories);
        repoLists.add(project.getRemoteArtifactRepositories());
        ArrayList<ArtifactRepository> remoteRepos = new ArrayList<ArtifactRepository>();
        HashSet<String> encounteredUrls = new HashSet<String>();
        Iterator listIterator = repoLists.iterator();
        while (listIterator.hasNext()) {
            List repositoryList = (List)listIterator.next();
            if (repositoryList == null || repositoryList.isEmpty()) continue;
            Iterator it = repositoryList.iterator();
            while (it.hasNext()) {
                ArtifactRepository repo = (ArtifactRepository)it.next();
                if (encounteredUrls.contains(repo.getUrl())) continue;
                remoteRepos.add(repo);
                encounteredUrls.add(repo.getUrl());
            }
        }
        return remoteRepos;
    }
}

