/*
 * $Id$
 */

package org.apache.maven.plugin.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         Configures a filter for files headed into the assembly
 * archive, to enable
 *         aggregation of various types of descriptor fragments,
 * such as components.xml,
 *         web.xml, etc.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class ContainerDescriptorHandlerConfig implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The handler's plexus role-hint, for lookup from
     * the container.
     *           
     */
    private String handlerName;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The handler's plexus role-hint, for lookup from
     * the container.
     *           
     * 
     * @return String
     */
    public String getHandlerName()
    {
        return this.handlerName;
    } //-- String getHandlerName() 

    /**
     * Set 
     *             The handler's plexus role-hint, for lookup from
     * the container.
     *           
     * 
     * @param handlerName
     */
    public void setHandlerName(String handlerName)
    {
        this.handlerName = handlerName;
    } //-- void setHandlerName(String) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
