package org.apache.maven.plugin.assembly.mojos;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.project.MavenProject;

/**
 * Assemble an application bundle or distribution from an assembly descriptor into the
 * target directory structure but do not generate the final archive. This goal should be used from
 * the command line, and if building a multimodule project it should be used from the root POM.
 * It is the unarchived counterpart to <code>assembly:assembly</code>.
 * Consider using <code>assembly:directory-inline</code> or <code>assembly:directory-single</code> for binding assembly generation to the lifecycle.
 *
 * @version $Id: DirectoryMojo.java 610981 2008-01-10 23:10:00Z vsiveton $
 * @goal directory
 * @execute phase="package"
 * @aggregator
 */
public class DirectoryMojo
    extends AbstractDirectoryMojo
{
    /**
     * Get the executed project from the forked lifecycle.
     *
     * @parameter expression="${executedProject}"
     */
    private MavenProject executedProject;

    public MavenProject getProject()
    {
        return executedProject;
    }
}
