/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.phase;

import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.phase.AssemblyArchiverPhase;
import org.apache.maven.plugin.assembly.archive.task.AddDependencySetsTask;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.resolved.ResolvedAssembly;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;

@Component(role=AssemblyArchiverPhase.class, hint="dependency-sets")
public class DependencySetAssemblyPhase
extends AbstractLogEnabled
implements AssemblyArchiverPhase {
    @Requirement
    private MavenProjectBuilder projectBuilder;
    @Requirement
    private ArchiverManager archiverManager;

    public DependencySetAssemblyPhase() {
    }

    public DependencySetAssemblyPhase(MavenProjectBuilder projectBuilder, Logger logger) {
        this.projectBuilder = projectBuilder;
        this.enableLogging(logger);
    }

    public void execute(ResolvedAssembly assembly, Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException {
        AddDependencySetsTask task = new AddDependencySetsTask(assembly.getDependencySets(), assembly.getResolvedDependencySetArtifacts(), configSource.getProject(), this.projectBuilder, this.archiverManager, this.getLogger());
        task.execute(archiver, configSource);
    }
}

