/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changelog;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-changelog-plugin:2.2", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Changelog Plugin", 0);
        this.append(sb, "Produce SCM changelog reports.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 4 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "changelog".equals(this.goal)) {
            this.append(sb, "changelog:changelog", 0);
            this.append(sb, "Generate a changelog report.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "Input dir. Directory where the files under SCM control are located.", 3);
                this.append(sb, "", 0);
                this.append(sb, "commentFormat", 2);
                this.append(sb, "Comment format string used for interrogating the revision control system. Currently only used by the ClearcaseChangeLogGenerator.", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: connection)", 2);
                this.append(sb, "Allows the user to choose which scm connection to use when connecting to the scm. Can either be 'connection' or 'developerConnection'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dateFormat (Default: yyyy-MM-dd HH:mm:ss)", 2);
                this.append(sb, "Used to specify the date format of the log entries that are retrieved from your SCM system.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dates", 2);
                this.append(sb, "Used to specify the absolute date (or list of dates) to start log entries from.", 3);
                this.append(sb, "", 0);
                this.append(sb, "developers", 2);
                this.append(sb, "List of developers to be shown on the report.", 3);
                this.append(sb, "", 0);
                this.append(sb, "displayChangeSetDetailUrl", 2);
                this.append(sb, "A template string that is used to create the changeset URL. If not defined no change set link will be created. There is one special token that you can use in your template:\n-\t%REV% - this is the changeset revision\n\nExample: http://fisheye.sourceforge.net/changelog/a-project/?cs=%REV%\n\nNote: If you don't supply the %REV% token in your template, the revision will simply be appended to your template URL.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "displayFileDetailUrl (Default: ${project.scm.url})", 2);
                this.append(sb, "A template string that is used to create the URL to the file details. There is a special token that you can use in your template:\n-\t%FILE% - this is the path to a file\n\nExample: http://checkstyle.cvs.sourceforge.net/checkstyle%FILE%?view=markup\n\nNote: If you don't supply the token in your template, the path of the file will simply be appended to your template URL.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "displayFileRevDetailUrl", 2);
                this.append(sb, "A template string that is used to create the revision aware URL to the file details in a similar fashion to the displayFileDetailUrl. When a report contains both file and file revision information, as in the Change Log report, this template string can be used to create a revision aware URL to the file details. If not defined this template string defaults to the same value as the displayFileDetailUrl and thus revision number aware links will not be used. There are two special tokens that you can use in your template:\n-\t%FILE% - this is the path to a file\n-\t%REV% - this is the revision of the file\n\nExample: http://fisheye.sourceforge.net/browse/a-project/%FILE%?r=%REV%\n\nNote: If you don't supply the %FILE% token in your template, the path of the file will simply be appended to your template URL.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "headingDateFormat (Default: yyyy-MM-dd)", 2);
                this.append(sb, "Used to specify the format to use for the dates in the headings of the report.", 3);
                this.append(sb, "", 0);
                this.append(sb, "issueIDRegexPattern (Default: [a-zA-Z]{2,}-\\d+)", 2);
                this.append(sb, "A pattern used to identify 'issue tracker' IDs such as those used by JIRA, Bugzilla and alike in the SCM commit messages. Any matched patterns are replaced with issueLinkUrl URL. The default value is a JIRA-style issue identification pattern.", 3);
                this.append(sb, "", 0);
                this.append(sb, "issueLinkUrl (Default: http://jira.codehaus.org/browse/%ISSUE%)", 2);
                this.append(sb, "The issue tracker URL used when replacing any matched issueIDRegexPattern found in the SCM commit messages. The default is URL is the codehaus JIRA URL. If %ISSUE% is found in the URL it is replaced with the matched issue ID, otherwise the matched issue ID is appended to the URL.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputEncoding (Default: ISO-8859-1)", 2);
                this.append(sb, "Output encoding for the xml document", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputXML", 2);
                this.append(sb, "Output file for xml document", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputXMLExpiration (Default: 60)", 2);
                this.append(sb, "Allows the user to make changelog regenerate the changelog.xml file for the specified time in minutes.", 3);
                this.append(sb, "", 0);
                this.append(sb, "passphrase", 2);
                this.append(sb, "The passphrase (used by java svn).", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The user password (used by svn and starteam protocol).", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKey", 2);
                this.append(sb, "The private key (used by java svn).", 3);
                this.append(sb, "", 0);
                this.append(sb, "range (Default: -1)", 2);
                this.append(sb, "Used to specify the number of days of log entries to retrieve.", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmUrl", 2);
                this.append(sb, "The URL to view the scm. Basis for external links from the generated report.", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "The system properties to use (needed by the perforce scm provider).", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The url of tags base directory (used by svn protocol).", 3);
                this.append(sb, "", 0);
                this.append(sb, "tags", 2);
                this.append(sb, "Used to specify the tag (or list of tags) to start log entries from.", 3);
                this.append(sb, "", 0);
                this.append(sb, "type (Default: range)", 2);
                this.append(sb, "Used to specify whether to build the log using range, tag or date.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The user name (used by svn and starteam protocol).", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "dev-activity".equals(this.goal)) {
            this.append(sb, "changelog:dev-activity", 0);
            this.append(sb, "Generate a developer activity report.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "Input dir. Directory where the files under SCM control are located.", 3);
                this.append(sb, "", 0);
                this.append(sb, "commentFormat", 2);
                this.append(sb, "Comment format string used for interrogating the revision control system. Currently only used by the ClearcaseChangeLogGenerator.", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: connection)", 2);
                this.append(sb, "Allows the user to choose which scm connection to use when connecting to the scm. Can either be 'connection' or 'developerConnection'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dateFormat (Default: yyyy-MM-dd HH:mm:ss)", 2);
                this.append(sb, "Used to specify the date format of the log entries that are retrieved from your SCM system.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dates", 2);
                this.append(sb, "Used to specify the absolute date (or list of dates) to start log entries from.", 3);
                this.append(sb, "", 0);
                this.append(sb, "developers", 2);
                this.append(sb, "List of developers to be shown on the report.", 3);
                this.append(sb, "", 0);
                this.append(sb, "displayChangeSetDetailUrl", 2);
                this.append(sb, "A template string that is used to create the changeset URL. If not defined no change set link will be created. There is one special token that you can use in your template:\n-\t%REV% - this is the changeset revision\n\nExample: http://fisheye.sourceforge.net/changelog/a-project/?cs=%REV%\n\nNote: If you don't supply the %REV% token in your template, the revision will simply be appended to your template URL.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "displayFileDetailUrl (Default: ${project.scm.url})", 2);
                this.append(sb, "A template string that is used to create the URL to the file details. There is a special token that you can use in your template:\n-\t%FILE% - this is the path to a file\n\nExample: http://checkstyle.cvs.sourceforge.net/checkstyle%FILE%?view=markup\n\nNote: If you don't supply the token in your template, the path of the file will simply be appended to your template URL.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "displayFileRevDetailUrl", 2);
                this.append(sb, "A template string that is used to create the revision aware URL to the file details in a similar fashion to the displayFileDetailUrl. When a report contains both file and file revision information, as in the Change Log report, this template string can be used to create a revision aware URL to the file details. If not defined this template string defaults to the same value as the displayFileDetailUrl and thus revision number aware links will not be used. There are two special tokens that you can use in your template:\n-\t%FILE% - this is the path to a file\n-\t%REV% - this is the revision of the file\n\nExample: http://fisheye.sourceforge.net/browse/a-project/%FILE%?r=%REV%\n\nNote: If you don't supply the %FILE% token in your template, the path of the file will simply be appended to your template URL.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "headingDateFormat (Default: yyyy-MM-dd)", 2);
                this.append(sb, "Used to specify the format to use for the dates in the headings of the report.", 3);
                this.append(sb, "", 0);
                this.append(sb, "issueIDRegexPattern (Default: [a-zA-Z]{2,}-\\d+)", 2);
                this.append(sb, "A pattern used to identify 'issue tracker' IDs such as those used by JIRA, Bugzilla and alike in the SCM commit messages. Any matched patterns are replaced with issueLinkUrl URL. The default value is a JIRA-style issue identification pattern.", 3);
                this.append(sb, "", 0);
                this.append(sb, "issueLinkUrl (Default: http://jira.codehaus.org/browse/%ISSUE%)", 2);
                this.append(sb, "The issue tracker URL used when replacing any matched issueIDRegexPattern found in the SCM commit messages. The default is URL is the codehaus JIRA URL. If %ISSUE% is found in the URL it is replaced with the matched issue ID, otherwise the matched issue ID is appended to the URL.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputEncoding (Default: ISO-8859-1)", 2);
                this.append(sb, "Output encoding for the xml document", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputXML", 2);
                this.append(sb, "Output file for xml document", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputXMLExpiration (Default: 60)", 2);
                this.append(sb, "Allows the user to make changelog regenerate the changelog.xml file for the specified time in minutes.", 3);
                this.append(sb, "", 0);
                this.append(sb, "passphrase", 2);
                this.append(sb, "The passphrase (used by java svn).", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The user password (used by svn and starteam protocol).", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKey", 2);
                this.append(sb, "The private key (used by java svn).", 3);
                this.append(sb, "", 0);
                this.append(sb, "range (Default: -1)", 2);
                this.append(sb, "Used to specify the number of days of log entries to retrieve.", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmUrl", 2);
                this.append(sb, "The URL to view the scm. Basis for external links from the generated report.", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "The system properties to use (needed by the perforce scm provider).", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The url of tags base directory (used by svn protocol).", 3);
                this.append(sb, "", 0);
                this.append(sb, "tags", 2);
                this.append(sb, "Used to specify the tag (or list of tags) to start log entries from.", 3);
                this.append(sb, "", 0);
                this.append(sb, "type (Default: range)", 2);
                this.append(sb, "Used to specify whether to build the log using range, tag or date.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The user name (used by svn and starteam protocol).", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "file-activity".equals(this.goal)) {
            this.append(sb, "changelog:file-activity", 0);
            this.append(sb, "Generate a file activity report.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "Input dir. Directory where the files under SCM control are located.", 3);
                this.append(sb, "", 0);
                this.append(sb, "commentFormat", 2);
                this.append(sb, "Comment format string used for interrogating the revision control system. Currently only used by the ClearcaseChangeLogGenerator.", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: connection)", 2);
                this.append(sb, "Allows the user to choose which scm connection to use when connecting to the scm. Can either be 'connection' or 'developerConnection'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dateFormat (Default: yyyy-MM-dd HH:mm:ss)", 2);
                this.append(sb, "Used to specify the date format of the log entries that are retrieved from your SCM system.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dates", 2);
                this.append(sb, "Used to specify the absolute date (or list of dates) to start log entries from.", 3);
                this.append(sb, "", 0);
                this.append(sb, "developers", 2);
                this.append(sb, "List of developers to be shown on the report.", 3);
                this.append(sb, "", 0);
                this.append(sb, "displayChangeSetDetailUrl", 2);
                this.append(sb, "A template string that is used to create the changeset URL. If not defined no change set link will be created. There is one special token that you can use in your template:\n-\t%REV% - this is the changeset revision\n\nExample: http://fisheye.sourceforge.net/changelog/a-project/?cs=%REV%\n\nNote: If you don't supply the %REV% token in your template, the revision will simply be appended to your template URL.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "displayFileDetailUrl (Default: ${project.scm.url})", 2);
                this.append(sb, "A template string that is used to create the URL to the file details. There is a special token that you can use in your template:\n-\t%FILE% - this is the path to a file\n\nExample: http://checkstyle.cvs.sourceforge.net/checkstyle%FILE%?view=markup\n\nNote: If you don't supply the token in your template, the path of the file will simply be appended to your template URL.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "displayFileRevDetailUrl", 2);
                this.append(sb, "A template string that is used to create the revision aware URL to the file details in a similar fashion to the displayFileDetailUrl. When a report contains both file and file revision information, as in the Change Log report, this template string can be used to create a revision aware URL to the file details. If not defined this template string defaults to the same value as the displayFileDetailUrl and thus revision number aware links will not be used. There are two special tokens that you can use in your template:\n-\t%FILE% - this is the path to a file\n-\t%REV% - this is the revision of the file\n\nExample: http://fisheye.sourceforge.net/browse/a-project/%FILE%?r=%REV%\n\nNote: If you don't supply the %FILE% token in your template, the path of the file will simply be appended to your template URL.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "headingDateFormat (Default: yyyy-MM-dd)", 2);
                this.append(sb, "Used to specify the format to use for the dates in the headings of the report.", 3);
                this.append(sb, "", 0);
                this.append(sb, "issueIDRegexPattern (Default: [a-zA-Z]{2,}-\\d+)", 2);
                this.append(sb, "A pattern used to identify 'issue tracker' IDs such as those used by JIRA, Bugzilla and alike in the SCM commit messages. Any matched patterns are replaced with issueLinkUrl URL. The default value is a JIRA-style issue identification pattern.", 3);
                this.append(sb, "", 0);
                this.append(sb, "issueLinkUrl (Default: http://jira.codehaus.org/browse/%ISSUE%)", 2);
                this.append(sb, "The issue tracker URL used when replacing any matched issueIDRegexPattern found in the SCM commit messages. The default is URL is the codehaus JIRA URL. If %ISSUE% is found in the URL it is replaced with the matched issue ID, otherwise the matched issue ID is appended to the URL.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputEncoding (Default: ISO-8859-1)", 2);
                this.append(sb, "Output encoding for the xml document", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputXML", 2);
                this.append(sb, "Output file for xml document", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputXMLExpiration (Default: 60)", 2);
                this.append(sb, "Allows the user to make changelog regenerate the changelog.xml file for the specified time in minutes.", 3);
                this.append(sb, "", 0);
                this.append(sb, "passphrase", 2);
                this.append(sb, "The passphrase (used by java svn).", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The user password (used by svn and starteam protocol).", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKey", 2);
                this.append(sb, "The private key (used by java svn).", 3);
                this.append(sb, "", 0);
                this.append(sb, "range (Default: -1)", 2);
                this.append(sb, "Used to specify the number of days of log entries to retrieve.", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmUrl", 2);
                this.append(sb, "The URL to view the scm. Basis for external links from the generated report.", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "The system properties to use (needed by the perforce scm provider).", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The url of tags base directory (used by svn protocol).", 3);
                this.append(sb, "", 0);
                this.append(sb, "tags", 2);
                this.append(sb, "Used to specify the tag (or list of tags) to start log entries from.", 3);
                this.append(sb, "", 0);
                this.append(sb, "type (Default: range)", 2);
                this.append(sb, "Used to specify whether to build the log using range, tag or date.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The user name (used by svn and starteam protocol).", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "changelog:help", 0);
            this.append(sb, "Display help information on maven-changelog-plugin.\nCall\n\u00a0\u00a0mvn\u00a0changelog:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

