/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changelog;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.changelog.ChangeLog;
import org.apache.maven.plugins.changelog.scm.provider.svn.svnexe.command.info.SvnInfoCommandExpanded;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.command.info.InfoItem;
import org.apache.maven.scm.command.info.InfoScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;

@Mojo(name="changelog")
public class ChangeLogReport
extends AbstractMavenReport {
    private static final String FILE_TOKEN = "%FILE%";
    private static final String ISSUE_TOKEN = "%ISSUE%";
    private static final String REV_TOKEN = "%REV%";
    private static final int DEFAULT_RANGE = 30;
    public static final String DEFAULT_ISSUE_ID_REGEX_PATTERN = "[a-zA-Z]{2,}-\\d+";
    private static final String DEFAULT_ISSUE_LINK_URL = "https://issues.apache.org/jira/browse/%ISSUE%";
    @Parameter(property="changelog.headingDateFormat", defaultValue="yyyy-MM-dd")
    private String headingDateFormat = "yyyy-MM-dd";
    @Parameter(property="changelog.type", defaultValue="range", required=true)
    private String type;
    @Parameter(property="changelog.range", defaultValue="-1")
    private int range;
    @Parameter
    private List<String> dates;
    @Parameter
    private List<String> tags;
    @Parameter(property="changelog.dateFormat", defaultValue="yyyy-MM-dd HH:mm:ss", required=true)
    private String dateFormat;
    @Parameter(property="basedir", required=true)
    private File basedir;
    @Parameter(defaultValue="${project.build.directory}/changelog.xml", required=true)
    private File outputXML;
    @Parameter(property="outputXMLExpiration", defaultValue="60", required=true)
    private int outputXMLExpiration;
    @Parameter(property="changelog.outputEncoding", defaultValue="${project.reporting.outputEncoding}")
    private String outputEncoding;
    @Parameter(property="username")
    private String username;
    @Parameter(property="password")
    private String password;
    @Parameter(property="privateKey")
    private String privateKey;
    @Parameter(property="passphrase")
    private String passphrase;
    @Parameter(property="tagBase")
    private String tagBase;
    @Parameter(property="project.scm.url")
    protected String scmUrl;
    @Parameter(property="changelog.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="encodeFileUri", defaultValue="false")
    protected boolean encodeFileUri;
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="settings.offline", required=true, readonly=true)
    private boolean offline;
    @Component
    private ScmManager manager;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(defaultValue="connection", required=true)
    private String connectionType;
    @Parameter(property="omitFileAndRevision", defaultValue="false")
    private boolean omitFileAndRevision;
    @Parameter(property="displayFileDetailUrl", defaultValue="${project.scm.url}")
    protected String displayFileDetailUrl;
    @Parameter(property="issueIDRegexPattern", defaultValue="[a-zA-Z]{2,}-\\d+", required=true)
    private String issueIDRegexPattern;
    @Parameter(property="issueLinkUrl", defaultValue="https://issues.apache.org/jira/browse/%ISSUE%", required=true)
    private String issueLinkUrl;
    @Parameter(property="displayChangeSetDetailUrl")
    protected String displayChangeSetDetailUrl;
    @Parameter(property="displayFileRevDetailUrl")
    protected String displayFileRevDetailUrl;
    @Parameter(property="project.developers")
    protected List<Developer> developers;
    @Parameter
    private Map<String, String> providerImplementations;
    private String rptRepository;
    private String rptOneRepoParam;
    private String rptMultiRepoParam;
    private String connection;
    private HashMap<String, Developer> developersById;
    private HashMap<String, Developer> developersByName;
    @Parameter
    private Properties systemProperties;
    private final Pattern sinkFileNamePattern = Pattern.compile("\\\\");

    public void executeReport(Locale locale) throws MavenReportException {
        if (!this.basedir.exists()) {
            this.doGenerateEmptyReport(this.getBundle(locale), this.getSink());
            return;
        }
        if (this.providerImplementations != null) {
            for (Map.Entry<String, String> entry : this.providerImplementations.entrySet()) {
                String providerType = entry.getKey();
                String providerImplementation = entry.getValue();
                this.getLog().info((CharSequence)("Change the default '" + providerType + "' provider implementation to '" + providerImplementation + "'."));
                this.manager.setScmProviderImplementation(providerType, providerImplementation);
            }
        }
        this.initializeDefaultConfigurationParameters();
        this.initializeDeveloperMaps();
        this.verifySCMTypeParams();
        if (this.systemProperties != null) {
            for (Object o : this.systemProperties.keySet()) {
                String key = (String)o;
                String value = this.systemProperties.getProperty(key);
                System.setProperty(key, value);
                this.getLog().debug((CharSequence)("Setting system property: " + key + '=' + value));
            }
        }
        this.doGenerateReport(this.getChangedSets(), this.getBundle(locale), this.getSink());
    }

    private void initializeDefaultConfigurationParameters() {
        if (this.displayFileRevDetailUrl == null || this.displayFileRevDetailUrl.isEmpty()) {
            this.displayFileRevDetailUrl = this.displayFileDetailUrl;
        }
    }

    private void initializeDeveloperMaps() {
        this.developersById = new HashMap();
        this.developersByName = new HashMap();
        if (this.developers != null) {
            for (Developer developer : this.developers) {
                this.developersById.put(developer.getId(), developer);
                this.developersByName.put(developer.getName(), developer);
            }
        }
    }

    protected List<ChangeLogSet> getChangedSets() throws MavenReportException {
        List<ChangeLogSet> changelogList = null;
        if (!this.outputXML.isAbsolute()) {
            this.outputXML = new File(this.project.getBasedir(), this.outputXML.getPath());
        }
        if (this.outputXML.exists() && this.outputXMLExpiration > 0 && (long)this.outputXMLExpiration * 60000L > System.currentTimeMillis() - this.outputXML.lastModified()) {
            try {
                this.getLog().info((CharSequence)"Using existing changelog.xml...");
                changelogList = ChangeLog.loadChangedSets(new InputStreamReader(Files.newInputStream(this.outputXML.toPath(), new OpenOption[0]), this.getOutputEncoding()));
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception e) {
                throw new MavenReportException("An error occurred while parsing " + this.outputXML.getAbsolutePath(), e);
            }
        }
        if (changelogList == null) {
            if (this.offline) {
                throw new MavenReportException("This report requires online mode.");
            }
            this.getLog().info((CharSequence)("Generating changed sets xml to: " + this.outputXML.getAbsolutePath()));
            changelogList = this.generateChangeSetsFromSCM();
            try {
                this.writeChangelogXml(changelogList);
            }
            catch (IOException e) {
                throw new MavenReportException("Can't create " + this.outputXML.getAbsolutePath(), (Exception)e);
            }
        }
        return changelogList;
    }

    private void writeChangelogXml(List<ChangeLogSet> changelogList) throws IOException {
        StringBuilder changelogXml = new StringBuilder();
        changelogXml.append("<?xml version=\"1.0\" encoding=\"").append(this.getOutputEncoding()).append("\"?>\n");
        changelogXml.append("<changelog>");
        for (ChangeLogSet changelogSet : changelogList) {
            changelogXml.append("\n  ");
            String changeset = changelogSet.toXML(this.getOutputEncoding());
            if (changeset.startsWith("<?xml")) {
                int idx = changeset.indexOf("?>") + 2;
                changeset = changeset.substring(idx);
            }
            changelogXml.append(changeset);
        }
        changelogXml.append("\n</changelog>");
        this.outputXML.getParentFile().mkdirs();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(Files.newOutputStream(this.outputXML.toPath(), new OpenOption[0])), this.getOutputEncoding());
        writer.write(changelogXml.toString());
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    protected List<ChangeLogSet> generateChangeSetsFromSCM() throws MavenReportException {
        try {
            ArrayList<ChangeLogSet> changeSets = new ArrayList<ChangeLogSet>();
            ScmRepository repository = this.getScmRepository();
            ScmProvider provider = this.manager.getProviderByRepository(repository);
            if ("range".equals(this.type)) {
                ChangeLogScmResult result = provider.changeLog(repository, new ScmFileSet(this.basedir), null, null, this.range, (ScmBranch)null, this.dateFormat);
                this.checkResult((ScmResult)result);
                changeSets.add(result.getChangeLog());
            } else if ("tag".equals(this.type)) {
                Iterator<String> tagsIter = this.tags.iterator();
                String startTag = tagsIter.next();
                String endTag = null;
                if (tagsIter.hasNext()) {
                    while (tagsIter.hasNext()) {
                        endTag = tagsIter.next();
                        String endRevision = this.getRevisionForTag(endTag, repository, provider);
                        String startRevision = this.getRevisionForTag(startTag, repository, provider);
                        ChangeLogScmResult result = provider.changeLog(repository, new ScmFileSet(this.basedir), (ScmVersion)new ScmRevision(startRevision), (ScmVersion)new ScmRevision(endRevision));
                        this.checkResult((ScmResult)result);
                        result.getChangeLog().setStartVersion((ScmVersion)new ScmRevision(startTag));
                        result.getChangeLog().setEndVersion((ScmVersion)new ScmRevision(endTag));
                        changeSets.add(result.getChangeLog());
                        startTag = endTag;
                    }
                } else {
                    String startRevision = this.getRevisionForTag(startTag, repository, provider);
                    String endRevision = this.getRevisionForTag(endTag, repository, provider);
                    ChangeLogScmResult result = provider.changeLog(repository, new ScmFileSet(this.basedir), (ScmVersion)new ScmRevision(startRevision), (ScmVersion)new ScmRevision(endRevision));
                    this.checkResult((ScmResult)result);
                    result.getChangeLog().setStartVersion((ScmVersion)new ScmRevision(startTag));
                    result.getChangeLog().setEndVersion(null);
                    changeSets.add(result.getChangeLog());
                }
            } else if ("date".equals(this.type)) {
                Iterator<String> dateIter = this.dates.iterator();
                String startDate = dateIter.next();
                String endDate = null;
                if (dateIter.hasNext()) {
                    while (dateIter.hasNext()) {
                        endDate = dateIter.next();
                        ChangeLogScmResult result = provider.changeLog(repository, new ScmFileSet(this.basedir), this.parseDate(startDate), this.parseDate(endDate), 0, (ScmBranch)null);
                        this.checkResult((ScmResult)result);
                        changeSets.add(result.getChangeLog());
                        startDate = endDate;
                    }
                } else {
                    ChangeLogScmResult result = provider.changeLog(repository, new ScmFileSet(this.basedir), this.parseDate(startDate), this.parseDate(endDate), 0, (ScmBranch)null);
                    this.checkResult((ScmResult)result);
                    changeSets.add(result.getChangeLog());
                }
            } else {
                throw new MavenReportException("The type '" + this.type + "' isn't supported.");
            }
            this.filter(changeSets);
            return changeSets;
        }
        catch (ScmException e) {
            throw new MavenReportException("Cannot run changelog command : ", (Exception)((Object)e));
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException("An error has occurred during changelog command : ", (Exception)((Object)e));
        }
    }

    private String getRevisionForTag(String tag, ScmRepository repository, ScmProvider provider) throws ScmException {
        if (repository.getProvider().equals("svn")) {
            if (tag == null) {
                return "HEAD";
            }
            SvnInfoCommandExpanded infoCommand = new SvnInfoCommandExpanded();
            InfoScmResult infoScmResult = infoCommand.executeInfoTagCommand((SvnScmProviderRepository)repository.getProviderRepository(), new ScmFileSet(this.basedir), tag, null, false, null);
            if (infoScmResult.getInfoItems().isEmpty()) {
                throw new ScmException("There is no tag named '" + tag + "' in the Subversion repository.");
            }
            InfoItem infoItem = (InfoItem)infoScmResult.getInfoItems().get(0);
            String revision = infoItem.getLastChangedRevision();
            this.getLog().info((CharSequence)String.format("Resolved tag '%s' to revision '%s'", tag, revision));
            return revision;
        }
        return tag;
    }

    private void filter(List<ChangeLogSet> changeSets) {
        List<Pattern> include = this.compilePatterns(this.includes);
        List<Pattern> exclude = this.compilePatterns(this.excludes);
        if (this.includes == null && this.excludes == null) {
            return;
        }
        for (ChangeLogSet changeLogSet : changeSets) {
            List set = changeLogSet.getChangeSets();
            this.filter(set, include, exclude);
        }
    }

    private List<Pattern> compilePatterns(String[] patternArray) {
        if (patternArray == null) {
            return new ArrayList<Pattern>();
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(patternArray.length);
        for (String string : patternArray) {
            string = "\\Q" + string + "\\E";
            string = string.replace("**", "\\E.?REPLACEMENT?\\Q");
            string = string.replace("*", "\\E[^/\\\\]?REPLACEMENT?\\Q");
            string = string.replace("?REPLACEMENT?", "*");
            string = string.replace("\\Q\\E", "");
            patterns.add(Pattern.compile(string));
        }
        return patterns;
    }

    private void filter(List<ChangeSet> sets, List<Pattern> includes, List<Pattern> excludes) {
        Iterator<ChangeSet> it = sets.iterator();
        while (it.hasNext()) {
            ChangeSet changeSet = it.next();
            List files = changeSet.getFiles();
            Iterator iterator = files.iterator();
            while (iterator.hasNext()) {
                ChangeFile changeFile = (ChangeFile)iterator.next();
                String name = changeFile.getName();
                if (this.isIncluded(includes, name) && !this.isExcluded(excludes, name)) continue;
                iterator.remove();
            }
            if (!files.isEmpty()) continue;
            it.remove();
        }
    }

    private boolean isExcluded(List<Pattern> excludes, String name) {
        if (excludes == null || excludes.isEmpty()) {
            return false;
        }
        for (Pattern pattern : excludes) {
            if (!pattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean isIncluded(List<Pattern> includes, String name) {
        if (includes == null || includes.isEmpty()) {
            return true;
        }
        for (Pattern pattern : includes) {
            if (!pattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    private Date parseDate(String date) throws MojoExecutionException {
        if (date == null || date.trim().isEmpty()) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return formatter.parse(date);
        }
        catch (ParseException e) {
            throw new MojoExecutionException("Please use this date pattern: " + formatter.toLocalizedPattern(), (Exception)e);
        }
    }

    public ScmRepository getScmRepository() throws ScmException {
        ScmRepository repository;
        try {
            repository = this.manager.makeScmRepository(this.getConnection());
            ScmProviderRepository providerRepo = repository.getProviderRepository();
            if (this.username != null && !this.username.isEmpty()) {
                providerRepo.setUser(this.username);
            }
            if (this.password != null && !this.password.isEmpty()) {
                providerRepo.setPassword(this.password);
            }
            if (repository.getProviderRepository() instanceof ScmProviderRepositoryWithHost) {
                ScmProviderRepositoryWithHost repo = (ScmProviderRepositoryWithHost)repository.getProviderRepository();
                this.loadInfosFromSettings(repo);
                if (this.username != null && !this.username.isEmpty()) {
                    repo.setUser(this.username);
                }
                if (this.password != null && !this.password.isEmpty()) {
                    repo.setPassword(this.password);
                }
                if (this.privateKey != null && !this.privateKey.isEmpty()) {
                    repo.setPrivateKey(this.privateKey);
                }
                if (this.passphrase != null && !this.passphrase.isEmpty()) {
                    repo.setPassphrase(this.passphrase);
                }
            }
            if (this.tagBase != null && !this.tagBase.isEmpty() && repository.getProvider().equals("svn")) {
                SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)repository.getProviderRepository();
                svnRepo.setTagBase(this.tagBase);
            }
        }
        catch (Exception e) {
            throw new ScmException("Can't load the scm provider.", (Throwable)e);
        }
        return repository;
    }

    private void loadInfosFromSettings(ScmProviderRepositoryWithHost repo) {
        if (this.username == null || this.password == null) {
            Server server;
            String host = repo.getHost();
            int port = repo.getPort();
            if (port > 0) {
                host = host + ":" + port;
            }
            if ((server = this.settings.getServer(host)) != null) {
                if (this.username == null) {
                    this.username = this.settings.getServer(host).getUsername();
                }
                if (this.password == null) {
                    this.password = this.settings.getServer(host).getPassword();
                }
                if (this.privateKey == null) {
                    this.privateKey = this.settings.getServer(host).getPrivateKey();
                }
                if (this.passphrase == null) {
                    this.passphrase = this.settings.getServer(host).getPassphrase();
                }
            }
        }
    }

    public void checkResult(ScmResult result) throws MojoExecutionException {
        if (!result.isSuccess()) {
            this.getLog().error((CharSequence)"Provider message:");
            this.getLog().error((CharSequence)(result.getProviderMessage() == null ? "" : result.getProviderMessage()));
            this.getLog().error((CharSequence)"Command output:");
            this.getLog().error((CharSequence)(result.getCommandOutput() == null ? "" : result.getCommandOutput()));
            throw new MojoExecutionException("Command failed.");
        }
    }

    protected String getConnection() throws MavenReportException {
        String scmDeveloper;
        if (this.connection != null) {
            return this.connection;
        }
        if (this.project.getScm() == null) {
            throw new MavenReportException("SCM Connection is not set.");
        }
        String scmConnection = this.project.getScm().getConnection();
        if (scmConnection != null && !scmConnection.isEmpty() && "connection".equalsIgnoreCase(this.connectionType)) {
            this.connection = scmConnection;
        }
        if ((scmDeveloper = this.project.getScm().getDeveloperConnection()) != null && !scmDeveloper.isEmpty() && "developerconnection".equalsIgnoreCase(this.connectionType)) {
            this.connection = scmDeveloper;
        }
        if (this.connection == null || this.connection.isEmpty()) {
            throw new MavenReportException("SCM Connection is not set.");
        }
        return this.connection;
    }

    private void verifySCMTypeParams() throws MavenReportException {
        if ("range".equals(this.type)) {
            if (this.range == -1) {
                this.range = 30;
            }
        } else if ("date".equals(this.type)) {
            if (this.dates == null) {
                throw new MavenReportException("The dates parameter is required when type=\"date\". The value should be the absolute date for the start of the log.");
            }
        } else if ("tag".equals(this.type)) {
            if (this.tags == null) {
                throw new MavenReportException("The tags parameter is required when type=\"tag\".");
            }
        } else {
            throw new MavenReportException("The type parameter has an invalid value: " + this.type + ".  The value should be \"range\", \"date\", or \"tag\".");
        }
    }

    protected void doGenerateEmptyReport(ResourceBundle bundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.changelog.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.changelog.mainTitle"));
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text(bundle.getString("report.changelog.nosources"));
        sink.paragraph_();
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    protected void doGenerateReport(List<ChangeLogSet> changeLogSets, ResourceBundle bundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.changelog.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.changelog.mainTitle"));
        sink.sectionTitle1_();
        this.doSummarySection(changeLogSets, bundle, sink);
        for (ChangeLogSet changeLogSet : changeLogSets) {
            this.doChangedSet(changeLogSet, bundle, sink);
        }
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void doSummarySection(List<ChangeLogSet> changeLogSets, ResourceBundle bundle, Sink sink) {
        sink.paragraph();
        sink.text(bundle.getString("report.changelog.ChangedSetsTotal"));
        sink.text(": " + changeLogSets.size());
        sink.paragraph_();
    }

    private void doChangedSet(ChangeLogSet set, ResourceBundle bundle, Sink sink) {
        sink.section2();
        this.doChangeSetTitle(set, bundle, sink);
        this.doSummary(set, bundle, sink);
        this.doChangedSetTable(set.getChangeSets(), bundle, sink);
        sink.section2_();
    }

    protected void doChangeSetTitle(ChangeLogSet set, ResourceBundle bundle, Sink sink) {
        sink.sectionTitle2();
        SimpleDateFormat headingDateFormater = new SimpleDateFormat(this.headingDateFormat);
        if ("tag".equals(this.type)) {
            if (set.getStartVersion() == null || set.getStartVersion().getName() == null) {
                sink.text(bundle.getString("report.SetTagCreation"));
                if (set.getEndVersion() != null && set.getEndVersion().getName() != null) {
                    sink.text(' ' + bundle.getString("report.SetTagUntil") + " '" + set.getEndVersion() + '\'');
                }
            } else if (set.getEndVersion() == null || set.getEndVersion().getName() == null) {
                sink.text(bundle.getString("report.SetTagSince"));
                sink.text(" '" + set.getStartVersion() + '\'');
            } else {
                sink.text(bundle.getString("report.SetTagBetween"));
                sink.text(" '" + set.getStartVersion() + "' " + bundle.getString("report.And") + " '" + set.getEndVersion() + '\'');
            }
        } else if (set.getStartDate() == null) {
            sink.text(bundle.getString("report.SetRangeUnknown"));
        } else if (set.getEndDate() == null) {
            sink.text(bundle.getString("report.SetRangeSince"));
            sink.text(' ' + headingDateFormater.format(set.getStartDate()));
        } else {
            sink.text(bundle.getString("report.SetRangeBetween"));
            sink.text(' ' + headingDateFormater.format(set.getStartDate()) + ' ' + bundle.getString("report.And") + ' ' + headingDateFormater.format(set.getEndDate()));
        }
        sink.sectionTitle2_();
    }

    protected void doSummary(ChangeLogSet set, ResourceBundle bundle, Sink sink) {
        sink.paragraph();
        sink.text(bundle.getString("report.TotalCommits"));
        sink.text(": " + set.getChangeSets().size());
        sink.lineBreak();
        sink.text(bundle.getString("report.changelog.FilesChanged"));
        sink.text(": " + this.countFilesChanged(set.getChangeSets()));
        sink.paragraph_();
    }

    protected long countFilesChanged(Collection<ChangeSet> entries) {
        if (entries == null) {
            return 0L;
        }
        if (entries.isEmpty()) {
            return 0L;
        }
        HashMap<String, LinkedList<ChangeFile>> fileList = new HashMap<String, LinkedList<ChangeFile>>();
        for (ChangeSet entry : entries) {
            for (ChangeFile file : entry.getFiles()) {
                String name = file.getName();
                LinkedList<ChangeFile> list = (LinkedList<ChangeFile>)fileList.get(name);
                if (list != null) {
                    list.add(file);
                    continue;
                }
                list = new LinkedList<ChangeFile>();
                list.add(file);
                fileList.put(name, list);
            }
        }
        return fileList.size();
    }

    private void doChangedSetTable(Collection<ChangeSet> entries, ResourceBundle bundle, Sink sink) {
        sink.table();
        sink.tableRows(new int[]{1}, false);
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.changelog.timestamp"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.changelog.author"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.changelog.details"));
        sink.tableHeaderCell_();
        sink.tableRow_();
        this.initReportUrls();
        ArrayList<ChangeSet> sortedEntries = new ArrayList<ChangeSet>(entries);
        sortedEntries.sort((changeSet0, changeSet1) -> changeSet1.getDate().compareTo(changeSet0.getDate()));
        for (ChangeSet entry : sortedEntries) {
            this.doChangedSetDetail(entry, sink);
        }
        sink.tableRows_();
        sink.table_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChangedSetDetail(ChangeSet entry, Sink sink) {
        sink.tableRow();
        sink.tableCell();
        sink.text(entry.getDateFormatted() + ' ' + entry.getTimeFormatted());
        sink.tableCell_();
        sink.tableCell();
        this.sinkAuthorDetails(sink, entry.getAuthor());
        sink.tableCell_();
        sink.tableCell();
        if (!this.omitFileAndRevision) {
            this.doChangedFiles(entry.getFiles(), sink);
            sink.lineBreak();
        }
        StringReader sr = new StringReader(entry.getComment());
        BufferedReader br = new BufferedReader(sr);
        try {
            if (this.issueIDRegexPattern != null && !this.issueIDRegexPattern.isEmpty() && this.issueLinkUrl != null && !this.issueLinkUrl.isEmpty()) {
                Pattern pattern = Pattern.compile(this.issueIDRegexPattern);
                String line = br.readLine();
                while (line != null) {
                    this.sinkIssueLink(sink, line, pattern);
                    line = br.readLine();
                    if (line == null) continue;
                    sink.lineBreak();
                }
            } else {
                String line = br.readLine();
                while (line != null) {
                    sink.text(line);
                    line = br.readLine();
                    if (line == null) continue;
                    sink.lineBreak();
                }
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Unable to read the comment of a ChangeSet as a stream.");
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Unable to close a reader.");
            }
            sr.close();
        }
        sink.tableCell_();
        sink.tableRow_();
    }

    private void sinkIssueLink(Sink sink, String line, Pattern pattern) {
        Matcher matcher = pattern.matcher(line);
        int currLoc = 0;
        while (matcher.find()) {
            String link;
            String match = matcher.group();
            if (this.issueLinkUrl.indexOf(ISSUE_TOKEN) > 0) {
                link = this.issueLinkUrl.replaceAll(ISSUE_TOKEN, match);
            } else {
                link = this.issueLinkUrl.endsWith("/") ? this.issueLinkUrl : this.issueLinkUrl + '/';
                link = link + match;
            }
            int startOfMatch = matcher.start();
            String unmatchedText = line.substring(currLoc, startOfMatch);
            currLoc = matcher.end();
            sink.text(unmatchedText);
            sink.link(link);
            sink.text(match);
            sink.link_();
        }
        sink.text(line.substring(currLoc));
    }

    protected void sinkAuthorDetails(Sink sink, String author) {
        Developer developer = this.developersById.get(author);
        if (developer == null) {
            developer = this.developersByName.get(author);
        }
        if (developer != null) {
            sink.link("team-list.html#" + developer.getId());
            sink.text(developer.getName());
            sink.link_();
        } else {
            sink.text(author);
        }
    }

    protected void initReportUrls() {
        if (this.scmUrl != null) {
            int idx = this.scmUrl.indexOf(63);
            if (idx > 0) {
                this.rptRepository = this.scmUrl.substring(0, idx);
                if (this.scmUrl.equals(this.displayFileDetailUrl)) {
                    String rptTmpMultiRepoParam = this.scmUrl.substring(this.rptRepository.length());
                    this.rptOneRepoParam = '?' + rptTmpMultiRepoParam.substring(1);
                    this.rptMultiRepoParam = '&' + rptTmpMultiRepoParam.substring(1);
                }
            } else {
                this.rptRepository = this.scmUrl;
                this.rptOneRepoParam = "";
                this.rptMultiRepoParam = "";
            }
        }
    }

    private void doChangedFiles(List<ChangeFile> files, Sink sink) {
        for (ChangeFile file : files) {
            this.sinkLogFile(sink, file.getName(), file.getRevision());
        }
    }

    private void sinkLogFile(Sink sink, String name, String revision) {
        try {
            String connection = this.getConnection();
            this.generateLinks(connection, name, revision, sink);
        }
        catch (Exception e) {
            this.getLog().debug((Throwable)e);
            sink.text(name + " v " + revision);
        }
        sink.lineBreak();
    }

    protected void generateLinks(String connection, String name, Sink sink) {
        this.generateLinks(connection, name, null, sink);
    }

    protected void generateLinks(String connection, String name, String revision, Sink sink) {
        String linkRev = null;
        String linkFile = revision != null ? this.displayFileRevDetailUrl : this.displayFileDetailUrl;
        if (linkFile != null) {
            if (!linkFile.equals(this.scmUrl)) {
                String linkName = name;
                if (this.encodeFileUri) {
                    try {
                        linkName = URLEncoder.encode(linkName, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                linkFile = linkFile.indexOf(FILE_TOKEN) > 0 ? linkFile.replaceAll(FILE_TOKEN, linkName) : linkFile + linkName;
                if (revision != null && linkFile.indexOf(REV_TOKEN) > 0) {
                    linkFile = linkFile.replaceAll(REV_TOKEN, revision);
                }
            } else if (connection.startsWith("scm:perforce")) {
                String path = this.getAbsolutePath(this.displayFileDetailUrl, name);
                linkFile = path + "?ac=22";
                if (revision != null) {
                    linkRev = path + "?ac=64&rev=" + revision;
                }
            } else if (connection.startsWith("scm:clearcase")) {
                String path = this.getAbsolutePath(this.displayFileDetailUrl, name);
                linkFile = path + this.rptOneRepoParam;
            } else if (connection.indexOf("cvsmonitor.pl") > 0) {
                Pattern cvsMonitorRegex = Pattern.compile("^.*(&amp;module=.*?(?:&amp;|$)).*$");
                String module = cvsMonitorRegex.matcher(this.rptOneRepoParam).replaceAll("$1");
                linkFile = this.displayFileDetailUrl + "?cmd=viewBrowseFile" + module + "&file=" + name;
                if (revision != null) {
                    linkRev = this.rptRepository + "?cmd=viewBrowseVersion" + module + "&file=" + name + "&version=" + revision;
                }
            } else {
                String path = this.getAbsolutePath(this.displayFileDetailUrl, name);
                linkFile = path + this.rptOneRepoParam;
                if (revision != null) {
                    linkRev = path + "?rev=" + revision + "&content-type=text/vnd.viewcvs-markup" + this.rptMultiRepoParam;
                }
            }
        }
        if (linkFile != null) {
            sink.link(linkFile);
            this.sinkFileName(name, sink);
            sink.link_();
        } else {
            this.sinkFileName(name, sink);
        }
        sink.text(" ");
        if (linkRev == null && revision != null && this.displayChangeSetDetailUrl != null) {
            linkRev = this.displayChangeSetDetailUrl.indexOf(REV_TOKEN) > 0 ? this.displayChangeSetDetailUrl.replaceAll(REV_TOKEN, revision) : this.displayChangeSetDetailUrl + revision;
        }
        if (linkRev != null) {
            sink.link(linkRev);
            sink.text("v " + revision);
            sink.link_();
        } else if (revision != null) {
            sink.text("v " + revision);
        }
    }

    private void sinkFileName(String name, Sink sink) {
        String tail;
        String head;
        int pos = (name = this.sinkFileNamePattern.matcher(name).replaceAll("/")).lastIndexOf(47);
        if (pos < 0) {
            head = "";
            tail = name;
        } else {
            head = name.substring(0, pos) + '/';
            tail = name.substring(pos + 1);
        }
        sink.text(head);
        sink.bold();
        sink.text(tail);
        sink.bold_();
    }

    private String getAbsolutePath(String base, String target) {
        String newTarget;
        String baseToken;
        StringBuilder absPath = new StringBuilder();
        StringTokenizer baseTokens = new StringTokenizer(this.sinkFileNamePattern.matcher(base).replaceAll("/"), "/", true);
        StringTokenizer targetTokens = new StringTokenizer(this.sinkFileNamePattern.matcher(target).replaceAll("/"), "/");
        String targetRoot = targetTokens.nextToken();
        while (baseTokens.hasMoreTokens() && !(baseToken = baseTokens.nextToken()).equals(targetRoot)) {
            absPath.append(baseToken);
        }
        if (!absPath.toString().endsWith("/")) {
            absPath.append("/");
        }
        if ((newTarget = target).startsWith("/")) {
            newTarget = newTarget.substring(1);
        }
        return absPath + newTarget;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected String getOutputDirectory() {
        if (!this.outputDirectory.isAbsolute()) {
            this.outputDirectory = new File(this.project.getBasedir(), this.outputDirectory.getPath());
        }
        return this.outputDirectory.getAbsolutePath();
    }

    protected String getOutputEncoding() {
        return this.outputEncoding != null ? this.outputEncoding : "UTF-8";
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.changelog.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.changelog.name");
    }

    public String getOutputName() {
        return "changelog";
    }

    protected ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("scm-activity", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public boolean canGenerateReport() {
        if (this.offline && !this.outputXML.exists()) {
            return false;
        }
        return !this.skip;
    }
}

