/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.announcement;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.announcement.JiraDownloader;
import org.apache.maven.plugin.changes.Action;
import org.apache.maven.plugin.changes.ChangesXML;
import org.apache.maven.plugin.changes.Release;
import org.apache.maven.plugin.jira.JiraXML;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.codehaus.plexus.velocity.VelocityComponent;

public class AnnouncementMojo
extends AbstractMojo {
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    private File outputDirectory;
    private String groupId;
    private String artifactId;
    private String version;
    private String url;
    private String packaging;
    private String finalName;
    private String urlDownload;
    private File xmlPath;
    private String developmentTeam;
    private String introduction;
    private VelocityComponent velocity;
    private String template;
    private String templateDirectory;
    private ChangesXML xml;
    private MavenProject project;
    private Settings settings;
    private boolean generateJiraAnnouncement;
    private String statusIds;
    private String resolutionIds;
    private File jiraXML;
    private int maxEntries;

    public void execute() throws MojoExecutionException {
        if (!this.generateJiraAnnouncement) {
            this.setXml(new ChangesXML(this.getXmlPath(), this.getLog()));
            this.getLog().info((CharSequence)("Creating announcement file from " + this.getXmlPath() + "..."));
            this.doGenerate(this.getXml().getReleaseList());
        } else {
            this.doJiraGenerate();
        }
    }

    public void doGenerate(List releases) throws MojoExecutionException {
        try {
            VelocityContext context = new VelocityContext();
            if (this.getIntroduction() == null || this.getIntroduction().equals("")) {
                this.setIntroduction(this.getUrl());
            }
            context.put("releases", (Object)releases);
            context.put("groupId", (Object)this.getGroupId());
            context.put("artifactId", (Object)this.getArtifactId());
            context.put("version", (Object)this.getVersion());
            context.put("packaging", (Object)this.getPackaging());
            context.put("url", (Object)this.getUrl());
            context.put("release", (Object)this.getLatestRelease(releases));
            context.put("introduction", (Object)this.getIntroduction());
            context.put("developmentTeam", (Object)this.getDevelopmentTeam());
            context.put("finalName", (Object)this.getFinalName());
            context.put("urlDownload", (Object)this.getUrlDownload());
            this.processTemplate((Context)context, this.getOutputDirectory(), this.template);
        }
        catch (ResourceNotFoundException rnfe) {
            throw new MojoExecutionException("Resource not found.", (Exception)((Object)rnfe));
        }
        catch (VelocityException ve) {
            throw new MojoExecutionException(ve.toString(), (Exception)((Object)ve));
        }
    }

    public Release getLatestRelease(List releases) throws MojoExecutionException {
        boolean isFound = false;
        Release release = null;
        String pomVersion = this.getVersion();
        if (pomVersion != null && pomVersion.endsWith(SNAPSHOT_SUFFIX)) {
            pomVersion = pomVersion.substring(0, pomVersion.length() - SNAPSHOT_SUFFIX.length());
        }
        this.getLog().debug((CharSequence)("Found " + releases.size() + " releases."));
        for (int i = 0; i < releases.size(); ++i) {
            release = (Release)releases.get(i);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("The release: " + release.getVersion() + " has " + release.getAction().size() + " actions."));
            }
            if (release.getVersion() == null || !release.getVersion().equals(pomVersion)) continue;
            isFound = true;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found the correct release: " + release.getVersion()));
                this.logRelease(release);
            }
            return release;
        }
        if (!isFound) {
            throw new MojoExecutionException("Couldn't find the release '" + pomVersion + "' among the supplied releases.");
        }
        return release;
    }

    private void logRelease(Release release) {
        Iterator iterator = release.getAction().iterator();
        while (iterator.hasNext()) {
            Action action = (Action)iterator.next();
            this.getLog().debug((CharSequence)("o " + action.getType()));
            this.getLog().debug((CharSequence)("  - " + action.getIssue()));
            this.getLog().debug((CharSequence)("  - " + action.getAction()));
            this.getLog().debug((CharSequence)("  - " + action.getDueTo()));
        }
    }

    public void processTemplate(Context context, File outputDirectory, String template) throws ResourceNotFoundException, VelocityException, MojoExecutionException {
        try {
            File f = new File(outputDirectory, template);
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            FileWriter writer = new FileWriter(f);
            this.getVelocity().getEngine().mergeTemplate(this.templateDirectory + "/" + template, context, (Writer)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            this.getLog().info((CharSequence)("Created template " + f));
        }
        catch (ResourceNotFoundException rnfe) {
            throw new ResourceNotFoundException("Template not found. ( " + this.templateDirectory + "/" + template + " )");
        }
        catch (VelocityException ve) {
            throw new VelocityException(ve.toString());
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                this.getLog().warn(e.getCause());
            }
            throw new MojoExecutionException(e.toString(), e.getCause());
        }
    }

    public void doJiraGenerate() throws MojoExecutionException {
        JiraDownloader jiraDownloader = new JiraDownloader();
        File jiraXMLFile = this.jiraXML;
        jiraDownloader.setLog(this.getLog());
        jiraDownloader.setOutput(jiraXMLFile);
        jiraDownloader.setStatusIds(this.statusIds);
        jiraDownloader.setResolutionIds(this.resolutionIds);
        jiraDownloader.setMavenProject(this.project);
        jiraDownloader.setSettings(this.settings);
        jiraDownloader.setNbEntries(this.maxEntries);
        try {
            jiraDownloader.doExecute();
            if (jiraXMLFile.exists()) {
                JiraXML jiraParser = new JiraXML(jiraXMLFile);
                List issues = jiraParser.getIssueList();
                List releases = JiraXML.getReleases(issues);
                this.getLog().info((CharSequence)"Creating announcement file from JIRA releases...");
                this.doGenerate(releases);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to extract JIRA issues from the downloaded file", e);
        }
    }

    public File getXmlPath() {
        return this.xmlPath;
    }

    public void setXmlPath(File xmlPath) {
        this.xmlPath = xmlPath;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ChangesXML getXml() {
        return this.xml;
    }

    public void setXml(ChangesXML xml) {
        this.xml = xml;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public String getDevelopmentTeam() {
        return this.developmentTeam;
    }

    public void setDevelopmentTeam(String developmentTeam) {
        this.developmentTeam = developmentTeam;
    }

    public String getIntroduction() {
        return this.introduction;
    }

    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public VelocityComponent getVelocity() {
        return this.velocity;
    }

    public void setVelocity(VelocityComponent velocity) {
        this.velocity = velocity;
    }

    public String getFinalName() {
        return this.finalName;
    }

    public void setFinalName(String finalName) {
        this.finalName = finalName;
    }

    public String getUrlDownload() {
        return this.urlDownload;
    }

    public void setUrlDownload(String urlDownload) {
        this.urlDownload = urlDownload;
    }
}

