/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.announcement;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private static final int DEFAULT_WIDTH = 80;
    private static final String DEFAULT_INDENT = HelpMojo.repeat(" ", 2);
    private boolean detail;

    public void execute() throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        sb.append("The 'org.apache.maven.plugins:maven-changes-plugin' plugin has 5 goals:").append("\n");
        sb.append("\n");
        sb.append("changes:jira-report").append("\n");
        Iterator it = HelpMojo.toLines("Goal which downloads issues from the Issue Tracking System and generates a report.").iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        if (this.detail) {
            sb.append("\n");
            sb.append(HelpMojo.repeat(" ", 2));
            sb.append("Available parameters:").append("\n");
            sb.append("\n");
            it = HelpMojo.toLines("columnNames (Default: 'Key,Summary,Status,Resolution,Assignee')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Sets the column names that you want to show in the report. The columns will appear in the report in the same order as you specify them here. Multiple values can be separated by commas.Valid columns are: Key, Summary, Status, Resolution, Assignee, Reporter, Type, Priority, Version, Fix Version and Component.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("component", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Sets the component(s) that you want to limit your report to include. Multiple values can be separated by commas (such as 10011,10012). If this is set to empty - that means all components will be included.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("filter", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Defines the filter parameters to restrict which issues are retrieved from JIRA. The filter parameter uses the same format of url parameters that is used in a JIRA search.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("fixVersionIds", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Sets the fix version id(s) that you want to limit your report to include. These are JIRA's internal version ids, NOT the human readable display ones. Multiple fix versions can be separated by commas. If this is set to empty - that means all fix versions will be included.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("jiraPassword", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Defines the JIRA password for authentication into a private JIRA installation.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("jiraUser", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Defines the JIRA username for authentication into a private JIRA installation.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("maxEntries (Default: '100')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Maximum number of entries to be fetched from JIRA.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("onlyCurrentVersion (Default: 'false')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("If you only want to show issues for the current version in the report. The current version being used is ${project.version} minus any '-SNAPSHOT' suffix.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("outputDirectory", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Report output directory.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("priorityIds", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Sets the priority(s) that you want to limit your report to include. Valid statuses are Blocker, Critical, Major, Minor and Trivial. Multiple values can be separated by commas. If this is set to empty - that means all priorities will be included.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("resolutionIds (Default: 'Fixed')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Sets the resolution(s) that you want to fetch from JIRA. Valid resolutions are: Unresolved, Fixed, Won't Fix, Duplicate, Incomplete and Cannot Reproduce. Multiple values can be separated by commas.Note: In versions 2.0-beta-3 and earlier this parameter had no default value.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("sortColumnNames (Default: 'Priority DESC, Created DESC')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Sets the column names that you want to sort the report by. Add DESC following the column name to specify descending sequence. For example Fix Version DESC, Type sorts first by the Fix Version in descending order and then by Type in ascending order. By default sorting is done in ascending order, but is possible to specify ASC for consistency. The previous example would then become Fix Version DESC, Type ASC.Valid columns are: Key, Summary, Status, Resolution, Assignee, Reporter, Type, Priority, Version, Fix Version, Component, Created and Updated.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("statusIds (Default: 'Closed')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Sets the status(es) that you want to fetch from JIRA. Valid statuses are: Open, In Progress, Reopened, Resolved and Closed. Multiple values can be separated by commas.Note: In versions 2.0-beta-3 and earlier this parameter had no default value.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("typeIds", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Sets the types(s) that you want to limit your report to include. Valid types are: Bug, New Feature, Task, Improvement, Wish, Test and Sub-task. Multiple values can be separated by commas. If this is set to empty - that means all types will be included.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("webPassword", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Defines the http password for basic authentication into the JIRA webserver.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("webUser", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Defines the http user for basic authentication into the JIRA webserver.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
        }
        sb.append("\n");
        sb.append("changes:announcement-mail").append("\n");
        it = HelpMojo.toLines("Goal which sends an announcement through email.").iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        if (this.detail) {
            sb.append("\n");
            sb.append(HelpMojo.repeat(" ", 2));
            sb.append("Available parameters:").append("\n");
            sb.append("\n");
            it = HelpMojo.toLines("fromDeveloperId", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The id of the developer sending the announcement mail. Only used if the mailSender attribute is not set. In this case, this should match the id of one of the developers in the pom. If a matching developer is not found, then the first developer in the pom will be used.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("mailSender", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Defines the sender of the announcement if the list of developer is empty or if the sender is not a member of the development team.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("password", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The password used to send the email.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("smtpHost", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Smtp Server.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("smtpPort (Default: '25')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Port.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("sslMode (Default: 'false')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("If the email should be sent in SSL mode.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("subject (Default: '[ANNOUNCEMENT] - ${project.name} ${project.version} released')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Subject for the email.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("template (Default: 'announcement.vm')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The Velocity template used to format the announcement.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("templateOutputDirectory", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Directory which contains the template for announcement email.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("toAddresses", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Recipient email address.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("username", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The username used to send the email.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
        }
        sb.append("\n");
        sb.append("changes:announcement-generate").append("\n");
        it = HelpMojo.toLines("Goal which generate the template for an announcement.").iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        if (this.detail) {
            sb.append("\n");
            sb.append(HelpMojo.repeat(" ", 2));
            sb.append("Available parameters:").append("\n");
            sb.append("\n");
            it = HelpMojo.toLines("developmentTeam (Default: '${project.name} team')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Name of the team that develops the artifact.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("finalName", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The name of the artifact to be used in the announcement.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("generateJiraAnnouncement (Default: 'false')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Flag to determine if the plugin will generate a JIRA announcement.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("introduction", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Short description or introduction of the released artifact.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("maxEntries (Default: '25')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The maximum number of issues to include.Note: In versions 2.0-beta-3 and earlier this parameter was called 'nbEntries'.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("outputDirectory", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Directory where the template file will be generated.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("resolutionIds (Default: 'Fixed')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Only fixed issues are needed.Note: In versions 2.0-beta-3 and earlier this parameter was called 'resolutionId'.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("statusIds (Default: 'Closed')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Only closed issues are needed.Note: In versions 2.0-beta-3 and earlier this parameter was called 'statusId'.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("template (Default: 'announcement.vm')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The Velocity template used to format the announcement.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("templateDirectory (Default: 'org/apache/maven/plugin/announcement')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Directory that contains the template.Note: This directory must be a subdirectory of /src/main/resources/.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("url", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Distribution url of the artifact.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("urlDownload", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("URL where the artifact can be downloaded. If not specified, no URL is used.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("xmlPath", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The path of the changes.xml file.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
        }
        sb.append("\n");
        sb.append("changes:changes-report").append("\n");
        it = HelpMojo.toLines("Goal which creates a nicely formatted Changes Report in html format from a changes.xml file.").iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        if (this.detail) {
            sb.append("\n");
            sb.append(HelpMojo.repeat(" ", 2));
            sb.append("Available parameters:").append("\n");
            sb.append("\n");
            it = HelpMojo.toLines("issueLinkTemplate", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Template string that is used to discover the URL to use to display an issue report. There are 2 template tokens you can use. %URL%: this is computed by getting the <issueManagement>/<url> value from the POM, and removing the last '/' and everything that comes after it. %ISSUE% : this is the issue number.Note: In versions of this plugin prior to 2.0-beta-2 this parameter was called link_template.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("outputDirectory", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Report output directory.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("xmlPath", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The path of the changes.xml file that will be converted into an html report.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
        }
        sb.append("\n");
        sb.append("changes:help").append("\n");
        it = HelpMojo.toLines("Display help information on 'org.apache.maven.plugins:maven-changes-plugin' plugin. Call 'mvn changes:help -Ddetail=true' to display all details.").iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private static List toLines(String str) {
        return HelpMojo.toLines(str, DEFAULT_INDENT, 80);
    }

    private static List toLines(String str, String indent, int size) {
        ArrayList<String> sentences = new ArrayList<String>();
        if (indent == null) {
            indent = "";
        }
        if (size < 0) {
            throw new IllegalArgumentException("size should be positive");
        }
        StringBuffer tmp = new StringBuffer(indent);
        StringTokenizer tokenizer = new StringTokenizer(str, " ");
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (tmp.length() + word.length() + 1 < size) {
                tmp.append(word).append(" ");
                continue;
            }
            sentences.add(tmp.toString());
            tmp = new StringBuffer(indent);
            tmp.append(word).append(" ");
        }
        if (tmp.toString().length() > 0) {
            sentences.add(tmp.toString());
        }
        return sentences;
    }
}

