/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.plugin.changes.AbstractChangesReport;
import org.apache.maven.plugin.changes.ChangesReportGenerator;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.FileUtils;

public class ChangesMojo
extends AbstractChangesReport {
    private File xmlPath;
    private String issueLinkTemplate;
    private String url;

    public boolean canGenerateReport() {
        return this.xmlPath.isFile();
    }

    private void copyStaticResources() throws MavenReportException {
        String pluginResourcesBase = "org/apache/maven/plugin/changes";
        String[] resourceNames = new String[]{"images/add.gif", "images/fix.gif", "images/icon_help_sml.gif", "images/remove.gif", "images/rss.png", "images/update.gif"};
        try {
            this.getLog().debug((CharSequence)"Copying static resources.");
            for (int i = 0; i < resourceNames.length; ++i) {
                URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("org/apache/maven/plugin/changes/" + resourceNames[i]);
                FileUtils.copyURLToFile((URL)url, (File)new File(this.outputDirectory, resourceNames[i]));
            }
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to copy static resources.");
        }
    }

    public void executeReport(Locale locale) throws MavenReportException {
        ChangesReportGenerator report = new ChangesReportGenerator(this.xmlPath, this.getLog());
        if (this.url == null || this.url.trim().equals("")) {
            this.getLog().warn((CharSequence)"No Issue Management/URL defined in pom.xml.  Links to your issues will not work correctly.");
        }
        report.setIssueLink(this.issueLinkTemplate);
        report.setUrl(this.url);
        report.doGenerateReport(this.getBundle(locale), this.getSink());
        this.copyStaticResources();
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.changes.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.changes.description");
    }

    public String getOutputName() {
        return "changes-report";
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("changes-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

