/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes;

import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.util.HtmlTools;
import org.apache.maven.plugin.changes.Action;
import org.apache.maven.plugin.changes.ChangesXML;
import org.apache.maven.plugin.changes.Release;
import org.apache.maven.plugin.logging.Log;

public class ChangesReportGenerator {
    private ChangesXML report;
    private String issueLink;
    private String url;

    public ChangesReportGenerator() {
    }

    public ChangesReportGenerator(File xmlPath, Log log) {
        this.report = new ChangesXML(xmlPath, log);
    }

    public void setIssueLink(String issueLink) {
        this.issueLink = issueLink;
    }

    public String getIssueLink() {
        return this.issueLink;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void doGenerateEmptyReport(ResourceBundle bundle, Sink sink, String message) {
        this.sinkBeginReport(sink, bundle);
        sink.text(message);
        this.sinkEndReport(sink);
    }

    public void doGenerateReport(ResourceBundle bundle, Sink sink) {
        this.sinkBeginReport(sink, bundle);
        this.constructReleaseHistory(sink, bundle);
        this.constructReleases(sink, bundle);
        this.sinkEndReport(sink);
    }

    private void constructActions(Sink sink, List actionList, ResourceBundle bundle) {
        sink.table();
        sink.tableRow();
        this.sinkHeader(sink, bundle.getString("report.changes.label.type"));
        this.sinkHeader(sink, bundle.getString("report.changes.label.changes"));
        this.sinkHeader(sink, bundle.getString("report.changes.label.by"));
        sink.tableRow_();
        for (int idx = 0; idx < actionList.size(); ++idx) {
            Action action = (Action)actionList.get(idx);
            sink.tableRow();
            this.sinkShowTypeIcon(sink, action.getType());
            sink.tableCell();
            sink.rawText(action.getAction());
            if (StringUtils.isNotEmpty((String)action.getIssue())) {
                sink.text(" " + bundle.getString("report.changes.text.fixes") + " ");
                if (StringUtils.isEmpty((String)this.url)) {
                    sink.text(action.getIssue());
                } else {
                    sink.link(this.parseIssueLink(action.getIssue()));
                    sink.text(action.getIssue());
                    sink.link_();
                }
                sink.text(".");
            }
            if (StringUtils.isNotEmpty((String)action.getDueTo())) {
                sink.text(" " + bundle.getString("report.changes.text.thanx") + " ");
                if (StringUtils.isNotEmpty((String)action.getDueToEmail())) {
                    this.sinkLink(sink, action.getDueTo(), "mailto:" + action.getDueToEmail());
                } else {
                    sink.text(action.getDueTo());
                }
                sink.text(".");
            }
            sink.tableCell_();
            this.sinkCellLink(sink, action.getDev(), "team-list.html#" + action.getDev());
            sink.tableRow_();
        }
        sink.table_();
    }

    private void constructReleaseHistory(Sink sink, ResourceBundle bundle) {
        this.sinkSectionTitle2Anchor(sink, bundle.getString("report.changes.label.releasehistory"), bundle.getString("report.changes.label.releasehistory"));
        List releaseList = this.report.getReleaseList();
        sink.table();
        sink.tableRow();
        this.sinkHeader(sink, bundle.getString("report.changes.label.version"));
        this.sinkHeader(sink, bundle.getString("report.changes.label.date"));
        this.sinkHeader(sink, bundle.getString("report.changes.label.description"));
        sink.tableRow_();
        for (int idx = 0; idx < releaseList.size(); ++idx) {
            Release release = (Release)releaseList.get(idx);
            sink.tableRow();
            this.sinkCellLink(sink, release.getVersion(), "#" + HtmlTools.encodeId((String)release.getVersion()));
            this.sinkCell(sink, release.getDateRelease());
            this.sinkCell(sink, release.getDescription());
            sink.tableRow_();
        }
        sink.table_();
        sink.lineBreak();
        sink.lineBreak();
    }

    private void constructReleases(Sink sink, ResourceBundle bundle) {
        List releaseList = this.report.getReleaseList();
        for (int idx = 0; idx < releaseList.size(); ++idx) {
            Release release = (Release)releaseList.get(idx);
            this.sinkSectionTitle2Anchor(sink, bundle.getString("report.changes.label.release") + " " + release.getVersion() + " - " + release.getDateRelease(), HtmlTools.encodeId((String)release.getVersion()));
            this.constructActions(sink, release.getAction(), bundle);
        }
    }

    private String parseIssueLink(String issue) {
        String parseLink = "";
        String url = this.url.substring(0, this.url.lastIndexOf("/"));
        parseLink = this.issueLink.replaceFirst("%ISSUE%", issue);
        parseLink = parseLink.replaceFirst("%URL%", url);
        return parseLink;
    }

    private void sinkBeginReport(Sink sink, ResourceBundle bundle) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.changes.header"));
        sink.title_();
        if (StringUtils.isNotEmpty((String)this.report.getAuthor())) {
            sink.author();
            sink.text(this.report.getAuthor());
            sink.author_();
        }
        sink.head_();
        sink.body();
        this.sinkSectionTitle1Anchor(sink, bundle.getString("report.changes.header"), bundle.getString("report.changes.header"));
    }

    private void sinkCell(Sink sink, String text) {
        sink.tableCell();
        sink.text(text);
        sink.tableCell_();
    }

    private void sinkCellLink(Sink sink, String text, String link) {
        sink.tableCell();
        this.sinkLink(sink, text, link);
        sink.tableCell_();
    }

    private void sinkEndReport(Sink sink) {
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void sinkFigure(String image, Sink sink) {
        sink.figure();
        sink.figureGraphics(image);
        sink.figure_();
    }

    private void sinkFigure(String image, Sink sink, String altText) {
        sink.figure();
        sink.figureGraphics(image);
        sink.figureCaption();
        sink.text(altText);
        sink.figureCaption_();
        sink.figure_();
    }

    private void sinkHeader(Sink sink, String header) {
        sink.tableHeaderCell();
        sink.text(header);
        sink.tableHeaderCell_();
    }

    private void sinkLink(Sink sink, String text, String link) {
        sink.link(link);
        sink.text(text);
        sink.link_();
    }

    private void sinkSectionTitle1Anchor(Sink sink, String text, String anchor) {
        sink.sectionTitle1();
        sink.anchor(anchor);
        sink.anchor_();
        sink.text(text);
        sink.sectionTitle1_();
    }

    private void sinkSectionTitle2Anchor(Sink sink, String text, String anchor) {
        sink.sectionTitle2();
        sink.anchor(anchor);
        sink.anchor_();
        sink.text(text);
        sink.sectionTitle2_();
    }

    private void sinkShowTypeIcon(Sink sink, String type) {
        String image = "";
        String altText = "";
        if (type == null) {
            image = "images/icon_help_sml.gif";
            altText = "?";
        } else if (type.equals("fix")) {
            image = "images/fix.gif";
            altText = "fix";
        } else if (type.equals("update")) {
            image = "images/update.gif";
            altText = "update";
        } else if (type.equals("add")) {
            image = "images/add.gif";
            altText = "add";
        } else if (type.equals("remove")) {
            image = "images/remove.gif";
            altText = "remove";
        }
        sink.tableCell();
        this.sinkFigure(image, sink, altText);
        sink.tableCell_();
    }
}

